/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIpamPoolResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteIpamPoolResponse.Builder, DeleteIpamPoolResponse> {
    private static final SdkField<IpamPool> IPAM_POOL_FIELD = SdkField
            .<IpamPool> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPool")
            .getter(getter(DeleteIpamPoolResponse::ipamPool))
            .setter(setter(Builder::ipamPool))
            .constructor(IpamPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPool")
                    .unmarshallLocationName("ipamPool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IpamPool", IPAM_POOL_FIELD);
                }
            });

    private final IpamPool ipamPool;

    private DeleteIpamPoolResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPool = builder.ipamPool;
    }

    /**
     * <p>
     * Information about the results of the deletion.
     * </p>
     * 
     * @return Information about the results of the deletion.
     */
    public final IpamPool ipamPool() {
        return ipamPool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPool());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIpamPoolResponse)) {
            return false;
        }
        DeleteIpamPoolResponse other = (DeleteIpamPoolResponse) obj;
        return Objects.equals(ipamPool(), other.ipamPool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIpamPoolResponse").add("IpamPool", ipamPool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPool":
            return Optional.ofNullable(clazz.cast(ipamPool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIpamPoolResponse, T> g) {
        return obj -> g.apply((DeleteIpamPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIpamPoolResponse> {
        /**
         * <p>
         * Information about the results of the deletion.
         * </p>
         * 
         * @param ipamPool
         *        Information about the results of the deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPool(IpamPool ipamPool);

        /**
         * <p>
         * Information about the results of the deletion.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPool.Builder} avoiding the need to
         * create one manually via {@link IpamPool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPool.Builder#build()} is called immediately and its result is
         * passed to {@link #ipamPool(IpamPool)}.
         * 
         * @param ipamPool
         *        a consumer that will call methods on {@link IpamPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPool(IpamPool)
         */
        default Builder ipamPool(Consumer<IpamPool.Builder> ipamPool) {
            return ipamPool(IpamPool.builder().applyMutation(ipamPool).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamPool ipamPool;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIpamPoolResponse model) {
            super(model);
            ipamPool(model.ipamPool);
        }

        public final IpamPool.Builder getIpamPool() {
            return ipamPool != null ? ipamPool.toBuilder() : null;
        }

        public final void setIpamPool(IpamPool.BuilderImpl ipamPool) {
            this.ipamPool = ipamPool != null ? ipamPool.build() : null;
        }

        @Override
        public final Builder ipamPool(IpamPool ipamPool) {
            this.ipamPool = ipamPool;
            return this;
        }

        @Override
        public DeleteIpamPoolResponse build() {
            return new DeleteIpamPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
