/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVerifiedAccessEndpointResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteVerifiedAccessEndpointResponse.Builder, DeleteVerifiedAccessEndpointResponse> {
    private static final SdkField<VerifiedAccessEndpoint> VERIFIED_ACCESS_ENDPOINT_FIELD = SdkField
            .<VerifiedAccessEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("VerifiedAccessEndpoint")
            .getter(getter(DeleteVerifiedAccessEndpointResponse::verifiedAccessEndpoint))
            .setter(setter(Builder::verifiedAccessEndpoint))
            .constructor(VerifiedAccessEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpoint")
                    .unmarshallLocationName("verifiedAccessEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VERIFIED_ACCESS_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("VerifiedAccessEndpoint", VERIFIED_ACCESS_ENDPOINT_FIELD);
                }
            });

    private final VerifiedAccessEndpoint verifiedAccessEndpoint;

    private DeleteVerifiedAccessEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpoint = builder.verifiedAccessEndpoint;
    }

    /**
     * <p>
     * Details about the Verified Access endpoint.
     * </p>
     * 
     * @return Details about the Verified Access endpoint.
     */
    public final VerifiedAccessEndpoint verifiedAccessEndpoint() {
        return verifiedAccessEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVerifiedAccessEndpointResponse)) {
            return false;
        }
        DeleteVerifiedAccessEndpointResponse other = (DeleteVerifiedAccessEndpointResponse) obj;
        return Objects.equals(verifiedAccessEndpoint(), other.verifiedAccessEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVerifiedAccessEndpointResponse").add("VerifiedAccessEndpoint", verifiedAccessEndpoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessEndpoint":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVerifiedAccessEndpointResponse, T> g) {
        return obj -> g.apply((DeleteVerifiedAccessEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVerifiedAccessEndpointResponse> {
        /**
         * <p>
         * Details about the Verified Access endpoint.
         * </p>
         * 
         * @param verifiedAccessEndpoint
         *        Details about the Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpoint(VerifiedAccessEndpoint verifiedAccessEndpoint);

        /**
         * <p>
         * Details about the Verified Access endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessEndpoint.Builder} avoiding
         * the need to create one manually via {@link VerifiedAccessEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessEndpoint.Builder#build()} is called immediately and
         * its result is passed to {@link #verifiedAccessEndpoint(VerifiedAccessEndpoint)}.
         * 
         * @param verifiedAccessEndpoint
         *        a consumer that will call methods on {@link VerifiedAccessEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessEndpoint(VerifiedAccessEndpoint)
         */
        default Builder verifiedAccessEndpoint(Consumer<VerifiedAccessEndpoint.Builder> verifiedAccessEndpoint) {
            return verifiedAccessEndpoint(VerifiedAccessEndpoint.builder().applyMutation(verifiedAccessEndpoint).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VerifiedAccessEndpoint verifiedAccessEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVerifiedAccessEndpointResponse model) {
            super(model);
            verifiedAccessEndpoint(model.verifiedAccessEndpoint);
        }

        public final VerifiedAccessEndpoint.Builder getVerifiedAccessEndpoint() {
            return verifiedAccessEndpoint != null ? verifiedAccessEndpoint.toBuilder() : null;
        }

        public final void setVerifiedAccessEndpoint(VerifiedAccessEndpoint.BuilderImpl verifiedAccessEndpoint) {
            this.verifiedAccessEndpoint = verifiedAccessEndpoint != null ? verifiedAccessEndpoint.build() : null;
        }

        @Override
        public final Builder verifiedAccessEndpoint(VerifiedAccessEndpoint verifiedAccessEndpoint) {
            this.verifiedAccessEndpoint = verifiedAccessEndpoint;
            return this;
        }

        @Override
        public DeleteVerifiedAccessEndpointResponse build() {
            return new DeleteVerifiedAccessEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
