/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeNetworkInterfacePermissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkInterfacePermissionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeNetworkInterfacePermissionsResponse.Builder, DescribeNetworkInterfacePermissionsResponse> {
    private static final SdkField<List<NetworkInterfacePermission>> NETWORK_INTERFACE_PERMISSIONS_FIELD = SdkField
            .<List<NetworkInterfacePermission>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfacePermissions")
            .getter(getter(DescribeNetworkInterfacePermissionsResponse::networkInterfacePermissions))
            .setter(setter(Builder::networkInterfacePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePermissions")
                    .unmarshallLocationName("networkInterfacePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkInterfacePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterfacePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeNetworkInterfacePermissionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INTERFACE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NetworkInterfacePermissions", NETWORK_INTERFACE_PERMISSIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<NetworkInterfacePermission> networkInterfacePermissions;

    private final String nextToken;

    private DescribeNetworkInterfacePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissions = builder.networkInterfacePermissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfacePermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkInterfacePermissions() {
        return networkInterfacePermissions != null && !(networkInterfacePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interface permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfacePermissions} method.
     * </p>
     * 
     * @return The network interface permissions.
     */
    public final List<NetworkInterfacePermission> networkInterfacePermissions() {
        return networkInterfacePermissions;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfacePermissions() ? networkInterfacePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacePermissionsResponse)) {
            return false;
        }
        DescribeNetworkInterfacePermissionsResponse other = (DescribeNetworkInterfacePermissionsResponse) obj;
        return hasNetworkInterfacePermissions() == other.hasNetworkInterfacePermissions()
                && Objects.equals(networkInterfacePermissions(), other.networkInterfacePermissions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNetworkInterfacePermissionsResponse")
                .add("NetworkInterfacePermissions", hasNetworkInterfacePermissions() ? networkInterfacePermissions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfacePermissions":
            return Optional.ofNullable(clazz.cast(networkInterfacePermissions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfacePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeNetworkInterfacePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNetworkInterfacePermissionsResponse> {
        /**
         * <p>
         * The network interface permissions.
         * </p>
         * 
         * @param networkInterfacePermissions
         *        The network interface permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> networkInterfacePermissions);

        /**
         * <p>
         * The network interface permissions.
         * </p>
         * 
         * @param networkInterfacePermissions
         *        The network interface permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissions(NetworkInterfacePermission... networkInterfacePermissions);

        /**
         * <p>
         * The network interface permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #networkInterfacePermissions(List<NetworkInterfacePermission>)}.
         * 
         * @param networkInterfacePermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfacePermissions(java.util.Collection<NetworkInterfacePermission>)
         */
        Builder networkInterfacePermissions(Consumer<NetworkInterfacePermission.Builder>... networkInterfacePermissions);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<NetworkInterfacePermission> networkInterfacePermissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacePermissionsResponse model) {
            super(model);
            networkInterfacePermissions(model.networkInterfacePermissions);
            nextToken(model.nextToken);
        }

        public final List<NetworkInterfacePermission.Builder> getNetworkInterfacePermissions() {
            List<NetworkInterfacePermission.Builder> result = NetworkInterfacePermissionListCopier
                    .copyToBuilder(this.networkInterfacePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfacePermissions(
                Collection<NetworkInterfacePermission.BuilderImpl> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copyFromBuilder(networkInterfacePermissions);
        }

        @Override
        public final Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copy(networkInterfacePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(NetworkInterfacePermission... networkInterfacePermissions) {
            networkInterfacePermissions(Arrays.asList(networkInterfacePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(
                Consumer<NetworkInterfacePermission.Builder>... networkInterfacePermissions) {
            networkInterfacePermissions(Stream.of(networkInterfacePermissions)
                    .map(c -> NetworkInterfacePermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeNetworkInterfacePermissionsResponse build() {
            return new DescribeNetworkInterfacePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
