/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSnapshotRequest extends Ec2Request implements
        ToCopyableBuilder<ImportSnapshotRequest.Builder, ImportSnapshotRequest> {
    private static final SdkField<ClientData> CLIENT_DATA_FIELD = SdkField
            .<ClientData> builder(MarshallingType.SDK_POJO)
            .memberName("ClientData")
            .getter(getter(ImportSnapshotRequest::clientData))
            .setter(setter(Builder::clientData))
            .constructor(ClientData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientData")
                    .unmarshallLocationName("ClientData").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ImportSnapshotRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportSnapshotRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<SnapshotDiskContainer> DISK_CONTAINER_FIELD = SdkField
            .<SnapshotDiskContainer> builder(MarshallingType.SDK_POJO)
            .memberName("DiskContainer")
            .getter(getter(ImportSnapshotRequest::diskContainer))
            .setter(setter(Builder::diskContainer))
            .constructor(SnapshotDiskContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskContainer")
                    .unmarshallLocationName("DiskContainer").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ImportSnapshotRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(ImportSnapshotRequest::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(ImportSnapshotRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("KmsKeyId").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoleName")
            .getter(getter(ImportSnapshotRequest::roleName))
            .setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName")
                    .unmarshallLocationName("RoleName").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(ImportSnapshotRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_DATA_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISK_CONTAINER_FIELD, DRY_RUN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD,
            ROLE_NAME_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientData", CLIENT_DATA_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("DiskContainer", DISK_CONTAINER_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("Encrypted", ENCRYPTED_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                    put("RoleName", ROLE_NAME_FIELD);
                    put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
                }
            });

    private final ClientData clientData;

    private final String clientToken;

    private final String description;

    private final SnapshotDiskContainer diskContainer;

    private final Boolean dryRun;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String roleName;

    private final List<TagSpecification> tagSpecifications;

    private ImportSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainer = builder.diskContainer;
        this.dryRun = builder.dryRun;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.roleName = builder.roleName;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The client-specific data.
     * </p>
     * 
     * @return The client-specific data.
     */
    public final ClientData clientData() {
        return clientData;
    }

    /**
     * <p>
     * Token to enable idempotency for VM import requests.
     * </p>
     * 
     * @return Token to enable idempotency for VM import requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description string for the import snapshot task.
     * </p>
     * 
     * @return The description string for the import snapshot task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk container.
     * </p>
     * 
     * @return Information about the disk container.
     */
    public final SnapshotDiskContainer diskContainer() {
        return diskContainer;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS
     * is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key
     *         for EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more
     *         information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon
     *         EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only
     * required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for
     * EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
     * </p>
     * <p>
     * The KMS key identifier may be provided in any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key,
     * the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then the key ID. For
     * example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
     * key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key
     * alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to
     * complete even though you provided an invalid identifier. This action will eventually report failure.
     * </p>
     * <p>
     * The specified KMS key must exist in the Region that the snapshot is being copied to.
     * </p>
     * <p>
     * Amazon EBS does not support asymmetric KMS keys.
     * </p>
     * 
     * @return An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is
     *         only required if you want to use a non-default KMS key; if this parameter is not specified, the default
     *         KMS key for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must
     *         also be set. </p>
     *         <p>
     *         The KMS key identifier may be provided in any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
     *         the key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then
     *         the key ID. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the
     *         Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace,
     *         and then the key alias. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may
     *         appear to complete even though you provided an invalid identifier. This action will eventually report
     *         failure.
     *         </p>
     *         <p>
     *         The specified KMS key must exist in the Region that the snapshot is being copied to.
     *         </p>
     *         <p>
     *         Amazon EBS does not support asymmetric KMS keys.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the role to use when not using the default role, 'vmimport'.
     * </p>
     * 
     * @return The name of the role to use when not using the default role, 'vmimport'.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the import snapshot task during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the import snapshot task during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientData());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskContainer());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest) obj;
        return Objects.equals(clientData(), other.clientData()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description()) && Objects.equals(diskContainer(), other.diskContainer())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(roleName(), other.roleName())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSnapshotRequest").add("ClientData", clientData()).add("ClientToken", clientToken())
                .add("Description", description()).add("DiskContainer", diskContainer()).add("DryRun", dryRun())
                .add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId()).add("RoleName", roleName())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientData":
            return Optional.ofNullable(clazz.cast(clientData()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiskContainer":
            return Optional.ofNullable(clazz.cast(diskContainer()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportSnapshotRequest, T> g) {
        return obj -> g.apply((ImportSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportSnapshotRequest> {
        /**
         * <p>
         * The client-specific data.
         * </p>
         * 
         * @param clientData
         *        The client-specific data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientData(ClientData clientData);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientData.Builder} avoiding the need to
         * create one manually via {@link ClientData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientData.Builder#build()} is called immediately and its result
         * is passed to {@link #clientData(ClientData)}.
         * 
         * @param clientData
         *        a consumer that will call methods on {@link ClientData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientData(ClientData)
         */
        default Builder clientData(Consumer<ClientData.Builder> clientData) {
            return clientData(ClientData.builder().applyMutation(clientData).build());
        }

        /**
         * <p>
         * Token to enable idempotency for VM import requests.
         * </p>
         * 
         * @param clientToken
         *        Token to enable idempotency for VM import requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description string for the import snapshot task.
         * </p>
         * 
         * @param description
         *        The description string for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk container.
         * </p>
         * 
         * @param diskContainer
         *        Information about the disk container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainer(SnapshotDiskContainer diskContainer);

        /**
         * <p>
         * Information about the disk container.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotDiskContainer.Builder} avoiding
         * the need to create one manually via {@link SnapshotDiskContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotDiskContainer.Builder#build()} is called immediately and
         * its result is passed to {@link #diskContainer(SnapshotDiskContainer)}.
         * 
         * @param diskContainer
         *        a consumer that will call methods on {@link SnapshotDiskContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskContainer(SnapshotDiskContainer)
         */
        default Builder diskContainer(Consumer<SnapshotDiskContainer.Builder> diskContainer) {
            return diskContainer(SnapshotDiskContainer.builder().applyMutation(diskContainer).build());
        }

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for
         * EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS
         *        key for EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
         *        Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only
         * required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key
         * for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
         * </p>
         * <p>
         * The KMS key identifier may be provided in any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
         * key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then the key
         * ID. For example,
         * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
         * the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the
         * key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear
         * to complete even though you provided an invalid identifier. This action will eventually report failure.
         * </p>
         * <p>
         * The specified KMS key must exist in the Region that the snapshot is being copied to.
         * </p>
         * <p>
         * Amazon EBS does not support asymmetric KMS keys.
         * </p>
         * 
         * @param kmsKeyId
         *        An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is
         *        only required if you want to use a non-default KMS key; if this parameter is not specified, the
         *        default KMS key for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code>
         *        flag must also be set. </p>
         *        <p>
         *        The KMS key identifier may be provided in any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region
         *        of the key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and
         *        then the key ID. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the
         *        Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code>
         *        namespace, and then the key alias. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may
         *        appear to complete even though you provided an invalid identifier. This action will eventually report
         *        failure.
         *        </p>
         *        <p>
         *        The specified KMS key must exist in the Region that the snapshot is being copied to.
         *        </p>
         *        <p>
         *        Amazon EBS does not support asymmetric KMS keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the role to use when not using the default role, 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role to use when not using the default role, 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The tags to apply to the import snapshot task during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the import snapshot task during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the import snapshot task during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the import snapshot task during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the import snapshot task during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private ClientData clientData;

        private String clientToken;

        private String description;

        private SnapshotDiskContainer diskContainer;

        private Boolean dryRun;

        private Boolean encrypted;

        private String kmsKeyId;

        private String roleName;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotRequest model) {
            super(model);
            clientData(model.clientData);
            clientToken(model.clientToken);
            description(model.description);
            diskContainer(model.diskContainer);
            dryRun(model.dryRun);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            roleName(model.roleName);
            tagSpecifications(model.tagSpecifications);
        }

        public final ClientData.Builder getClientData() {
            return clientData != null ? clientData.toBuilder() : null;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SnapshotDiskContainer.Builder getDiskContainer() {
            return diskContainer != null ? diskContainer.toBuilder() : null;
        }

        public final void setDiskContainer(SnapshotDiskContainer.BuilderImpl diskContainer) {
            this.diskContainer = diskContainer != null ? diskContainer.build() : null;
        }

        @Override
        public final Builder diskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSnapshotRequest build() {
            return new ImportSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
