/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReleaseAddressRequest extends Ec2Request implements
        ToCopyableBuilder<ReleaseAddressRequest.Builder, ReleaseAddressRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(ReleaseAddressRequest::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(ReleaseAddressRequest::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("PublicIp").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup")
            .getter(getter(ReleaseAddressRequest::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("NetworkBorderGroup").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ReleaseAddressRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            PUBLIC_IP_FIELD, NETWORK_BORDER_GROUP_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AllocationId", ALLOCATION_ID_FIELD);
                    put("PublicIp", PUBLIC_IP_FIELD);
                    put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String allocationId;

    private final String publicIp;

    private final String networkBorderGroup;

    private final Boolean dryRun;

    private ReleaseAddressRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.publicIp = builder.publicIp;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The allocation ID. This parameter is required.
     * </p>
     * 
     * @return The allocation ID. This parameter is required.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP
     * addresses.
     * </p>
     * <p>
     * If you provide an incorrect network border group, you receive an <code>InvalidAddress.NotFound</code> error.
     * </p>
     * 
     * @return The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
     *         IP addresses.</p>
     *         <p>
     *         If you provide an incorrect network border group, you receive an <code>InvalidAddress.NotFound</code>
     *         error.
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseAddressRequest)) {
            return false;
        }
        ReleaseAddressRequest other = (ReleaseAddressRequest) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReleaseAddressRequest").add("AllocationId", allocationId()).add("PublicIp", publicIp())
                .add("NetworkBorderGroup", networkBorderGroup()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReleaseAddressRequest, T> g) {
        return obj -> g.apply((ReleaseAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ReleaseAddressRequest> {
        /**
         * <p>
         * The allocation ID. This parameter is required.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param publicIp
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP
         * addresses.
         * </p>
         * <p>
         * If you provide an incorrect network border group, you receive an <code>InvalidAddress.NotFound</code> error.
         * </p>
         * 
         * @param networkBorderGroup
         *        The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services
         *        advertises IP addresses.</p>
         *        <p>
         *        If you provide an incorrect network border group, you receive an <code>InvalidAddress.NotFound</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String allocationId;

        private String publicIp;

        private String networkBorderGroup;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseAddressRequest model) {
            super(model);
            allocationId(model.allocationId);
            publicIp(model.publicIp);
            networkBorderGroup(model.networkBorderGroup);
            dryRun(model.dryRun);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReleaseAddressRequest build() {
            return new ReleaseAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
