/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EventInformation;
import software.amazon.awssdk.services.ec2.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoryRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoryRecord> {
    private static final SdkField<EventInformation> EVENT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventInformation").getter(HistoryRecord.getter(HistoryRecord::eventInformation)).setter(HistoryRecord.setter(Builder::eventInformation)).constructor(EventInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventInformation").unmarshallLocationName("eventInformation").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(HistoryRecord.getter(HistoryRecord::eventTypeAsString)).setter(HistoryRecord.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").unmarshallLocationName("eventType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(HistoryRecord.getter(HistoryRecord::timestamp)).setter(HistoryRecord.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INFORMATION_FIELD, EVENT_TYPE_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventInformation", EVENT_INFORMATION_FIELD);
            this.put("EventType", EVENT_TYPE_FIELD);
            this.put("Timestamp", TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EventInformation eventInformation;
    private final String eventType;
    private final Instant timestamp;

    private HistoryRecord(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    public final EventInformation eventInformation() {
        return this.eventInformation;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord other = (HistoryRecord)obj;
        return Objects.equals(this.eventInformation(), other.eventInformation()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"HistoryRecord").add("EventInformation", (Object)this.eventInformation()).add("EventType", (Object)this.eventTypeAsString()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventInformation": {
                return Optional.ofNullable(clazz.cast(this.eventInformation()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HistoryRecord, T> g) {
        return obj -> g.apply((HistoryRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EventInformation eventInformation;
        private String eventType;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecord model) {
            this.eventInformation(model.eventInformation);
            this.eventType(model.eventType);
            this.timestamp(model.timestamp);
        }

        public final EventInformation.Builder getEventInformation() {
            return this.eventInformation != null ? this.eventInformation.toBuilder() : null;
        }

        public final void setEventInformation(EventInformation.BuilderImpl eventInformation) {
            this.eventInformation = eventInformation != null ? eventInformation.build() : null;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public HistoryRecord build() {
            return new HistoryRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoryRecord> {
        public Builder eventInformation(EventInformation var1);

        default public Builder eventInformation(Consumer<EventInformation.Builder> eventInformation) {
            return this.eventInformation((EventInformation)((EventInformation.Builder)EventInformation.builder().applyMutation(eventInformation)).build());
        }

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder timestamp(Instant var1);
    }
}

