/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.MediaDeviceInfo;
import software.amazon.awssdk.services.ec2.model.MediaDeviceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaAcceleratorInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaAcceleratorInfo> {
    private static final SdkField<List<MediaDeviceInfo>> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accelerators").getter(MediaAcceleratorInfo.getter(MediaAcceleratorInfo::accelerators)).setter(MediaAcceleratorInfo.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators").unmarshallLocationName("accelerators").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaDeviceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_MEDIA_MEMORY_IN_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalMediaMemoryInMiB").getter(MediaAcceleratorInfo.getter(MediaAcceleratorInfo::totalMediaMemoryInMiB)).setter(MediaAcceleratorInfo.setter(Builder::totalMediaMemoryInMiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMediaMemoryInMiB").unmarshallLocationName("totalMediaMemoryInMiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD, TOTAL_MEDIA_MEMORY_IN_MIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Accelerators", ACCELERATORS_FIELD);
            this.put("TotalMediaMemoryInMiB", TOTAL_MEDIA_MEMORY_IN_MIB_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<MediaDeviceInfo> accelerators;
    private final Integer totalMediaMemoryInMiB;

    private MediaAcceleratorInfo(BuilderImpl builder) {
        this.accelerators = builder.accelerators;
        this.totalMediaMemoryInMiB = builder.totalMediaMemoryInMiB;
    }

    public final boolean hasAccelerators() {
        return this.accelerators != null && !(this.accelerators instanceof SdkAutoConstructList);
    }

    public final List<MediaDeviceInfo> accelerators() {
        return this.accelerators;
    }

    public final Integer totalMediaMemoryInMiB() {
        return this.totalMediaMemoryInMiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccelerators() ? this.accelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMediaMemoryInMiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaAcceleratorInfo)) {
            return false;
        }
        MediaAcceleratorInfo other = (MediaAcceleratorInfo)obj;
        return this.hasAccelerators() == other.hasAccelerators() && Objects.equals(this.accelerators(), other.accelerators()) && Objects.equals(this.totalMediaMemoryInMiB(), other.totalMediaMemoryInMiB());
    }

    public final String toString() {
        return ToString.builder((String)"MediaAcceleratorInfo").add("Accelerators", this.hasAccelerators() ? this.accelerators() : null).add("TotalMediaMemoryInMiB", (Object)this.totalMediaMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accelerators": {
                return Optional.ofNullable(clazz.cast(this.accelerators()));
            }
            case "TotalMediaMemoryInMiB": {
                return Optional.ofNullable(clazz.cast(this.totalMediaMemoryInMiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaAcceleratorInfo, T> g) {
        return obj -> g.apply((MediaAcceleratorInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MediaDeviceInfo> accelerators = DefaultSdkAutoConstructList.getInstance();
        private Integer totalMediaMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaAcceleratorInfo model) {
            this.accelerators(model.accelerators);
            this.totalMediaMemoryInMiB(model.totalMediaMemoryInMiB);
        }

        public final List<MediaDeviceInfo.Builder> getAccelerators() {
            List<MediaDeviceInfo.Builder> result = MediaDeviceInfoListCopier.copyToBuilder(this.accelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccelerators(Collection<MediaDeviceInfo.BuilderImpl> accelerators) {
            this.accelerators = MediaDeviceInfoListCopier.copyFromBuilder(accelerators);
        }

        @Override
        public final Builder accelerators(Collection<MediaDeviceInfo> accelerators) {
            this.accelerators = MediaDeviceInfoListCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(MediaDeviceInfo ... accelerators) {
            this.accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<MediaDeviceInfo.Builder> ... accelerators) {
            this.accelerators(Stream.of(accelerators).map(c -> (MediaDeviceInfo)((MediaDeviceInfo.Builder)MediaDeviceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalMediaMemoryInMiB() {
            return this.totalMediaMemoryInMiB;
        }

        public final void setTotalMediaMemoryInMiB(Integer totalMediaMemoryInMiB) {
            this.totalMediaMemoryInMiB = totalMediaMemoryInMiB;
        }

        @Override
        public final Builder totalMediaMemoryInMiB(Integer totalMediaMemoryInMiB) {
            this.totalMediaMemoryInMiB = totalMediaMemoryInMiB;
            return this;
        }

        public MediaAcceleratorInfo build() {
            return new MediaAcceleratorInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaAcceleratorInfo> {
        public Builder accelerators(Collection<MediaDeviceInfo> var1);

        public Builder accelerators(MediaDeviceInfo ... var1);

        public Builder accelerators(Consumer<MediaDeviceInfo.Builder> ... var1);

        public Builder totalMediaMemoryInMiB(Integer var1);
    }
}

