/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BandwidthWeightingType;
import software.amazon.awssdk.services.ec2.model.BandwidthWeightingTypeListCopier;
import software.amazon.awssdk.services.ec2.model.EfaInfo;
import software.amazon.awssdk.services.ec2.model.EnaSupport;
import software.amazon.awssdk.services.ec2.model.NetworkCardInfo;
import software.amazon.awssdk.services.ec2.model.NetworkCardInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInfo> {
    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPerformance").getter(NetworkInfo.getter(NetworkInfo::networkPerformance)).setter(NetworkInfo.setter(Builder::networkPerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance").unmarshallLocationName("networkPerformance").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumNetworkInterfaces").getter(NetworkInfo.getter(NetworkInfo::maximumNetworkInterfaces)).setter(NetworkInfo.setter(Builder::maximumNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces").unmarshallLocationName("maximumNetworkInterfaces").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NETWORK_CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumNetworkCards").getter(NetworkInfo.getter(NetworkInfo::maximumNetworkCards)).setter(NetworkInfo.setter(Builder::maximumNetworkCards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkCards").unmarshallLocationName("maximumNetworkCards").build()}).build();
    private static final SdkField<Integer> DEFAULT_NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultNetworkCardIndex").getter(NetworkInfo.getter(NetworkInfo::defaultNetworkCardIndex)).setter(NetworkInfo.setter(Builder::defaultNetworkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNetworkCardIndex").unmarshallLocationName("defaultNetworkCardIndex").build()}).build();
    private static final SdkField<List<NetworkCardInfo>> NETWORK_CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkCards").getter(NetworkInfo.getter(NetworkInfo::networkCards)).setter(NetworkInfo.setter(Builder::networkCards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCards").unmarshallLocationName("networkCards").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkCardInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV4_ADDRESSES_PER_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4AddressesPerInterface").getter(NetworkInfo.getter(NetworkInfo::ipv4AddressesPerInterface)).setter(NetworkInfo.setter(Builder::ipv4AddressesPerInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4AddressesPerInterface").unmarshallLocationName("ipv4AddressesPerInterface").build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESSES_PER_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressesPerInterface").getter(NetworkInfo.getter(NetworkInfo::ipv6AddressesPerInterface)).setter(NetworkInfo.setter(Builder::ipv6AddressesPerInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesPerInterface").unmarshallLocationName("ipv6AddressesPerInterface").build()}).build();
    private static final SdkField<Boolean> IPV6_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Supported").getter(NetworkInfo.getter(NetworkInfo::ipv6Supported)).setter(NetworkInfo.setter(Builder::ipv6Supported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Supported").unmarshallLocationName("ipv6Supported").build()}).build();
    private static final SdkField<String> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnaSupport").getter(NetworkInfo.getter(NetworkInfo::enaSupportAsString)).setter(NetworkInfo.setter(Builder::enaSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<Boolean> EFA_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EfaSupported").getter(NetworkInfo.getter(NetworkInfo::efaSupported)).setter(NetworkInfo.setter(Builder::efaSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfaSupported").unmarshallLocationName("efaSupported").build()}).build();
    private static final SdkField<EfaInfo> EFA_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EfaInfo").getter(NetworkInfo.getter(NetworkInfo::efaInfo)).setter(NetworkInfo.setter(Builder::efaInfo)).constructor(EfaInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfaInfo").unmarshallLocationName("efaInfo").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_IN_TRANSIT_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EncryptionInTransitSupported").getter(NetworkInfo.getter(NetworkInfo::encryptionInTransitSupported)).setter(NetworkInfo.setter(Builder::encryptionInTransitSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionInTransitSupported").unmarshallLocationName("encryptionInTransitSupported").build()}).build();
    private static final SdkField<Boolean> ENA_SRD_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnaSrdSupported").getter(NetworkInfo.getter(NetworkInfo::enaSrdSupported)).setter(NetworkInfo.setter(Builder::enaSrdSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSupported").unmarshallLocationName("enaSrdSupported").build()}).build();
    private static final SdkField<List<String>> BANDWIDTH_WEIGHTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BandwidthWeightings").getter(NetworkInfo.getter(NetworkInfo::bandwidthWeightingsAsStrings)).setter(NetworkInfo.setter(Builder::bandwidthWeightingsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthWeightings").unmarshallLocationName("bandwidthWeightings").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PERFORMANCE_FIELD, MAXIMUM_NETWORK_INTERFACES_FIELD, MAXIMUM_NETWORK_CARDS_FIELD, DEFAULT_NETWORK_CARD_INDEX_FIELD, NETWORK_CARDS_FIELD, IPV4_ADDRESSES_PER_INTERFACE_FIELD, IPV6_ADDRESSES_PER_INTERFACE_FIELD, IPV6_SUPPORTED_FIELD, ENA_SUPPORT_FIELD, EFA_SUPPORTED_FIELD, EFA_INFO_FIELD, ENCRYPTION_IN_TRANSIT_SUPPORTED_FIELD, ENA_SRD_SUPPORTED_FIELD, BANDWIDTH_WEIGHTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkPerformance", NETWORK_PERFORMANCE_FIELD);
            this.put("MaximumNetworkInterfaces", MAXIMUM_NETWORK_INTERFACES_FIELD);
            this.put("MaximumNetworkCards", MAXIMUM_NETWORK_CARDS_FIELD);
            this.put("DefaultNetworkCardIndex", DEFAULT_NETWORK_CARD_INDEX_FIELD);
            this.put("NetworkCards", NETWORK_CARDS_FIELD);
            this.put("Ipv4AddressesPerInterface", IPV4_ADDRESSES_PER_INTERFACE_FIELD);
            this.put("Ipv6AddressesPerInterface", IPV6_ADDRESSES_PER_INTERFACE_FIELD);
            this.put("Ipv6Supported", IPV6_SUPPORTED_FIELD);
            this.put("EnaSupport", ENA_SUPPORT_FIELD);
            this.put("EfaSupported", EFA_SUPPORTED_FIELD);
            this.put("EfaInfo", EFA_INFO_FIELD);
            this.put("EncryptionInTransitSupported", ENCRYPTION_IN_TRANSIT_SUPPORTED_FIELD);
            this.put("EnaSrdSupported", ENA_SRD_SUPPORTED_FIELD);
            this.put("BandwidthWeightings", BANDWIDTH_WEIGHTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String networkPerformance;
    private final Integer maximumNetworkInterfaces;
    private final Integer maximumNetworkCards;
    private final Integer defaultNetworkCardIndex;
    private final List<NetworkCardInfo> networkCards;
    private final Integer ipv4AddressesPerInterface;
    private final Integer ipv6AddressesPerInterface;
    private final Boolean ipv6Supported;
    private final String enaSupport;
    private final Boolean efaSupported;
    private final EfaInfo efaInfo;
    private final Boolean encryptionInTransitSupported;
    private final Boolean enaSrdSupported;
    private final List<String> bandwidthWeightings;

    private NetworkInfo(BuilderImpl builder) {
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
        this.maximumNetworkCards = builder.maximumNetworkCards;
        this.defaultNetworkCardIndex = builder.defaultNetworkCardIndex;
        this.networkCards = builder.networkCards;
        this.ipv4AddressesPerInterface = builder.ipv4AddressesPerInterface;
        this.ipv6AddressesPerInterface = builder.ipv6AddressesPerInterface;
        this.ipv6Supported = builder.ipv6Supported;
        this.enaSupport = builder.enaSupport;
        this.efaSupported = builder.efaSupported;
        this.efaInfo = builder.efaInfo;
        this.encryptionInTransitSupported = builder.encryptionInTransitSupported;
        this.enaSrdSupported = builder.enaSrdSupported;
        this.bandwidthWeightings = builder.bandwidthWeightings;
    }

    public final String networkPerformance() {
        return this.networkPerformance;
    }

    public final Integer maximumNetworkInterfaces() {
        return this.maximumNetworkInterfaces;
    }

    public final Integer maximumNetworkCards() {
        return this.maximumNetworkCards;
    }

    public final Integer defaultNetworkCardIndex() {
        return this.defaultNetworkCardIndex;
    }

    public final boolean hasNetworkCards() {
        return this.networkCards != null && !(this.networkCards instanceof SdkAutoConstructList);
    }

    public final List<NetworkCardInfo> networkCards() {
        return this.networkCards;
    }

    public final Integer ipv4AddressesPerInterface() {
        return this.ipv4AddressesPerInterface;
    }

    public final Integer ipv6AddressesPerInterface() {
        return this.ipv6AddressesPerInterface;
    }

    public final Boolean ipv6Supported() {
        return this.ipv6Supported;
    }

    public final EnaSupport enaSupport() {
        return EnaSupport.fromValue(this.enaSupport);
    }

    public final String enaSupportAsString() {
        return this.enaSupport;
    }

    public final Boolean efaSupported() {
        return this.efaSupported;
    }

    public final EfaInfo efaInfo() {
        return this.efaInfo;
    }

    public final Boolean encryptionInTransitSupported() {
        return this.encryptionInTransitSupported;
    }

    public final Boolean enaSrdSupported() {
        return this.enaSrdSupported;
    }

    public final List<BandwidthWeightingType> bandwidthWeightings() {
        return BandwidthWeightingTypeListCopier.copyStringToEnum(this.bandwidthWeightings);
    }

    public final boolean hasBandwidthWeightings() {
        return this.bandwidthWeightings != null && !(this.bandwidthWeightings instanceof SdkAutoConstructList);
    }

    public final List<String> bandwidthWeightingsAsStrings() {
        return this.bandwidthWeightings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNetworkCards());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultNetworkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkCards() ? this.networkCards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4AddressesPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressesPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Supported());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.efaSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.efaInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInTransitSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSrdSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBandwidthWeightings() ? this.bandwidthWeightingsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInfo)) {
            return false;
        }
        NetworkInfo other = (NetworkInfo)obj;
        return Objects.equals(this.networkPerformance(), other.networkPerformance()) && Objects.equals(this.maximumNetworkInterfaces(), other.maximumNetworkInterfaces()) && Objects.equals(this.maximumNetworkCards(), other.maximumNetworkCards()) && Objects.equals(this.defaultNetworkCardIndex(), other.defaultNetworkCardIndex()) && this.hasNetworkCards() == other.hasNetworkCards() && Objects.equals(this.networkCards(), other.networkCards()) && Objects.equals(this.ipv4AddressesPerInterface(), other.ipv4AddressesPerInterface()) && Objects.equals(this.ipv6AddressesPerInterface(), other.ipv6AddressesPerInterface()) && Objects.equals(this.ipv6Supported(), other.ipv6Supported()) && Objects.equals(this.enaSupportAsString(), other.enaSupportAsString()) && Objects.equals(this.efaSupported(), other.efaSupported()) && Objects.equals(this.efaInfo(), other.efaInfo()) && Objects.equals(this.encryptionInTransitSupported(), other.encryptionInTransitSupported()) && Objects.equals(this.enaSrdSupported(), other.enaSrdSupported()) && this.hasBandwidthWeightings() == other.hasBandwidthWeightings() && Objects.equals(this.bandwidthWeightingsAsStrings(), other.bandwidthWeightingsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInfo").add("NetworkPerformance", (Object)this.networkPerformance()).add("MaximumNetworkInterfaces", (Object)this.maximumNetworkInterfaces()).add("MaximumNetworkCards", (Object)this.maximumNetworkCards()).add("DefaultNetworkCardIndex", (Object)this.defaultNetworkCardIndex()).add("NetworkCards", this.hasNetworkCards() ? this.networkCards() : null).add("Ipv4AddressesPerInterface", (Object)this.ipv4AddressesPerInterface()).add("Ipv6AddressesPerInterface", (Object)this.ipv6AddressesPerInterface()).add("Ipv6Supported", (Object)this.ipv6Supported()).add("EnaSupport", (Object)this.enaSupportAsString()).add("EfaSupported", (Object)this.efaSupported()).add("EfaInfo", (Object)this.efaInfo()).add("EncryptionInTransitSupported", (Object)this.encryptionInTransitSupported()).add("EnaSrdSupported", (Object)this.enaSrdSupported()).add("BandwidthWeightings", this.hasBandwidthWeightings() ? this.bandwidthWeightingsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkPerformance": {
                return Optional.ofNullable(clazz.cast(this.networkPerformance()));
            }
            case "MaximumNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.maximumNetworkInterfaces()));
            }
            case "MaximumNetworkCards": {
                return Optional.ofNullable(clazz.cast(this.maximumNetworkCards()));
            }
            case "DefaultNetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.defaultNetworkCardIndex()));
            }
            case "NetworkCards": {
                return Optional.ofNullable(clazz.cast(this.networkCards()));
            }
            case "Ipv4AddressesPerInterface": {
                return Optional.ofNullable(clazz.cast(this.ipv4AddressesPerInterface()));
            }
            case "Ipv6AddressesPerInterface": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressesPerInterface()));
            }
            case "Ipv6Supported": {
                return Optional.ofNullable(clazz.cast(this.ipv6Supported()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupportAsString()));
            }
            case "EfaSupported": {
                return Optional.ofNullable(clazz.cast(this.efaSupported()));
            }
            case "EfaInfo": {
                return Optional.ofNullable(clazz.cast(this.efaInfo()));
            }
            case "EncryptionInTransitSupported": {
                return Optional.ofNullable(clazz.cast(this.encryptionInTransitSupported()));
            }
            case "EnaSrdSupported": {
                return Optional.ofNullable(clazz.cast(this.enaSrdSupported()));
            }
            case "BandwidthWeightings": {
                return Optional.ofNullable(clazz.cast(this.bandwidthWeightingsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInfo, T> g) {
        return obj -> g.apply((NetworkInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkPerformance;
        private Integer maximumNetworkInterfaces;
        private Integer maximumNetworkCards;
        private Integer defaultNetworkCardIndex;
        private List<NetworkCardInfo> networkCards = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv4AddressesPerInterface;
        private Integer ipv6AddressesPerInterface;
        private Boolean ipv6Supported;
        private String enaSupport;
        private Boolean efaSupported;
        private EfaInfo efaInfo;
        private Boolean encryptionInTransitSupported;
        private Boolean enaSrdSupported;
        private List<String> bandwidthWeightings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInfo model) {
            this.networkPerformance(model.networkPerformance);
            this.maximumNetworkInterfaces(model.maximumNetworkInterfaces);
            this.maximumNetworkCards(model.maximumNetworkCards);
            this.defaultNetworkCardIndex(model.defaultNetworkCardIndex);
            this.networkCards(model.networkCards);
            this.ipv4AddressesPerInterface(model.ipv4AddressesPerInterface);
            this.ipv6AddressesPerInterface(model.ipv6AddressesPerInterface);
            this.ipv6Supported(model.ipv6Supported);
            this.enaSupport(model.enaSupport);
            this.efaSupported(model.efaSupported);
            this.efaInfo(model.efaInfo);
            this.encryptionInTransitSupported(model.encryptionInTransitSupported);
            this.enaSrdSupported(model.enaSrdSupported);
            this.bandwidthWeightingsWithStrings(model.bandwidthWeightings);
        }

        public final String getNetworkPerformance() {
            return this.networkPerformance;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return this.maximumNetworkInterfaces;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final Integer getMaximumNetworkCards() {
            return this.maximumNetworkCards;
        }

        public final void setMaximumNetworkCards(Integer maximumNetworkCards) {
            this.maximumNetworkCards = maximumNetworkCards;
        }

        @Override
        public final Builder maximumNetworkCards(Integer maximumNetworkCards) {
            this.maximumNetworkCards = maximumNetworkCards;
            return this;
        }

        public final Integer getDefaultNetworkCardIndex() {
            return this.defaultNetworkCardIndex;
        }

        public final void setDefaultNetworkCardIndex(Integer defaultNetworkCardIndex) {
            this.defaultNetworkCardIndex = defaultNetworkCardIndex;
        }

        @Override
        public final Builder defaultNetworkCardIndex(Integer defaultNetworkCardIndex) {
            this.defaultNetworkCardIndex = defaultNetworkCardIndex;
            return this;
        }

        public final List<NetworkCardInfo.Builder> getNetworkCards() {
            List<NetworkCardInfo.Builder> result = NetworkCardInfoListCopier.copyToBuilder(this.networkCards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkCards(Collection<NetworkCardInfo.BuilderImpl> networkCards) {
            this.networkCards = NetworkCardInfoListCopier.copyFromBuilder(networkCards);
        }

        @Override
        public final Builder networkCards(Collection<NetworkCardInfo> networkCards) {
            this.networkCards = NetworkCardInfoListCopier.copy(networkCards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkCards(NetworkCardInfo ... networkCards) {
            this.networkCards(Arrays.asList(networkCards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkCards(Consumer<NetworkCardInfo.Builder> ... networkCards) {
            this.networkCards(Stream.of(networkCards).map(c -> (NetworkCardInfo)((NetworkCardInfo.Builder)NetworkCardInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4AddressesPerInterface() {
            return this.ipv4AddressesPerInterface;
        }

        public final void setIpv4AddressesPerInterface(Integer ipv4AddressesPerInterface) {
            this.ipv4AddressesPerInterface = ipv4AddressesPerInterface;
        }

        @Override
        public final Builder ipv4AddressesPerInterface(Integer ipv4AddressesPerInterface) {
            this.ipv4AddressesPerInterface = ipv4AddressesPerInterface;
            return this;
        }

        public final Integer getIpv6AddressesPerInterface() {
            return this.ipv6AddressesPerInterface;
        }

        public final void setIpv6AddressesPerInterface(Integer ipv6AddressesPerInterface) {
            this.ipv6AddressesPerInterface = ipv6AddressesPerInterface;
        }

        @Override
        public final Builder ipv6AddressesPerInterface(Integer ipv6AddressesPerInterface) {
            this.ipv6AddressesPerInterface = ipv6AddressesPerInterface;
            return this;
        }

        public final Boolean getIpv6Supported() {
            return this.ipv6Supported;
        }

        public final void setIpv6Supported(Boolean ipv6Supported) {
            this.ipv6Supported = ipv6Supported;
        }

        @Override
        public final Builder ipv6Supported(Boolean ipv6Supported) {
            this.ipv6Supported = ipv6Supported;
            return this;
        }

        public final String getEnaSupport() {
            return this.enaSupport;
        }

        public final void setEnaSupport(String enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(String enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        @Override
        public final Builder enaSupport(EnaSupport enaSupport) {
            this.enaSupport(enaSupport == null ? null : enaSupport.toString());
            return this;
        }

        public final Boolean getEfaSupported() {
            return this.efaSupported;
        }

        public final void setEfaSupported(Boolean efaSupported) {
            this.efaSupported = efaSupported;
        }

        @Override
        public final Builder efaSupported(Boolean efaSupported) {
            this.efaSupported = efaSupported;
            return this;
        }

        public final EfaInfo.Builder getEfaInfo() {
            return this.efaInfo != null ? this.efaInfo.toBuilder() : null;
        }

        public final void setEfaInfo(EfaInfo.BuilderImpl efaInfo) {
            this.efaInfo = efaInfo != null ? efaInfo.build() : null;
        }

        @Override
        public final Builder efaInfo(EfaInfo efaInfo) {
            this.efaInfo = efaInfo;
            return this;
        }

        public final Boolean getEncryptionInTransitSupported() {
            return this.encryptionInTransitSupported;
        }

        public final void setEncryptionInTransitSupported(Boolean encryptionInTransitSupported) {
            this.encryptionInTransitSupported = encryptionInTransitSupported;
        }

        @Override
        public final Builder encryptionInTransitSupported(Boolean encryptionInTransitSupported) {
            this.encryptionInTransitSupported = encryptionInTransitSupported;
            return this;
        }

        public final Boolean getEnaSrdSupported() {
            return this.enaSrdSupported;
        }

        public final void setEnaSrdSupported(Boolean enaSrdSupported) {
            this.enaSrdSupported = enaSrdSupported;
        }

        @Override
        public final Builder enaSrdSupported(Boolean enaSrdSupported) {
            this.enaSrdSupported = enaSrdSupported;
            return this;
        }

        public final Collection<String> getBandwidthWeightings() {
            if (this.bandwidthWeightings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bandwidthWeightings;
        }

        public final void setBandwidthWeightings(Collection<String> bandwidthWeightings) {
            this.bandwidthWeightings = BandwidthWeightingTypeListCopier.copy(bandwidthWeightings);
        }

        @Override
        public final Builder bandwidthWeightingsWithStrings(Collection<String> bandwidthWeightings) {
            this.bandwidthWeightings = BandwidthWeightingTypeListCopier.copy(bandwidthWeightings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandwidthWeightingsWithStrings(String ... bandwidthWeightings) {
            this.bandwidthWeightingsWithStrings(Arrays.asList(bandwidthWeightings));
            return this;
        }

        @Override
        public final Builder bandwidthWeightings(Collection<BandwidthWeightingType> bandwidthWeightings) {
            this.bandwidthWeightings = BandwidthWeightingTypeListCopier.copyEnumToString(bandwidthWeightings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandwidthWeightings(BandwidthWeightingType ... bandwidthWeightings) {
            this.bandwidthWeightings(Arrays.asList(bandwidthWeightings));
            return this;
        }

        public NetworkInfo build() {
            return new NetworkInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInfo> {
        public Builder networkPerformance(String var1);

        public Builder maximumNetworkInterfaces(Integer var1);

        public Builder maximumNetworkCards(Integer var1);

        public Builder defaultNetworkCardIndex(Integer var1);

        public Builder networkCards(Collection<NetworkCardInfo> var1);

        public Builder networkCards(NetworkCardInfo ... var1);

        public Builder networkCards(Consumer<NetworkCardInfo.Builder> ... var1);

        public Builder ipv4AddressesPerInterface(Integer var1);

        public Builder ipv6AddressesPerInterface(Integer var1);

        public Builder ipv6Supported(Boolean var1);

        public Builder enaSupport(String var1);

        public Builder enaSupport(EnaSupport var1);

        public Builder efaSupported(Boolean var1);

        public Builder efaInfo(EfaInfo var1);

        default public Builder efaInfo(Consumer<EfaInfo.Builder> efaInfo) {
            return this.efaInfo((EfaInfo)((EfaInfo.Builder)EfaInfo.builder().applyMutation(efaInfo)).build());
        }

        public Builder encryptionInTransitSupported(Boolean var1);

        public Builder enaSrdSupported(Boolean var1);

        public Builder bandwidthWeightingsWithStrings(Collection<String> var1);

        public Builder bandwidthWeightingsWithStrings(String ... var1);

        public Builder bandwidthWeightings(Collection<BandwidthWeightingType> var1);

        public Builder bandwidthWeightings(BandwidthWeightingType ... var1);
    }
}

