/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a customer-owned IP address range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoipCidr implements SdkPojo, Serializable, ToCopyableBuilder<CoipCidr.Builder, CoipCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(CoipCidr::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<String> COIP_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoipPoolId")
            .getter(getter(CoipCidr::coipPoolId))
            .setter(setter(Builder::coipPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolId")
                    .unmarshallLocationName("coipPoolId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableId")
            .getter(getter(CoipCidr::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("localGatewayRouteTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            COIP_POOL_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String coipPoolId;

    private final String localGatewayRouteTableId;

    private CoipCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.coipPoolId = builder.coipPoolId;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
    }

    /**
     * <p>
     * An address range in a customer-owned IP address space.
     * </p>
     * 
     * @return An address range in a customer-owned IP address space.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The ID of the address pool.
     * </p>
     * 
     * @return The ID of the address pool.
     */
    public final String coipPoolId() {
        return coipPoolId;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public final String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(coipPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoipCidr)) {
            return false;
        }
        CoipCidr other = (CoipCidr) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(coipPoolId(), other.coipPoolId())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoipCidr").add("Cidr", cidr()).add("CoipPoolId", coipPoolId())
                .add("LocalGatewayRouteTableId", localGatewayRouteTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "CoipPoolId":
            return Optional.ofNullable(clazz.cast(coipPoolId()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cidr", CIDR_FIELD);
        map.put("CoipPoolId", COIP_POOL_ID_FIELD);
        map.put("LocalGatewayRouteTableId", LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoipCidr, T> g) {
        return obj -> g.apply((CoipCidr) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoipCidr> {
        /**
         * <p>
         * An address range in a customer-owned IP address space.
         * </p>
         * 
         * @param cidr
         *        An address range in a customer-owned IP address space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The ID of the address pool.
         * </p>
         * 
         * @param coipPoolId
         *        The ID of the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPoolId(String coipPoolId);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String coipPoolId;

        private String localGatewayRouteTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(CoipCidr model) {
            cidr(model.cidr);
            coipPoolId(model.coipPoolId);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getCoipPoolId() {
            return coipPoolId;
        }

        public final void setCoipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
        }

        @Override
        public final Builder coipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        @Override
        public CoipCidr build() {
            return new CoipCidr(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
