/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcPeeringConnectionOptionsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcPeeringConnectionOptionsDescription> {
    private static final SdkField<Boolean> ALLOW_DNS_RESOLUTION_FROM_REMOTE_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowDnsResolutionFromRemoteVpc").getter(VpcPeeringConnectionOptionsDescription.getter(VpcPeeringConnectionOptionsDescription::allowDnsResolutionFromRemoteVpc)).setter(VpcPeeringConnectionOptionsDescription.setter(Builder::allowDnsResolutionFromRemoteVpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowDnsResolutionFromRemoteVpc").unmarshallLocationName("allowDnsResolutionFromRemoteVpc").build()}).build();
    private static final SdkField<Boolean> ALLOW_EGRESS_FROM_LOCAL_CLASSIC_LINK_TO_REMOTE_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowEgressFromLocalClassicLinkToRemoteVpc").getter(VpcPeeringConnectionOptionsDescription.getter(VpcPeeringConnectionOptionsDescription::allowEgressFromLocalClassicLinkToRemoteVpc)).setter(VpcPeeringConnectionOptionsDescription.setter(Builder::allowEgressFromLocalClassicLinkToRemoteVpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowEgressFromLocalClassicLinkToRemoteVpc").unmarshallLocationName("allowEgressFromLocalClassicLinkToRemoteVpc").build()}).build();
    private static final SdkField<Boolean> ALLOW_EGRESS_FROM_LOCAL_VPC_TO_REMOTE_CLASSIC_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowEgressFromLocalVpcToRemoteClassicLink").getter(VpcPeeringConnectionOptionsDescription.getter(VpcPeeringConnectionOptionsDescription::allowEgressFromLocalVpcToRemoteClassicLink)).setter(VpcPeeringConnectionOptionsDescription.setter(Builder::allowEgressFromLocalVpcToRemoteClassicLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowEgressFromLocalVpcToRemoteClassicLink").unmarshallLocationName("allowEgressFromLocalVpcToRemoteClassicLink").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_DNS_RESOLUTION_FROM_REMOTE_VPC_FIELD, ALLOW_EGRESS_FROM_LOCAL_CLASSIC_LINK_TO_REMOTE_VPC_FIELD, ALLOW_EGRESS_FROM_LOCAL_VPC_TO_REMOTE_CLASSIC_LINK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AllowDnsResolutionFromRemoteVpc", ALLOW_DNS_RESOLUTION_FROM_REMOTE_VPC_FIELD);
            this.put("AllowEgressFromLocalClassicLinkToRemoteVpc", ALLOW_EGRESS_FROM_LOCAL_CLASSIC_LINK_TO_REMOTE_VPC_FIELD);
            this.put("AllowEgressFromLocalVpcToRemoteClassicLink", ALLOW_EGRESS_FROM_LOCAL_VPC_TO_REMOTE_CLASSIC_LINK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean allowDnsResolutionFromRemoteVpc;
    private final Boolean allowEgressFromLocalClassicLinkToRemoteVpc;
    private final Boolean allowEgressFromLocalVpcToRemoteClassicLink;

    private VpcPeeringConnectionOptionsDescription(BuilderImpl builder) {
        this.allowDnsResolutionFromRemoteVpc = builder.allowDnsResolutionFromRemoteVpc;
        this.allowEgressFromLocalClassicLinkToRemoteVpc = builder.allowEgressFromLocalClassicLinkToRemoteVpc;
        this.allowEgressFromLocalVpcToRemoteClassicLink = builder.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    public final Boolean allowDnsResolutionFromRemoteVpc() {
        return this.allowDnsResolutionFromRemoteVpc;
    }

    public final Boolean allowEgressFromLocalClassicLinkToRemoteVpc() {
        return this.allowEgressFromLocalClassicLinkToRemoteVpc;
    }

    public final Boolean allowEgressFromLocalVpcToRemoteClassicLink() {
        return this.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowDnsResolutionFromRemoteVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowEgressFromLocalClassicLinkToRemoteVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowEgressFromLocalVpcToRemoteClassicLink());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionOptionsDescription)) {
            return false;
        }
        VpcPeeringConnectionOptionsDescription other = (VpcPeeringConnectionOptionsDescription)obj;
        return Objects.equals(this.allowDnsResolutionFromRemoteVpc(), other.allowDnsResolutionFromRemoteVpc()) && Objects.equals(this.allowEgressFromLocalClassicLinkToRemoteVpc(), other.allowEgressFromLocalClassicLinkToRemoteVpc()) && Objects.equals(this.allowEgressFromLocalVpcToRemoteClassicLink(), other.allowEgressFromLocalVpcToRemoteClassicLink());
    }

    public final String toString() {
        return ToString.builder((String)"VpcPeeringConnectionOptionsDescription").add("AllowDnsResolutionFromRemoteVpc", (Object)this.allowDnsResolutionFromRemoteVpc()).add("AllowEgressFromLocalClassicLinkToRemoteVpc", (Object)this.allowEgressFromLocalClassicLinkToRemoteVpc()).add("AllowEgressFromLocalVpcToRemoteClassicLink", (Object)this.allowEgressFromLocalVpcToRemoteClassicLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowDnsResolutionFromRemoteVpc": {
                return Optional.ofNullable(clazz.cast(this.allowDnsResolutionFromRemoteVpc()));
            }
            case "AllowEgressFromLocalClassicLinkToRemoteVpc": {
                return Optional.ofNullable(clazz.cast(this.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            case "AllowEgressFromLocalVpcToRemoteClassicLink": {
                return Optional.ofNullable(clazz.cast(this.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnectionOptionsDescription, T> g) {
        return obj -> g.apply((VpcPeeringConnectionOptionsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowDnsResolutionFromRemoteVpc;
        private Boolean allowEgressFromLocalClassicLinkToRemoteVpc;
        private Boolean allowEgressFromLocalVpcToRemoteClassicLink;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionOptionsDescription model) {
            this.allowDnsResolutionFromRemoteVpc(model.allowDnsResolutionFromRemoteVpc);
            this.allowEgressFromLocalClassicLinkToRemoteVpc(model.allowEgressFromLocalClassicLinkToRemoteVpc);
            this.allowEgressFromLocalVpcToRemoteClassicLink(model.allowEgressFromLocalVpcToRemoteClassicLink);
        }

        public final Boolean getAllowDnsResolutionFromRemoteVpc() {
            return this.allowDnsResolutionFromRemoteVpc;
        }

        public final void setAllowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
        }

        @Override
        public final Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
            return this;
        }

        public final Boolean getAllowEgressFromLocalClassicLinkToRemoteVpc() {
            return this.allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        public final void setAllowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        @Override
        public final Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
            return this;
        }

        public final Boolean getAllowEgressFromLocalVpcToRemoteClassicLink() {
            return this.allowEgressFromLocalVpcToRemoteClassicLink;
        }

        public final void setAllowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public final Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
            return this;
        }

        public VpcPeeringConnectionOptionsDescription build() {
            return new VpcPeeringConnectionOptionsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcPeeringConnectionOptionsDescription> {
        public Builder allowDnsResolutionFromRemoteVpc(Boolean var1);

        public Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean var1);

        public Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean var1);
    }
}

