/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeClientVpnIngressResponse extends Ec2Response implements
        ToCopyableBuilder<RevokeClientVpnIngressResponse.Builder, RevokeClientVpnIngressResponse> {
    private static final SdkField<ClientVpnAuthorizationRuleStatus> STATUS_FIELD = SdkField
            .<ClientVpnAuthorizationRuleStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(RevokeClientVpnIngressResponse::status))
            .setter(setter(Builder::status))
            .constructor(ClientVpnAuthorizationRuleStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ClientVpnAuthorizationRuleStatus status;

    private RevokeClientVpnIngressResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * <p>
     * The current state of the authorization rule.
     * </p>
     * 
     * @return The current state of the authorization rule.
     */
    public final ClientVpnAuthorizationRuleStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeClientVpnIngressResponse)) {
            return false;
        }
        RevokeClientVpnIngressResponse other = (RevokeClientVpnIngressResponse) obj;
        return Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeClientVpnIngressResponse").add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeClientVpnIngressResponse, T> g) {
        return obj -> g.apply((RevokeClientVpnIngressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, RevokeClientVpnIngressResponse> {
        /**
         * <p>
         * The current state of the authorization rule.
         * </p>
         * 
         * @param status
         *        The current state of the authorization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClientVpnAuthorizationRuleStatus status);

        /**
         * <p>
         * The current state of the authorization rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientVpnAuthorizationRuleStatus.Builder}
         * avoiding the need to create one manually via {@link ClientVpnAuthorizationRuleStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientVpnAuthorizationRuleStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ClientVpnAuthorizationRuleStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClientVpnAuthorizationRuleStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClientVpnAuthorizationRuleStatus)
         */
        default Builder status(Consumer<ClientVpnAuthorizationRuleStatus.Builder> status) {
            return status(ClientVpnAuthorizationRuleStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ClientVpnAuthorizationRuleStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeClientVpnIngressResponse model) {
            super(model);
            status(model.status);
        }

        public final ClientVpnAuthorizationRuleStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ClientVpnAuthorizationRuleStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ClientVpnAuthorizationRuleStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public RevokeClientVpnIngressResponse build() {
            return new RevokeClientVpnIngressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
