/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommended Capacity Block that fits your search requirements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityBlockOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityBlockOffering.Builder, CapacityBlockOffering> {
    private static final SdkField<String> CAPACITY_BLOCK_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityBlockOfferingId")
            .getter(getter(CapacityBlockOffering::capacityBlockOfferingId))
            .setter(setter(Builder::capacityBlockOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockOfferingId")
                    .unmarshallLocationName("capacityBlockOfferingId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(CapacityBlockOffering::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CapacityBlockOffering::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CapacityBlockOffering::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate")
            .getter(getter(CapacityBlockOffering::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate")
                    .unmarshallLocationName("startDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(CapacityBlockOffering::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("endDate").build()).build();

    private static final SdkField<Integer> CAPACITY_BLOCK_DURATION_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CapacityBlockDurationHours")
            .getter(getter(CapacityBlockOffering::capacityBlockDurationHours))
            .setter(setter(Builder::capacityBlockDurationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockDurationHours")
                    .unmarshallLocationName("capacityBlockDurationHours").build()).build();

    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UpfrontFee")
            .getter(getter(CapacityBlockOffering::upfrontFee))
            .setter(setter(Builder::upfrontFee))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee")
                    .unmarshallLocationName("upfrontFee").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(CapacityBlockOffering::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tenancy")
            .getter(getter(CapacityBlockOffering::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("tenancy").build()).build();

    private static final SdkField<Integer> CAPACITY_BLOCK_DURATION_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CapacityBlockDurationMinutes")
            .getter(getter(CapacityBlockOffering::capacityBlockDurationMinutes))
            .setter(setter(Builder::capacityBlockDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockDurationMinutes")
                    .unmarshallLocationName("capacityBlockDurationMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_BLOCK_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_COUNT_FIELD,
            START_DATE_FIELD, END_DATE_FIELD, CAPACITY_BLOCK_DURATION_HOURS_FIELD, UPFRONT_FEE_FIELD, CURRENCY_CODE_FIELD,
            TENANCY_FIELD, CAPACITY_BLOCK_DURATION_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityBlockOfferingId;

    private final String instanceType;

    private final String availabilityZone;

    private final Integer instanceCount;

    private final Instant startDate;

    private final Instant endDate;

    private final Integer capacityBlockDurationHours;

    private final String upfrontFee;

    private final String currencyCode;

    private final String tenancy;

    private final Integer capacityBlockDurationMinutes;

    private CapacityBlockOffering(BuilderImpl builder) {
        this.capacityBlockOfferingId = builder.capacityBlockOfferingId;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.instanceCount = builder.instanceCount;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.capacityBlockDurationHours = builder.capacityBlockDurationHours;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.tenancy = builder.tenancy;
        this.capacityBlockDurationMinutes = builder.capacityBlockDurationMinutes;
    }

    /**
     * <p>
     * The ID of the Capacity Block offering.
     * </p>
     * 
     * @return The ID of the Capacity Block offering.
     */
    public final String capacityBlockOfferingId() {
        return capacityBlockOfferingId;
    }

    /**
     * <p>
     * The instance type of the Capacity Block offering.
     * </p>
     * 
     * @return The instance type of the Capacity Block offering.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Availability Zone of the Capacity Block offering.
     * </p>
     * 
     * @return The Availability Zone of the Capacity Block offering.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of instances in the Capacity Block offering.
     * </p>
     * 
     * @return The number of instances in the Capacity Block offering.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The start date of the Capacity Block offering.
     * </p>
     * 
     * @return The start date of the Capacity Block offering.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The end date of the Capacity Block offering.
     * </p>
     * 
     * @return The end date of the Capacity Block offering.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The number of hours (in addition to <code>capacityBlockDurationMinutes</code>) for the duration of the Capacity
     * Block reservation. For example, if a Capacity Block starts at <b>04:55</b> and ends at <b>11:30</b>, the hours
     * field would be <b>6</b>.
     * </p>
     * 
     * @return The number of hours (in addition to <code>capacityBlockDurationMinutes</code>) for the duration of the
     *         Capacity Block reservation. For example, if a Capacity Block starts at <b>04:55</b> and ends at
     *         <b>11:30</b>, the hours field would be <b>6</b>.
     */
    public final Integer capacityBlockDurationHours() {
        return capacityBlockDurationHours;
    }

    /**
     * <p>
     * The total price to be paid up front.
     * </p>
     * 
     * @return The total price to be paid up front.
     */
    public final String upfrontFee() {
        return upfrontFee;
    }

    /**
     * <p>
     * The currency of the payment for the Capacity Block.
     * </p>
     * 
     * @return The currency of the payment for the Capacity Block.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the Capacity Block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the Capacity Block.
     * @see CapacityReservationTenancy
     */
    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy of the Capacity Block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the Capacity Block.
     * @see CapacityReservationTenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The number of minutes (in addition to <code>capacityBlockDurationHours</code>) for the duration of the Capacity
     * Block reservation. For example, if a Capacity Block starts at <b>08:55</b> and ends at <b>11:30</b>, the minutes
     * field would be <b>35</b>.
     * </p>
     * 
     * @return The number of minutes (in addition to <code>capacityBlockDurationHours</code>) for the duration of the
     *         Capacity Block reservation. For example, if a Capacity Block starts at <b>08:55</b> and ends at
     *         <b>11:30</b>, the minutes field would be <b>35</b>.
     */
    public final Integer capacityBlockDurationMinutes() {
        return capacityBlockDurationMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockDurationMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlockOffering)) {
            return false;
        }
        CapacityBlockOffering other = (CapacityBlockOffering) obj;
        return Objects.equals(capacityBlockOfferingId(), other.capacityBlockOfferingId())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate())
                && Objects.equals(capacityBlockDurationHours(), other.capacityBlockDurationHours())
                && Objects.equals(upfrontFee(), other.upfrontFee()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(capacityBlockDurationMinutes(), other.capacityBlockDurationMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityBlockOffering").add("CapacityBlockOfferingId", capacityBlockOfferingId())
                .add("InstanceType", instanceType()).add("AvailabilityZone", availabilityZone())
                .add("InstanceCount", instanceCount()).add("StartDate", startDate()).add("EndDate", endDate())
                .add("CapacityBlockDurationHours", capacityBlockDurationHours()).add("UpfrontFee", upfrontFee())
                .add("CurrencyCode", currencyCode()).add("Tenancy", tenancyAsString())
                .add("CapacityBlockDurationMinutes", capacityBlockDurationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityBlockOfferingId":
            return Optional.ofNullable(clazz.cast(capacityBlockOfferingId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "CapacityBlockDurationHours":
            return Optional.ofNullable(clazz.cast(capacityBlockDurationHours()));
        case "UpfrontFee":
            return Optional.ofNullable(clazz.cast(upfrontFee()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "CapacityBlockDurationMinutes":
            return Optional.ofNullable(clazz.cast(capacityBlockDurationMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityBlockOfferingId", CAPACITY_BLOCK_OFFERING_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("CapacityBlockDurationHours", CAPACITY_BLOCK_DURATION_HOURS_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("CapacityBlockDurationMinutes", CAPACITY_BLOCK_DURATION_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlockOffering, T> g) {
        return obj -> g.apply((CapacityBlockOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityBlockOffering> {
        /**
         * <p>
         * The ID of the Capacity Block offering.
         * </p>
         * 
         * @param capacityBlockOfferingId
         *        The ID of the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockOfferingId(String capacityBlockOfferingId);

        /**
         * <p>
         * The instance type of the Capacity Block offering.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Availability Zone of the Capacity Block offering.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of instances in the Capacity Block offering.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances in the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The start date of the Capacity Block offering.
         * </p>
         * 
         * @param startDate
         *        The start date of the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The end date of the Capacity Block offering.
         * </p>
         * 
         * @param endDate
         *        The end date of the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The number of hours (in addition to <code>capacityBlockDurationMinutes</code>) for the duration of the
         * Capacity Block reservation. For example, if a Capacity Block starts at <b>04:55</b> and ends at <b>11:30</b>,
         * the hours field would be <b>6</b>.
         * </p>
         * 
         * @param capacityBlockDurationHours
         *        The number of hours (in addition to <code>capacityBlockDurationMinutes</code>) for the duration of the
         *        Capacity Block reservation. For example, if a Capacity Block starts at <b>04:55</b> and ends at
         *        <b>11:30</b>, the hours field would be <b>6</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockDurationHours(Integer capacityBlockDurationHours);

        /**
         * <p>
         * The total price to be paid up front.
         * </p>
         * 
         * @param upfrontFee
         *        The total price to be paid up front.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontFee(String upfrontFee);

        /**
         * <p>
         * The currency of the payment for the Capacity Block.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the payment for the Capacity Block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The tenancy of the Capacity Block.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the Capacity Block.
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the Capacity Block.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the Capacity Block.
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(CapacityReservationTenancy tenancy);

        /**
         * <p>
         * The number of minutes (in addition to <code>capacityBlockDurationHours</code>) for the duration of the
         * Capacity Block reservation. For example, if a Capacity Block starts at <b>08:55</b> and ends at <b>11:30</b>,
         * the minutes field would be <b>35</b>.
         * </p>
         * 
         * @param capacityBlockDurationMinutes
         *        The number of minutes (in addition to <code>capacityBlockDurationHours</code>) for the duration of the
         *        Capacity Block reservation. For example, if a Capacity Block starts at <b>08:55</b> and ends at
         *        <b>11:30</b>, the minutes field would be <b>35</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockDurationMinutes(Integer capacityBlockDurationMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String capacityBlockOfferingId;

        private String instanceType;

        private String availabilityZone;

        private Integer instanceCount;

        private Instant startDate;

        private Instant endDate;

        private Integer capacityBlockDurationHours;

        private String upfrontFee;

        private String currencyCode;

        private String tenancy;

        private Integer capacityBlockDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlockOffering model) {
            capacityBlockOfferingId(model.capacityBlockOfferingId);
            instanceType(model.instanceType);
            availabilityZone(model.availabilityZone);
            instanceCount(model.instanceCount);
            startDate(model.startDate);
            endDate(model.endDate);
            capacityBlockDurationHours(model.capacityBlockDurationHours);
            upfrontFee(model.upfrontFee);
            currencyCode(model.currencyCode);
            tenancy(model.tenancy);
            capacityBlockDurationMinutes(model.capacityBlockDurationMinutes);
        }

        public final String getCapacityBlockOfferingId() {
            return capacityBlockOfferingId;
        }

        public final void setCapacityBlockOfferingId(String capacityBlockOfferingId) {
            this.capacityBlockOfferingId = capacityBlockOfferingId;
        }

        @Override
        public final Builder capacityBlockOfferingId(String capacityBlockOfferingId) {
            this.capacityBlockOfferingId = capacityBlockOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Integer getCapacityBlockDurationHours() {
            return capacityBlockDurationHours;
        }

        public final void setCapacityBlockDurationHours(Integer capacityBlockDurationHours) {
            this.capacityBlockDurationHours = capacityBlockDurationHours;
        }

        @Override
        public final Builder capacityBlockDurationHours(Integer capacityBlockDurationHours) {
            this.capacityBlockDurationHours = capacityBlockDurationHours;
            return this;
        }

        public final String getUpfrontFee() {
            return upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Integer getCapacityBlockDurationMinutes() {
            return capacityBlockDurationMinutes;
        }

        public final void setCapacityBlockDurationMinutes(Integer capacityBlockDurationMinutes) {
            this.capacityBlockDurationMinutes = capacityBlockDurationMinutes;
        }

        @Override
        public final Builder capacityBlockDurationMinutes(Integer capacityBlockDurationMinutes) {
            this.capacityBlockDurationMinutes = capacityBlockDurationMinutes;
            return this;
        }

        @Override
        public CapacityBlockOffering build() {
            return new CapacityBlockOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
