/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocalGatewayRouteTableResponse extends Ec2Response implements
        ToCopyableBuilder<CreateLocalGatewayRouteTableResponse.Builder, CreateLocalGatewayRouteTableResponse> {
    private static final SdkField<LocalGatewayRouteTable> LOCAL_GATEWAY_ROUTE_TABLE_FIELD = SdkField
            .<LocalGatewayRouteTable> builder(MarshallingType.SDK_POJO)
            .memberName("LocalGatewayRouteTable")
            .getter(getter(CreateLocalGatewayRouteTableResponse::localGatewayRouteTable))
            .setter(setter(Builder::localGatewayRouteTable))
            .constructor(LocalGatewayRouteTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTable")
                    .unmarshallLocationName("localGatewayRouteTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_GATEWAY_ROUTE_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LocalGatewayRouteTable localGatewayRouteTable;

    private CreateLocalGatewayRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTable = builder.localGatewayRouteTable;
    }

    /**
     * <p>
     * Information about the local gateway route table.
     * </p>
     * 
     * @return Information about the local gateway route table.
     */
    public final LocalGatewayRouteTable localGatewayRouteTable() {
        return localGatewayRouteTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayRouteTableResponse)) {
            return false;
        }
        CreateLocalGatewayRouteTableResponse other = (CreateLocalGatewayRouteTableResponse) obj;
        return Objects.equals(localGatewayRouteTable(), other.localGatewayRouteTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocalGatewayRouteTableResponse").add("LocalGatewayRouteTable", localGatewayRouteTable())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTable":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalGatewayRouteTable", LOCAL_GATEWAY_ROUTE_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayRouteTableResponse, T> g) {
        return obj -> g.apply((CreateLocalGatewayRouteTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocalGatewayRouteTableResponse> {
        /**
         * <p>
         * Information about the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTable
         *        Information about the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTable(LocalGatewayRouteTable localGatewayRouteTable);

        /**
         * <p>
         * Information about the local gateway route table.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalGatewayRouteTable.Builder} avoiding
         * the need to create one manually via {@link LocalGatewayRouteTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalGatewayRouteTable.Builder#build()} is called immediately and
         * its result is passed to {@link #localGatewayRouteTable(LocalGatewayRouteTable)}.
         * 
         * @param localGatewayRouteTable
         *        a consumer that will call methods on {@link LocalGatewayRouteTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localGatewayRouteTable(LocalGatewayRouteTable)
         */
        default Builder localGatewayRouteTable(Consumer<LocalGatewayRouteTable.Builder> localGatewayRouteTable) {
            return localGatewayRouteTable(LocalGatewayRouteTable.builder().applyMutation(localGatewayRouteTable).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LocalGatewayRouteTable localGatewayRouteTable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayRouteTableResponse model) {
            super(model);
            localGatewayRouteTable(model.localGatewayRouteTable);
        }

        public final LocalGatewayRouteTable.Builder getLocalGatewayRouteTable() {
            return localGatewayRouteTable != null ? localGatewayRouteTable.toBuilder() : null;
        }

        public final void setLocalGatewayRouteTable(LocalGatewayRouteTable.BuilderImpl localGatewayRouteTable) {
            this.localGatewayRouteTable = localGatewayRouteTable != null ? localGatewayRouteTable.build() : null;
        }

        @Override
        public final Builder localGatewayRouteTable(LocalGatewayRouteTable localGatewayRouteTable) {
            this.localGatewayRouteTable = localGatewayRouteTable;
            return this;
        }

        @Override
        public CreateLocalGatewayRouteTableResponse build() {
            return new CreateLocalGatewayRouteTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
