/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTransitGatewayVpcAttachmentsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeTransitGatewayVpcAttachmentsResponse.Builder, DescribeTransitGatewayVpcAttachmentsResponse> {
    private static final SdkField<List<TransitGatewayVpcAttachment>> TRANSIT_GATEWAY_VPC_ATTACHMENTS_FIELD = SdkField
            .<List<TransitGatewayVpcAttachment>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayVpcAttachments")
            .getter(getter(DescribeTransitGatewayVpcAttachmentsResponse::transitGatewayVpcAttachments))
            .setter(setter(Builder::transitGatewayVpcAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayVpcAttachments")
                    .unmarshallLocationName("transitGatewayVpcAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayVpcAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayVpcAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeTransitGatewayVpcAttachmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_VPC_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TransitGatewayVpcAttachment> transitGatewayVpcAttachments;

    private final String nextToken;

    private DescribeTransitGatewayVpcAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayVpcAttachments = builder.transitGatewayVpcAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransitGatewayVpcAttachments property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransitGatewayVpcAttachments() {
        return transitGatewayVpcAttachments != null && !(transitGatewayVpcAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the VPC attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitGatewayVpcAttachments} method.
     * </p>
     * 
     * @return Information about the VPC attachments.
     */
    public final List<TransitGatewayVpcAttachment> transitGatewayVpcAttachments() {
        return transitGatewayVpcAttachments;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayVpcAttachments() ? transitGatewayVpcAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayVpcAttachmentsResponse)) {
            return false;
        }
        DescribeTransitGatewayVpcAttachmentsResponse other = (DescribeTransitGatewayVpcAttachmentsResponse) obj;
        return hasTransitGatewayVpcAttachments() == other.hasTransitGatewayVpcAttachments()
                && Objects.equals(transitGatewayVpcAttachments(), other.transitGatewayVpcAttachments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTransitGatewayVpcAttachmentsResponse")
                .add("TransitGatewayVpcAttachments", hasTransitGatewayVpcAttachments() ? transitGatewayVpcAttachments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayVpcAttachments":
            return Optional.ofNullable(clazz.cast(transitGatewayVpcAttachments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayVpcAttachments", TRANSIT_GATEWAY_VPC_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayVpcAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayVpcAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTransitGatewayVpcAttachmentsResponse> {
        /**
         * <p>
         * Information about the VPC attachments.
         * </p>
         * 
         * @param transitGatewayVpcAttachments
         *        Information about the VPC attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayVpcAttachments(Collection<TransitGatewayVpcAttachment> transitGatewayVpcAttachments);

        /**
         * <p>
         * Information about the VPC attachments.
         * </p>
         * 
         * @param transitGatewayVpcAttachments
         *        Information about the VPC attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayVpcAttachments(TransitGatewayVpcAttachment... transitGatewayVpcAttachments);

        /**
         * <p>
         * Information about the VPC attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #transitGatewayVpcAttachments(List<TransitGatewayVpcAttachment>)}.
         * 
         * @param transitGatewayVpcAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayVpcAttachments(java.util.Collection<TransitGatewayVpcAttachment>)
         */
        Builder transitGatewayVpcAttachments(Consumer<TransitGatewayVpcAttachment.Builder>... transitGatewayVpcAttachments);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TransitGatewayVpcAttachment> transitGatewayVpcAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayVpcAttachmentsResponse model) {
            super(model);
            transitGatewayVpcAttachments(model.transitGatewayVpcAttachments);
            nextToken(model.nextToken);
        }

        public final List<TransitGatewayVpcAttachment.Builder> getTransitGatewayVpcAttachments() {
            List<TransitGatewayVpcAttachment.Builder> result = TransitGatewayVpcAttachmentListCopier
                    .copyToBuilder(this.transitGatewayVpcAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayVpcAttachments(
                Collection<TransitGatewayVpcAttachment.BuilderImpl> transitGatewayVpcAttachments) {
            this.transitGatewayVpcAttachments = TransitGatewayVpcAttachmentListCopier
                    .copyFromBuilder(transitGatewayVpcAttachments);
        }

        @Override
        public final Builder transitGatewayVpcAttachments(Collection<TransitGatewayVpcAttachment> transitGatewayVpcAttachments) {
            this.transitGatewayVpcAttachments = TransitGatewayVpcAttachmentListCopier.copy(transitGatewayVpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayVpcAttachments(TransitGatewayVpcAttachment... transitGatewayVpcAttachments) {
            transitGatewayVpcAttachments(Arrays.asList(transitGatewayVpcAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayVpcAttachments(
                Consumer<TransitGatewayVpcAttachment.Builder>... transitGatewayVpcAttachments) {
            transitGatewayVpcAttachments(Stream.of(transitGatewayVpcAttachments)
                    .map(c -> TransitGatewayVpcAttachment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayVpcAttachmentsResponse build() {
            return new DescribeTransitGatewayVpcAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
