/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Spot placement score for this Region or Availability Zone. The score is calculated based on the assumption that
 * the <code>capacity-optimized</code> allocation strategy is used and that all of the Availability Zones in the Region
 * can be used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotPlacementScore implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotPlacementScore.Builder, SpotPlacementScore> {
    private static final SdkField<String> REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Region")
            .getter(getter(SpotPlacementScore::region))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region")
                    .unmarshallLocationName("region").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(SpotPlacementScore::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<Integer> SCORE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Score")
            .getter(getter(SpotPlacementScore::score))
            .setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score")
                    .unmarshallLocationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String availabilityZoneId;

    private final Integer score;

    private SpotPlacementScore(BuilderImpl builder) {
        this.region = builder.region;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.score = builder.score;
    }

    /**
     * <p>
     * The Region.
     * </p>
     * 
     * @return The Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The placement score, on a scale from <code>1</code> to <code>10</code>. A score of <code>10</code> indicates that
     * your Spot request is highly likely to succeed in this Region or Availability Zone. A score of <code>1</code>
     * indicates that your Spot request is not likely to succeed.
     * </p>
     * 
     * @return The placement score, on a scale from <code>1</code> to <code>10</code>. A score of <code>10</code>
     *         indicates that your Spot request is highly likely to succeed in this Region or Availability Zone. A score
     *         of <code>1</code> indicates that your Spot request is not likely to succeed.
     */
    public final Integer score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPlacementScore)) {
            return false;
        }
        SpotPlacementScore other = (SpotPlacementScore) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotPlacementScore").add("Region", region()).add("AvailabilityZoneId", availabilityZoneId())
                .add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpotPlacementScore, T> g) {
        return obj -> g.apply((SpotPlacementScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotPlacementScore> {
        /**
         * <p>
         * The Region.
         * </p>
         * 
         * @param region
         *        The Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZoneId
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The placement score, on a scale from <code>1</code> to <code>10</code>. A score of <code>10</code> indicates
         * that your Spot request is highly likely to succeed in this Region or Availability Zone. A score of
         * <code>1</code> indicates that your Spot request is not likely to succeed.
         * </p>
         * 
         * @param score
         *        The placement score, on a scale from <code>1</code> to <code>10</code>. A score of <code>10</code>
         *        indicates that your Spot request is highly likely to succeed in this Region or Availability Zone. A
         *        score of <code>1</code> indicates that your Spot request is not likely to succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Integer score);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String availabilityZoneId;

        private Integer score;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPlacementScore model) {
            region(model.region);
            availabilityZoneId(model.availabilityZoneId);
            score(model.score);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Integer getScore() {
            return score;
        }

        public final void setScore(Integer score) {
            this.score = score;
        }

        @Override
        public final Builder score(Integer score) {
            this.score = score;
            return this;
        }

        @Override
        public SpotPlacementScore build() {
            return new SpotPlacementScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
