/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes address usage for a customer-owned address pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoipAddressUsage implements SdkPojo, Serializable,
        ToCopyableBuilder<CoipAddressUsage.Builder, CoipAddressUsage> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(CoipAddressUsage::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId")
            .getter(getter(CoipAddressUsage::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId")
                    .unmarshallLocationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsService")
            .getter(getter(CoipAddressUsage::awsService))
            .setter(setter(Builder::awsService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService")
                    .unmarshallLocationName("awsService").build()).build();

    private static final SdkField<String> CO_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoIp")
            .getter(getter(CoipAddressUsage::coIp))
            .setter(setter(Builder::coIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoIp")
                    .unmarshallLocationName("coIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, AWS_SERVICE_FIELD, CO_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String allocationId;

    private final String awsAccountId;

    private final String awsService;

    private final String coIp;

    private CoipAddressUsage(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.coIp = builder.coIp;
    }

    /**
     * <p>
     * The allocation ID of the address.
     * </p>
     * 
     * @return The allocation ID of the address.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services service.
     * </p>
     * 
     * @return The Amazon Web Services service.
     */
    public final String awsService() {
        return awsService;
    }

    /**
     * <p>
     * The customer-owned IP address.
     * </p>
     * 
     * @return The customer-owned IP address.
     */
    public final String coIp() {
        return coIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(coIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoipAddressUsage)) {
            return false;
        }
        CoipAddressUsage other = (CoipAddressUsage) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsService(), other.awsService()) && Objects.equals(coIp(), other.coIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoipAddressUsage").add("AllocationId", allocationId()).add("AwsAccountId", awsAccountId())
                .add("AwsService", awsService()).add("CoIp", coIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AwsService":
            return Optional.ofNullable(clazz.cast(awsService()));
        case "CoIp":
            return Optional.ofNullable(clazz.cast(coIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AwsService", AWS_SERVICE_FIELD);
        map.put("CoIp", CO_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoipAddressUsage, T> g) {
        return obj -> g.apply((CoipAddressUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoipAddressUsage> {
        /**
         * <p>
         * The allocation ID of the address.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services service.
         * </p>
         * 
         * @param awsService
         *        The Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * The customer-owned IP address.
         * </p>
         * 
         * @param coIp
         *        The customer-owned IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coIp(String coIp);
    }

    static final class BuilderImpl implements Builder {
        private String allocationId;

        private String awsAccountId;

        private String awsService;

        private String coIp;

        private BuilderImpl() {
        }

        private BuilderImpl(CoipAddressUsage model) {
            allocationId(model.allocationId);
            awsAccountId(model.awsAccountId);
            awsService(model.awsService);
            coIp(model.coIp);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsService() {
            return awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final String getCoIp() {
            return coIp;
        }

        public final void setCoIp(String coIp) {
            this.coIp = coIp;
        }

        @Override
        public final Builder coIp(String coIp) {
            this.coIp = coIp;
            return this;
        }

        @Override
        public CoipAddressUsage build() {
            return new CoipAddressUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
