/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recurring schedule for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledInstanceRecurrenceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledInstanceRecurrenceRequest.Builder, ScheduledInstanceRecurrenceRequest> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Frequency")
            .getter(getter(ScheduledInstanceRecurrenceRequest::frequency))
            .setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency")
                    .unmarshallLocationName("Frequency").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Interval")
            .getter(getter(ScheduledInstanceRecurrenceRequest::interval))
            .setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval")
                    .unmarshallLocationName("Interval").build()).build();

    private static final SdkField<List<Integer>> OCCURRENCE_DAYS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("OccurrenceDays")
            .getter(getter(ScheduledInstanceRecurrenceRequest::occurrenceDays))
            .setter(setter(Builder::occurrenceDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceDay")
                    .unmarshallLocationName("OccurrenceDay").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OccurenceDay")
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OccurenceDay").unmarshallLocationName("OccurenceDay").build())
                                            .build()).build()).build();

    private static final SdkField<Boolean> OCCURRENCE_RELATIVE_TO_END_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OccurrenceRelativeToEnd")
            .getter(getter(ScheduledInstanceRecurrenceRequest::occurrenceRelativeToEnd))
            .setter(setter(Builder::occurrenceRelativeToEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceRelativeToEnd")
                    .unmarshallLocationName("OccurrenceRelativeToEnd").build()).build();

    private static final SdkField<String> OCCURRENCE_UNIT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OccurrenceUnit")
            .getter(getter(ScheduledInstanceRecurrenceRequest::occurrenceUnit))
            .setter(setter(Builder::occurrenceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceUnit")
                    .unmarshallLocationName("OccurrenceUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD,
            INTERVAL_FIELD, OCCURRENCE_DAYS_FIELD, OCCURRENCE_RELATIVE_TO_END_FIELD, OCCURRENCE_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String frequency;

    private final Integer interval;

    private final List<Integer> occurrenceDays;

    private final Boolean occurrenceRelativeToEnd;

    private final String occurrenceUnit;

    private ScheduledInstanceRecurrenceRequest(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDays = builder.occurrenceDays;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    /**
     * <p>
     * The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
     * </p>
     * 
     * @return The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
     */
    public final String frequency() {
        return frequency;
    }

    /**
     * <p>
     * The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2
     * weeks or every 2 months.
     * </p>
     * 
     * @return The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example,
     *         every 2 weeks or every 2 months.
     */
    public final Integer interval() {
        return interval;
    }

    /**
     * For responses, this returns true if the service returned a value for the OccurrenceDays property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOccurrenceDays() {
        return occurrenceDays != null && !(occurrenceDays instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is
     * one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule. If the
     * occurrence is relative to the end of the month, you can specify only a single day.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOccurrenceDays} method.
     * </p>
     * 
     * @return The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
     *         this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily
     *         schedule. If the occurrence is relative to the end of the month, you can specify only a single day.
     */
    public final List<Integer> occurrenceDays() {
        return occurrenceDays;
    }

    /**
     * <p>
     * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify this
     * value with a daily schedule.
     * </p>
     * 
     * @return Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify
     *         this value with a daily schedule.
     */
    public final Boolean occurrenceRelativeToEnd() {
        return occurrenceRelativeToEnd;
    }

    /**
     * <p>
     * The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value is
     * required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly schedule. You can't
     * specify this value with a daily schedule.
     * </p>
     * 
     * @return The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value
     *         is required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly schedule. You
     *         can't specify this value with a daily schedule.
     */
    public final String occurrenceUnit() {
        return occurrenceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(hasOccurrenceDays() ? occurrenceDays() : null);
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceRelativeToEnd());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceUnit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrenceRequest)) {
            return false;
        }
        ScheduledInstanceRecurrenceRequest other = (ScheduledInstanceRecurrenceRequest) obj;
        return Objects.equals(frequency(), other.frequency()) && Objects.equals(interval(), other.interval())
                && hasOccurrenceDays() == other.hasOccurrenceDays() && Objects.equals(occurrenceDays(), other.occurrenceDays())
                && Objects.equals(occurrenceRelativeToEnd(), other.occurrenceRelativeToEnd())
                && Objects.equals(occurrenceUnit(), other.occurrenceUnit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledInstanceRecurrenceRequest").add("Frequency", frequency()).add("Interval", interval())
                .add("OccurrenceDays", hasOccurrenceDays() ? occurrenceDays() : null)
                .add("OccurrenceRelativeToEnd", occurrenceRelativeToEnd()).add("OccurrenceUnit", occurrenceUnit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "OccurrenceDays":
            return Optional.ofNullable(clazz.cast(occurrenceDays()));
        case "OccurrenceRelativeToEnd":
            return Optional.ofNullable(clazz.cast(occurrenceRelativeToEnd()));
        case "OccurrenceUnit":
            return Optional.ofNullable(clazz.cast(occurrenceUnit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Frequency", FREQUENCY_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("OccurrenceDay", OCCURRENCE_DAYS_FIELD);
        map.put("OccurrenceRelativeToEnd", OCCURRENCE_RELATIVE_TO_END_FIELD);
        map.put("OccurrenceUnit", OCCURRENCE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstanceRecurrenceRequest, T> g) {
        return obj -> g.apply((ScheduledInstanceRecurrenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
        /**
         * <p>
         * The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
         * </p>
         * 
         * @param frequency
         *        The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2
         * weeks or every 2 months.
         * </p>
         * 
         * @param interval
         *        The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example,
         *        every 2 weeks or every 2 months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this
         * is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule.
         * If the occurrence is relative to the end of the month, you can specify only a single day.
         * </p>
         * 
         * @param occurrenceDays
         *        The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
         *        this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a
         *        daily schedule. If the occurrence is relative to the end of the month, you can specify only a single
         *        day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceDays(Collection<Integer> occurrenceDays);

        /**
         * <p>
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this
         * is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule.
         * If the occurrence is relative to the end of the month, you can specify only a single day.
         * </p>
         * 
         * @param occurrenceDays
         *        The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
         *        this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a
         *        daily schedule. If the occurrence is relative to the end of the month, you can specify only a single
         *        day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceDays(Integer... occurrenceDays);

        /**
         * <p>
         * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify
         * this value with a daily schedule.
         * </p>
         * 
         * @param occurrenceRelativeToEnd
         *        Indicates whether the occurrence is relative to the end of the specified week or month. You can't
         *        specify this value with a daily schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd);

        /**
         * <p>
         * The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value is
         * required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly schedule. You can't
         * specify this value with a daily schedule.
         * </p>
         * 
         * @param occurrenceUnit
         *        The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This
         *        value is required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly
         *        schedule. You can't specify this value with a daily schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceUnit(String occurrenceUnit);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private Integer interval;

        private List<Integer> occurrenceDays = DefaultSdkAutoConstructList.getInstance();

        private Boolean occurrenceRelativeToEnd;

        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrenceRequest model) {
            frequency(model.frequency);
            interval(model.interval);
            occurrenceDays(model.occurrenceDays);
            occurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            occurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final Integer getInterval() {
            return interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Collection<Integer> getOccurrenceDays() {
            if (occurrenceDays instanceof SdkAutoConstructList) {
                return null;
            }
            return occurrenceDays;
        }

        public final void setOccurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
        }

        @Override
        public final Builder occurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder occurrenceDays(Integer... occurrenceDays) {
            occurrenceDays(Arrays.asList(occurrenceDays));
            return this;
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return occurrenceRelativeToEnd;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        @Override
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final String getOccurrenceUnit() {
            return occurrenceUnit;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        @Override
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        @Override
        public ScheduledInstanceRecurrenceRequest build() {
            return new ScheduledInstanceRecurrenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
