/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of DHCP options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DhcpOptions implements SdkPojo, Serializable, ToCopyableBuilder<DhcpOptions.Builder, DhcpOptions> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(DhcpOptions::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DhcpOptions::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DhcpOptionsId")
            .getter(getter(DhcpOptions::dhcpOptionsId))
            .setter(setter(Builder::dhcpOptionsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId")
                    .unmarshallLocationName("dhcpOptionsId").build()).build();

    private static final SdkField<List<DhcpConfiguration>> DHCP_CONFIGURATIONS_FIELD = SdkField
            .<List<DhcpConfiguration>> builder(MarshallingType.LIST)
            .memberName("DhcpConfigurations")
            .getter(getter(DhcpOptions::dhcpConfigurations))
            .setter(setter(Builder::dhcpConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpConfigurationSet")
                    .unmarshallLocationName("dhcpConfigurationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DhcpConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DhcpConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, TAGS_FIELD,
            DHCP_OPTIONS_ID_FIELD, DHCP_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final List<Tag> tags;

    private final String dhcpOptionsId;

    private final List<DhcpConfiguration> dhcpConfigurations;

    private DhcpOptions(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.dhcpConfigurations = builder.dhcpConfigurations;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the DHCP options set.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the DHCP options set.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the DHCP options set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the DHCP options set.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the set of DHCP options.
     * </p>
     * 
     * @return The ID of the set of DHCP options.
     */
    public final String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DhcpConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDhcpConfigurations() {
        return dhcpConfigurations != null && !(dhcpConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DHCP options in the set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDhcpConfigurations} method.
     * </p>
     * 
     * @return The DHCP options in the set.
     */
    public final List<DhcpConfiguration> dhcpConfigurations() {
        return dhcpConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDhcpConfigurations() ? dhcpConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions) obj;
        return Objects.equals(ownerId(), other.ownerId()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(dhcpOptionsId(), other.dhcpOptionsId())
                && hasDhcpConfigurations() == other.hasDhcpConfigurations()
                && Objects.equals(dhcpConfigurations(), other.dhcpConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DhcpOptions").add("OwnerId", ownerId()).add("Tags", hasTags() ? tags() : null)
                .add("DhcpOptionsId", dhcpOptionsId())
                .add("DhcpConfigurations", hasDhcpConfigurations() ? dhcpConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DhcpOptionsId":
            return Optional.ofNullable(clazz.cast(dhcpOptionsId()));
        case "DhcpConfigurations":
            return Optional.ofNullable(clazz.cast(dhcpConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("DhcpOptionsId", DHCP_OPTIONS_ID_FIELD);
        map.put("DhcpConfigurationSet", DHCP_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DhcpOptions, T> g) {
        return obj -> g.apply((DhcpOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DhcpOptions> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the DHCP options set.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the set of DHCP options.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the set of DHCP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * The DHCP options in the set.
         * </p>
         * 
         * @param dhcpConfigurations
         *        The DHCP options in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations);

        /**
         * <p>
         * The DHCP options in the set.
         * </p>
         * 
         * @param dhcpConfigurations
         *        The DHCP options in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations);

        /**
         * <p>
         * The DHCP options in the set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DhcpConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.DhcpConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DhcpConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #dhcpConfigurations(List<DhcpConfiguration>)}.
         * 
         * @param dhcpConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DhcpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpConfigurations(java.util.Collection<DhcpConfiguration>)
         */
        Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder>... dhcpConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String dhcpOptionsId;

        private List<DhcpConfiguration> dhcpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpOptions model) {
            ownerId(model.ownerId);
            tags(model.tags);
            dhcpOptionsId(model.dhcpOptionsId);
            dhcpConfigurations(model.dhcpConfigurations);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final List<DhcpConfiguration.Builder> getDhcpConfigurations() {
            List<DhcpConfiguration.Builder> result = DhcpConfigurationListCopier.copyToBuilder(this.dhcpConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations) {
            dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder>... dhcpConfigurations) {
            dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> DhcpConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DhcpOptions build() {
            return new DhcpOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
