/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroup implements SdkPojo, Serializable, ToCopyableBuilder<SecurityGroup.Builder, SecurityGroup> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(SecurityGroup::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_EGRESS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissionsEgress")
            .getter(getter(SecurityGroup::ipPermissionsEgress))
            .setter(setter(Builder::ipPermissionsEgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissionsEgress")
                    .unmarshallLocationName("ipPermissionsEgress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SecurityGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(SecurityGroup::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> SECURITY_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupArn")
            .getter(getter(SecurityGroup::securityGroupArn))
            .setter(setter(Builder::securityGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArn")
                    .unmarshallLocationName("securityGroupArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(SecurityGroup::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(SecurityGroup::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SecurityGroup::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDescription")
                    .unmarshallLocationName("groupDescription").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissions")
            .getter(getter(SecurityGroup::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("ipPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            IP_PERMISSIONS_EGRESS_FIELD, TAGS_FIELD, VPC_ID_FIELD, SECURITY_GROUP_ARN_FIELD, OWNER_ID_FIELD, GROUP_NAME_FIELD,
            DESCRIPTION_FIELD, IP_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final List<IpPermission> ipPermissionsEgress;

    private final List<Tag> tags;

    private final String vpcId;

    private final String securityGroupArn;

    private final String ownerId;

    private final String groupName;

    private final String description;

    private final List<IpPermission> ipPermissions;

    private SecurityGroup(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
        this.securityGroupArn = builder.securityGroupArn;
        this.ownerId = builder.ownerId;
        this.groupName = builder.groupName;
        this.description = builder.description;
        this.ipPermissions = builder.ipPermissions;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPermissionsEgress property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpPermissionsEgress() {
        return ipPermissionsEgress != null && !(ipPermissionsEgress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPermissionsEgress} method.
     * </p>
     * 
     * @return The outbound rules associated with the security group.
     */
    public final List<IpPermission> ipPermissionsEgress() {
        return ipPermissionsEgress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the security group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC for the security group.
     * </p>
     * 
     * @return The ID of the VPC for the security group.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ARN of the security group.
     * </p>
     * 
     * @return The ARN of the security group.
     */
    public final String securityGroupArn() {
        return securityGroupArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the security group.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the security group.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * A description of the security group.
     * </p>
     * 
     * @return A description of the security group.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound rules associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPermissions} method.
     * </p>
     * 
     * @return The inbound rules associated with the security group.
     */
    public final List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissionsEgress() ? ipPermissionsEgress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissions() ? ipPermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup) obj;
        return Objects.equals(groupId(), other.groupId()) && hasIpPermissionsEgress() == other.hasIpPermissionsEgress()
                && Objects.equals(ipPermissionsEgress(), other.ipPermissionsEgress()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(securityGroupArn(), other.securityGroupArn()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(description(), other.description())
                && hasIpPermissions() == other.hasIpPermissions() && Objects.equals(ipPermissions(), other.ipPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroup").add("GroupId", groupId())
                .add("IpPermissionsEgress", hasIpPermissionsEgress() ? ipPermissionsEgress() : null)
                .add("Tags", hasTags() ? tags() : null).add("VpcId", vpcId()).add("SecurityGroupArn", securityGroupArn())
                .add("OwnerId", ownerId()).add("GroupName", groupName()).add("Description", description())
                .add("IpPermissions", hasIpPermissions() ? ipPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "IpPermissionsEgress":
            return Optional.ofNullable(clazz.cast(ipPermissionsEgress()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SecurityGroupArn":
            return Optional.ofNullable(clazz.cast(securityGroupArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("IpPermissionsEgress", IP_PERMISSIONS_EGRESS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SecurityGroupArn", SECURITY_GROUP_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("GroupDescription", DESCRIPTION_FIELD);
        map.put("IpPermissions", IP_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroup, T> g) {
        return obj -> g.apply((SecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroup> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        The outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress);

        /**
         * <p>
         * The outbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissionsEgress
         *        The outbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissionsEgress(IpPermission... ipPermissionsEgress);

        /**
         * <p>
         * The outbound rules associated with the security group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissionsEgress(List<IpPermission>)}.
         * 
         * @param ipPermissionsEgress
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissionsEgress(java.util.Collection<IpPermission>)
         */
        Builder ipPermissionsEgress(Consumer<IpPermission.Builder>... ipPermissionsEgress);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the security group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC for the security group.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ARN of the security group.
         * </p>
         * 
         * @param securityGroupArn
         *        The ARN of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArn(String securityGroupArn);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the security group.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * A description of the security group.
         * </p>
         * 
         * @param description
         *        A description of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        The inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * 
         * @param ipPermissions
         *        The inbound rules associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The inbound rules associated with the security group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(java.util.Collection<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private List<IpPermission> ipPermissionsEgress = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String securityGroupArn;

        private String ownerId;

        private String groupName;

        private String description;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroup model) {
            groupId(model.groupId);
            ipPermissionsEgress(model.ipPermissionsEgress);
            tags(model.tags);
            vpcId(model.vpcId);
            securityGroupArn(model.securityGroupArn);
            ownerId(model.ownerId);
            groupName(model.groupName);
            description(model.description);
            ipPermissions(model.ipPermissions);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissionsEgress() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissionsEgress);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissionsEgress(Collection<IpPermission.BuilderImpl> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copyFromBuilder(ipPermissionsEgress);
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = IpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(IpPermission... ipPermissionsEgress) {
            ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(Consumer<IpPermission.Builder>... ipPermissionsEgress) {
            ipPermissionsEgress(Stream.of(ipPermissionsEgress).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSecurityGroupArn() {
            return securityGroupArn;
        }

        public final void setSecurityGroupArn(String securityGroupArn) {
            this.securityGroupArn = securityGroupArn;
        }

        @Override
        public final Builder securityGroupArn(String securityGroupArn) {
            this.securityGroupArn = securityGroupArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecurityGroup build() {
            return new SecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
