/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelSpotInstanceRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotInstanceRequestsResponse extends Ec2Response implements
        ToCopyableBuilder<CancelSpotInstanceRequestsResponse.Builder, CancelSpotInstanceRequestsResponse> {
    private static final SdkField<List<CancelledSpotInstanceRequest>> CANCELLED_SPOT_INSTANCE_REQUESTS_FIELD = SdkField
            .<List<CancelledSpotInstanceRequest>> builder(MarshallingType.LIST)
            .memberName("CancelledSpotInstanceRequests")
            .getter(getter(CancelSpotInstanceRequestsResponse::cancelledSpotInstanceRequests))
            .setter(setter(Builder::cancelledSpotInstanceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestSet")
                    .unmarshallLocationName("spotInstanceRequestSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CancelledSpotInstanceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CancelledSpotInstanceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CANCELLED_SPOT_INSTANCE_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests;

    private CancelSpotInstanceRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.cancelledSpotInstanceRequests = builder.cancelledSpotInstanceRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the CancelledSpotInstanceRequests property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCancelledSpotInstanceRequests() {
        return cancelledSpotInstanceRequests != null && !(cancelledSpotInstanceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Spot Instance requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCancelledSpotInstanceRequests} method.
     * </p>
     * 
     * @return The Spot Instance requests.
     */
    public final List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests() {
        return cancelledSpotInstanceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCancelledSpotInstanceRequests() ? cancelledSpotInstanceRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsResponse)) {
            return false;
        }
        CancelSpotInstanceRequestsResponse other = (CancelSpotInstanceRequestsResponse) obj;
        return hasCancelledSpotInstanceRequests() == other.hasCancelledSpotInstanceRequests()
                && Objects.equals(cancelledSpotInstanceRequests(), other.cancelledSpotInstanceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CancelSpotInstanceRequestsResponse")
                .add("CancelledSpotInstanceRequests", hasCancelledSpotInstanceRequests() ? cancelledSpotInstanceRequests() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancelledSpotInstanceRequests":
            return Optional.ofNullable(clazz.cast(cancelledSpotInstanceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SpotInstanceRequestSet", CANCELLED_SPOT_INSTANCE_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotInstanceRequestsResponse, T> g) {
        return obj -> g.apply((CancelSpotInstanceRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CancelSpotInstanceRequestsResponse> {
        /**
         * <p>
         * The Spot Instance requests.
         * </p>
         * 
         * @param cancelledSpotInstanceRequests
         *        The Spot Instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests);

        /**
         * <p>
         * The Spot Instance requests.
         * </p>
         * 
         * @param cancelledSpotInstanceRequests
         *        The Spot Instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledSpotInstanceRequests(CancelledSpotInstanceRequest... cancelledSpotInstanceRequests);

        /**
         * <p>
         * The Spot Instance requests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #cancelledSpotInstanceRequests(List<CancelledSpotInstanceRequest>)}.
         * 
         * @param cancelledSpotInstanceRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancelledSpotInstanceRequests(java.util.Collection<CancelledSpotInstanceRequest>)
         */
        Builder cancelledSpotInstanceRequests(Consumer<CancelledSpotInstanceRequest.Builder>... cancelledSpotInstanceRequests);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsResponse model) {
            super(model);
            cancelledSpotInstanceRequests(model.cancelledSpotInstanceRequests);
        }

        public final List<CancelledSpotInstanceRequest.Builder> getCancelledSpotInstanceRequests() {
            List<CancelledSpotInstanceRequest.Builder> result = CancelledSpotInstanceRequestListCopier
                    .copyToBuilder(this.cancelledSpotInstanceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCancelledSpotInstanceRequests(
                Collection<CancelledSpotInstanceRequest.BuilderImpl> cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests = CancelledSpotInstanceRequestListCopier
                    .copyFromBuilder(cancelledSpotInstanceRequests);
        }

        @Override
        public final Builder cancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests = CancelledSpotInstanceRequestListCopier.copy(cancelledSpotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledSpotInstanceRequests(CancelledSpotInstanceRequest... cancelledSpotInstanceRequests) {
            cancelledSpotInstanceRequests(Arrays.asList(cancelledSpotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledSpotInstanceRequests(
                Consumer<CancelledSpotInstanceRequest.Builder>... cancelledSpotInstanceRequests) {
            cancelledSpotInstanceRequests(Stream.of(cancelledSpotInstanceRequests)
                    .map(c -> CancelledSpotInstanceRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CancelSpotInstanceRequestsResponse build() {
            return new CancelSpotInstanceRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
