/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage parameters for Amazon S3 and Amazon S3 buckets for an instance store-backed AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Storage implements SdkPojo, Serializable, ToCopyableBuilder<S3Storage.Builder, S3Storage> {
    private static final SdkField<String> AWS_ACCESS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AWSAccessKeyId")
            .getter(getter(S3Storage::awsAccessKeyId))
            .setter(setter(Builder::awsAccessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccessKeyId")
                    .unmarshallLocationName("AWSAccessKeyId").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(S3Storage::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("bucket").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(S3Storage::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("prefix").build()).build();

    private static final SdkField<SdkBytes> UPLOAD_POLICY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("UploadPolicy")
            .getter(getter(S3Storage::uploadPolicy))
            .setter(setter(Builder::uploadPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadPolicy")
                    .unmarshallLocationName("uploadPolicy").build()).build();

    private static final SdkField<String> UPLOAD_POLICY_SIGNATURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UploadPolicySignature")
            .getter(getter(S3Storage::uploadPolicySignature))
            .setter(setter(Builder::uploadPolicySignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadPolicySignature")
                    .unmarshallLocationName("uploadPolicySignature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCESS_KEY_ID_FIELD,
            BUCKET_FIELD, PREFIX_FIELD, UPLOAD_POLICY_FIELD, UPLOAD_POLICY_SIGNATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccessKeyId;

    private final String bucket;

    private final String prefix;

    private final SdkBytes uploadPolicy;

    private final String uploadPolicySignature;

    private S3Storage(BuilderImpl builder) {
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.uploadPolicy = builder.uploadPolicy;
        this.uploadPolicySignature = builder.uploadPolicySignature;
    }

    /**
     * <p>
     * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and
     * follow the guidance in <a href="https://docs.aws.amazon.com/accounts/latest/reference/best-practices.html">Best
     * Practices for Amazon Web Services accounts</a> in the <i>Account ManagementReference Guide</i>.
     * </p>
     * 
     * @return The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review
     *         and follow the guidance in <a
     *         href="https://docs.aws.amazon.com/accounts/latest/reference/best-practices.html">Best Practices for
     *         Amazon Web Services accounts</a> in the <i>Account ManagementReference Guide</i>.
     */
    public final String awsAccessKeyId() {
        return awsAccessKeyId;
    }

    /**
     * <p>
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon
     * EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     * </p>
     * 
     * @return The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
     *         Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2
     *         returns an error.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The beginning of the file name of the AMI.
     * </p>
     * 
     * @return The beginning of the file name of the AMI.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
     * </p>
     * 
     * @return An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your
     *         behalf.
     */
    public final SdkBytes uploadPolicy() {
        return uploadPolicy;
    }

    /**
     * <p>
     * The signature of the JSON document.
     * </p>
     * 
     * @return The signature of the JSON document.
     */
    public final String uploadPolicySignature() {
        return uploadPolicySignature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(uploadPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(uploadPolicySignature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Storage)) {
            return false;
        }
        S3Storage other = (S3Storage) obj;
        return Objects.equals(awsAccessKeyId(), other.awsAccessKeyId()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(uploadPolicy(), other.uploadPolicy())
                && Objects.equals(uploadPolicySignature(), other.uploadPolicySignature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Storage").add("AWSAccessKeyId", awsAccessKeyId()).add("Bucket", bucket())
                .add("Prefix", prefix()).add("UploadPolicy", uploadPolicy())
                .add("UploadPolicySignature", uploadPolicySignature() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSAccessKeyId":
            return Optional.ofNullable(clazz.cast(awsAccessKeyId()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "UploadPolicy":
            return Optional.ofNullable(clazz.cast(uploadPolicy()));
        case "UploadPolicySignature":
            return Optional.ofNullable(clazz.cast(uploadPolicySignature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AWSAccessKeyId", AWS_ACCESS_KEY_ID_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("UploadPolicy", UPLOAD_POLICY_FIELD);
        map.put("UploadPolicySignature", UPLOAD_POLICY_SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Storage, T> g) {
        return obj -> g.apply((S3Storage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Storage> {
        /**
         * <p>
         * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and
         * follow the guidance in <a
         * href="https://docs.aws.amazon.com/accounts/latest/reference/best-practices.html">Best Practices for Amazon
         * Web Services accounts</a> in the <i>Account ManagementReference Guide</i>.
         * </p>
         * 
         * @param awsAccessKeyId
         *        The access key ID of the owner of the bucket. Before you specify a value for your access key ID,
         *        review and follow the guidance in <a
         *        href="https://docs.aws.amazon.com/accounts/latest/reference/best-practices.html">Best Practices for
         *        Amazon Web Services accounts</a> in the <i>Account ManagementReference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccessKeyId(String awsAccessKeyId);

        /**
         * <p>
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
         * Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns
         * an error.
         * </p>
         * 
         * @param bucket
         *        The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket
         *        that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon
         *        EC2 returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The beginning of the file name of the AMI.
         * </p>
         * 
         * @param prefix
         *        The beginning of the file name of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
         * </p>
         * 
         * @param uploadPolicy
         *        An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPolicy(SdkBytes uploadPolicy);

        /**
         * <p>
         * The signature of the JSON document.
         * </p>
         * 
         * @param uploadPolicySignature
         *        The signature of the JSON document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPolicySignature(String uploadPolicySignature);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccessKeyId;

        private String bucket;

        private String prefix;

        private SdkBytes uploadPolicy;

        private String uploadPolicySignature;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Storage model) {
            awsAccessKeyId(model.awsAccessKeyId);
            bucket(model.bucket);
            prefix(model.prefix);
            uploadPolicy(model.uploadPolicy);
            uploadPolicySignature(model.uploadPolicySignature);
        }

        public final String getAwsAccessKeyId() {
            return awsAccessKeyId;
        }

        public final void setAwsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
        }

        @Override
        public final Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final ByteBuffer getUploadPolicy() {
            return uploadPolicy == null ? null : uploadPolicy.asByteBuffer();
        }

        public final void setUploadPolicy(ByteBuffer uploadPolicy) {
            uploadPolicy(uploadPolicy == null ? null : SdkBytes.fromByteBuffer(uploadPolicy));
        }

        @Override
        public final Builder uploadPolicy(SdkBytes uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
            return this;
        }

        public final String getUploadPolicySignature() {
            return uploadPolicySignature;
        }

        public final void setUploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
        }

        @Override
        public final Builder uploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
            return this;
        }

        @Override
        public S3Storage build() {
            return new S3Storage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
