/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotRequest extends Ec2Request implements
        ToCopyableBuilder<CreateSnapshotRequest.Builder, CreateSnapshotRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateSnapshotRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CreateSnapshotRequest::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("OutpostArn").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(CreateSnapshotRequest::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateSnapshotRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateSnapshotRequest::locationAsString))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateSnapshotRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            OUTPOST_ARN_FIELD, VOLUME_ID_FIELD, TAG_SPECIFICATIONS_FIELD, LOCATION_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String outpostArn;

    private final String volumeId;

    private final List<TagSpecification> tagSpecifications;

    private final String location;

    private final Boolean dryRun;

    private CreateSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.outpostArn = builder.outpostArn;
        this.volumeId = builder.volumeId;
        this.tagSpecifications = builder.tagSpecifications;
        this.location = builder.location;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <note>
     * <p>
     * Only supported for volumes on Outposts. If the source volume is not on an Outpost, omit this parameter.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * To create the snapshot on the same Outpost as the source volume, specify the ARN of that Outpost. The snapshot
     * must be created on the same Outpost as the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create the snapshot in the parent Region of the Outpost, omit this parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create local
     * snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return <p>
     *         Only supported for volumes on Outposts. If the source volume is not on an Outpost, omit this parameter.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         To create the snapshot on the same Outpost as the source volume, specify the ARN of that Outpost. The
     *         snapshot must be created on the same Outpost as the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create the snapshot in the parent Region of the Outpost, omit this parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create
     *         local snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The ID of the Amazon EBS volume.
     * </p>
     * 
     * @return The ID of the Amazon EBS volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the snapshot during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the snapshot during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <note>
     * <p>
     * Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this parameter.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or omit this
     * parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default value: <code>regional</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #location} will
     * return {@link SnapshotLocationEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #locationAsString}.
     * </p>
     * 
     * @return <p>
     *         Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this
     *         parameter.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or
     *         omit this parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default value: <code>regional</code>
     * @see SnapshotLocationEnum
     */
    public final SnapshotLocationEnum location() {
        return SnapshotLocationEnum.fromValue(location);
    }

    /**
     * <note>
     * <p>
     * Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this parameter.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or omit this
     * parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default value: <code>regional</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #location} will
     * return {@link SnapshotLocationEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #locationAsString}.
     * </p>
     * 
     * @return <p>
     *         Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this
     *         parameter.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or
     *         omit this parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default value: <code>regional</code>
     * @see SnapshotLocationEnum
     */
    public final String locationAsString() {
        return location;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(locationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(volumeId(), other.volumeId()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(locationAsString(), other.locationAsString()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotRequest").add("Description", description()).add("OutpostArn", outpostArn())
                .add("VolumeId", volumeId()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("Location", locationAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "Location":
            return Optional.ofNullable(clazz.cast(locationAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotRequest> {
        /**
         * <p>
         * A description for the snapshot.
         * </p>
         * 
         * @param description
         *        A description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <note>
         * <p>
         * Only supported for volumes on Outposts. If the source volume is not on an Outpost, omit this parameter.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * To create the snapshot on the same Outpost as the source volume, specify the ARN of that Outpost. The
         * snapshot must be created on the same Outpost as the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create the snapshot in the parent Region of the Outpost, omit this parameter.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create local
         * snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param outpostArn
         *        <p>
         *        Only supported for volumes on Outposts. If the source volume is not on an Outpost, omit this
         *        parameter.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        To create the snapshot on the same Outpost as the source volume, specify the ARN of that Outpost. The
         *        snapshot must be created on the same Outpost as the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create the snapshot in the parent Region of the Outpost, omit this parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot">Create
         *        local snapshots from volumes on an Outpost</a> in the <i>Amazon EBS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The ID of the Amazon EBS volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the Amazon EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The tags to apply to the snapshot during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the snapshot during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the snapshot during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the snapshot during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the snapshot during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <note>
         * <p>
         * Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this parameter.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or omit
         * this parameter.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default value: <code>regional</code>
         * </p>
         * 
         * @param location
         *        <p>
         *        Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this
         *        parameter.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or
         *        omit this parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default value: <code>regional</code>
         * @see SnapshotLocationEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotLocationEnum
         */
        Builder location(String location);

        /**
         * <note>
         * <p>
         * Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this parameter.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or omit
         * this parameter.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default value: <code>regional</code>
         * </p>
         * 
         * @param location
         *        <p>
         *        Only supported for volumes in Local Zones. If the source volume is not in a Local Zone, omit this
         *        parameter.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        To create a local snapshot in the same Local Zone as the source volume, specify <code>local</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a regional snapshot in the parent Region of the Local Zone, specify <code>regional</code> or
         *        omit this parameter.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default value: <code>regional</code>
         * @see SnapshotLocationEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotLocationEnum
         */
        Builder location(SnapshotLocationEnum location);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String description;

        private String outpostArn;

        private String volumeId;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String location;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotRequest model) {
            super(model);
            description(model.description);
            outpostArn(model.outpostArn);
            volumeId(model.volumeId);
            tagSpecifications(model.tagSpecifications);
            location(model.location);
            dryRun(model.dryRun);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public final Builder location(SnapshotLocationEnum location) {
            this.location(location == null ? null : location.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotRequest build() {
            return new CreateSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
