/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for an Amazon Web Services Verified Access device-identity based trust provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceOptions implements SdkPojo, Serializable, ToCopyableBuilder<DeviceOptions.Builder, DeviceOptions> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TenantId")
            .getter(getter(DeviceOptions::tenantId))
            .setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId")
                    .unmarshallLocationName("tenantId").build()).build();

    private static final SdkField<String> PUBLIC_SIGNING_KEY_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicSigningKeyUrl")
            .getter(getter(DeviceOptions::publicSigningKeyUrl))
            .setter(setter(Builder::publicSigningKeyUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSigningKeyUrl")
                    .unmarshallLocationName("publicSigningKeyUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD,
            PUBLIC_SIGNING_KEY_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantId;

    private final String publicSigningKeyUrl;

    private DeviceOptions(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.publicSigningKeyUrl = builder.publicSigningKeyUrl;
    }

    /**
     * <p>
     * The ID of the tenant application with the device-identity provider.
     * </p>
     * 
     * @return The ID of the tenant application with the device-identity provider.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     * </p>
     * 
     * @return The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
     */
    public final String publicSigningKeyUrl() {
        return publicSigningKeyUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(publicSigningKeyUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceOptions)) {
            return false;
        }
        DeviceOptions other = (DeviceOptions) obj;
        return Objects.equals(tenantId(), other.tenantId()) && Objects.equals(publicSigningKeyUrl(), other.publicSigningKeyUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceOptions").add("TenantId", tenantId()).add("PublicSigningKeyUrl", publicSigningKeyUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "PublicSigningKeyUrl":
            return Optional.ofNullable(clazz.cast(publicSigningKeyUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("PublicSigningKeyUrl", PUBLIC_SIGNING_KEY_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceOptions, T> g) {
        return obj -> g.apply((DeviceOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceOptions> {
        /**
         * <p>
         * The ID of the tenant application with the device-identity provider.
         * </p>
         * 
         * @param tenantId
         *        The ID of the tenant application with the device-identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
         * </p>
         * 
         * @param publicSigningKeyUrl
         *        The URL Amazon Web Services Verified Access will use to verify the authenticity of the device tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSigningKeyUrl(String publicSigningKeyUrl);
    }

    static final class BuilderImpl implements Builder {
        private String tenantId;

        private String publicSigningKeyUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceOptions model) {
            tenantId(model.tenantId);
            publicSigningKeyUrl(model.publicSigningKeyUrl);
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getPublicSigningKeyUrl() {
            return publicSigningKeyUrl;
        }

        public final void setPublicSigningKeyUrl(String publicSigningKeyUrl) {
            this.publicSigningKeyUrl = publicSigningKeyUrl;
        }

        @Override
        public final Builder publicSigningKeyUrl(String publicSigningKeyUrl) {
            this.publicSigningKeyUrl = publicSigningKeyUrl;
            return this;
        }

        @Override
        public DeviceOptions build() {
            return new DeviceOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
