/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSnapshotResponse extends Ec2Response implements
        ToCopyableBuilder<ImportSnapshotResponse.Builder, ImportSnapshotResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportSnapshotResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImportTaskId")
            .getter(getter(ImportSnapshotResponse::importTaskId))
            .setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId")
                    .unmarshallLocationName("importTaskId").build()).build();

    private static final SdkField<SnapshotTaskDetail> SNAPSHOT_TASK_DETAIL_FIELD = SdkField
            .<SnapshotTaskDetail> builder(MarshallingType.SDK_POJO)
            .memberName("SnapshotTaskDetail")
            .getter(getter(ImportSnapshotResponse::snapshotTaskDetail))
            .setter(setter(Builder::snapshotTaskDetail))
            .constructor(SnapshotTaskDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTaskDetail")
                    .unmarshallLocationName("snapshotTaskDetail").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportSnapshotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            IMPORT_TASK_ID_FIELD, SNAPSHOT_TASK_DETAIL_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String importTaskId;

    private final SnapshotTaskDetail snapshotTaskDetail;

    private final List<Tag> tags;

    private ImportSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.importTaskId = builder.importTaskId;
        this.snapshotTaskDetail = builder.snapshotTaskDetail;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A description of the import snapshot task.
     * </p>
     * 
     * @return A description of the import snapshot task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the import snapshot task.
     * </p>
     * 
     * @return The ID of the import snapshot task.
     */
    public final String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * Information about the import snapshot task.
     * </p>
     * 
     * @return Information about the import snapshot task.
     */
    public final SnapshotTaskDetail snapshotTaskDetail() {
        return snapshotTaskDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the import snapshot task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the import snapshot task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTaskDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotResponse)) {
            return false;
        }
        ImportSnapshotResponse other = (ImportSnapshotResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(importTaskId(), other.importTaskId())
                && Objects.equals(snapshotTaskDetail(), other.snapshotTaskDetail()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSnapshotResponse").add("Description", description()).add("ImportTaskId", importTaskId())
                .add("SnapshotTaskDetail", snapshotTaskDetail()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImportTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        case "SnapshotTaskDetail":
            return Optional.ofNullable(clazz.cast(snapshotTaskDetail()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ImportTaskId", IMPORT_TASK_ID_FIELD);
        map.put("SnapshotTaskDetail", SNAPSHOT_TASK_DETAIL_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportSnapshotResponse, T> g) {
        return obj -> g.apply((ImportSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ImportSnapshotResponse> {
        /**
         * <p>
         * A description of the import snapshot task.
         * </p>
         * 
         * @param description
         *        A description of the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the import snapshot task.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * Information about the import snapshot task.
         * </p>
         * 
         * @param snapshotTaskDetail
         *        Information about the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail);

        /**
         * <p>
         * Information about the import snapshot task.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotTaskDetail.Builder} avoiding the
         * need to create one manually via {@link SnapshotTaskDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotTaskDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotTaskDetail(SnapshotTaskDetail)}.
         * 
         * @param snapshotTaskDetail
         *        a consumer that will call methods on {@link SnapshotTaskDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotTaskDetail(SnapshotTaskDetail)
         */
        default Builder snapshotTaskDetail(Consumer<SnapshotTaskDetail.Builder> snapshotTaskDetail) {
            return snapshotTaskDetail(SnapshotTaskDetail.builder().applyMutation(snapshotTaskDetail).build());
        }

        /**
         * <p>
         * Any tags assigned to the import snapshot task.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the import snapshot task.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the import snapshot task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String description;

        private String importTaskId;

        private SnapshotTaskDetail snapshotTaskDetail;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotResponse model) {
            super(model);
            description(model.description);
            importTaskId(model.importTaskId);
            snapshotTaskDetail(model.snapshotTaskDetail);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final SnapshotTaskDetail.Builder getSnapshotTaskDetail() {
            return snapshotTaskDetail != null ? snapshotTaskDetail.toBuilder() : null;
        }

        public final void setSnapshotTaskDetail(SnapshotTaskDetail.BuilderImpl snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail != null ? snapshotTaskDetail.build() : null;
        }

        @Override
        public final Builder snapshotTaskDetail(SnapshotTaskDetail snapshotTaskDetail) {
            this.snapshotTaskDetail = snapshotTaskDetail;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ImportSnapshotResponse build() {
            return new ImportSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
