/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteServerPeerRequest extends Ec2Request implements
        ToCopyableBuilder<CreateRouteServerPeerRequest.Builder, CreateRouteServerPeerRequest> {
    private static final SdkField<String> ROUTE_SERVER_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteServerEndpointId")
            .getter(getter(CreateRouteServerPeerRequest::routeServerEndpointId))
            .setter(setter(Builder::routeServerEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointId")
                    .unmarshallLocationName("RouteServerEndpointId").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(CreateRouteServerPeerRequest::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("PeerAddress").build()).build();

    private static final SdkField<RouteServerBgpOptionsRequest> BGP_OPTIONS_FIELD = SdkField
            .<RouteServerBgpOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("BgpOptions")
            .getter(getter(CreateRouteServerPeerRequest::bgpOptions))
            .setter(setter(Builder::bgpOptions))
            .constructor(RouteServerBgpOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions")
                    .unmarshallLocationName("BgpOptions").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateRouteServerPeerRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateRouteServerPeerRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ROUTE_SERVER_ENDPOINT_ID_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String routeServerEndpointId;

    private final String peerAddress;

    private final RouteServerBgpOptionsRequest bgpOptions;

    private final Boolean dryRun;

    private final List<TagSpecification> tagSpecifications;

    private CreateRouteServerPeerRequest(BuilderImpl builder) {
        super(builder);
        this.routeServerEndpointId = builder.routeServerEndpointId;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The ID of the route server endpoint for which to create a peer.
     * </p>
     * 
     * @return The ID of the route server endpoint for which to create a peer.
     */
    public final String routeServerEndpointId() {
        return routeServerEndpointId;
    }

    /**
     * <p>
     * The IPv4 address of the peer.
     * </p>
     * 
     * @return The IPv4 address of the peer.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding
     * Detection) settings.
     * </p>
     * 
     * @return The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding
     *         Detection) settings.
     */
    public final RouteServerBgpOptionsRequest bgpOptions() {
        return bgpOptions;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the route server peer during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the route server peer during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteServerPeerRequest)) {
            return false;
        }
        CreateRouteServerPeerRequest other = (CreateRouteServerPeerRequest) obj;
        return Objects.equals(routeServerEndpointId(), other.routeServerEndpointId())
                && Objects.equals(peerAddress(), other.peerAddress()) && Objects.equals(bgpOptions(), other.bgpOptions())
                && Objects.equals(dryRun(), other.dryRun()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteServerPeerRequest").add("RouteServerEndpointId", routeServerEndpointId())
                .add("PeerAddress", peerAddress()).add("BgpOptions", bgpOptions()).add("DryRun", dryRun())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerEndpointId":
            return Optional.ofNullable(clazz.cast(routeServerEndpointId()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "BgpOptions":
            return Optional.ofNullable(clazz.cast(bgpOptions()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerEndpointId", ROUTE_SERVER_ENDPOINT_ID_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("BgpOptions", BGP_OPTIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteServerPeerRequest, T> g) {
        return obj -> g.apply((CreateRouteServerPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteServerPeerRequest> {
        /**
         * <p>
         * The ID of the route server endpoint for which to create a peer.
         * </p>
         * 
         * @param routeServerEndpointId
         *        The ID of the route server endpoint for which to create a peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerEndpointId(String routeServerEndpointId);

        /**
         * <p>
         * The IPv4 address of the peer.
         * </p>
         * 
         * @param peerAddress
         *        The IPv4 address of the peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding
         * Detection) settings.
         * </p>
         * 
         * @param bgpOptions
         *        The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional
         *        Forwarding Detection) settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpOptions(RouteServerBgpOptionsRequest bgpOptions);

        /**
         * <p>
         * The BGP options for the peer, including ASN (Autonomous System Number) and BFD (Bidrectional Forwarding
         * Detection) settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteServerBgpOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link RouteServerBgpOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteServerBgpOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #bgpOptions(RouteServerBgpOptionsRequest)}.
         * 
         * @param bgpOptions
         *        a consumer that will call methods on {@link RouteServerBgpOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bgpOptions(RouteServerBgpOptionsRequest)
         */
        default Builder bgpOptions(Consumer<RouteServerBgpOptionsRequest.Builder> bgpOptions) {
            return bgpOptions(RouteServerBgpOptionsRequest.builder().applyMutation(bgpOptions).build());
        }

        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The tags to apply to the route server peer during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the route server peer during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the route server peer during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the route server peer during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the route server peer during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String routeServerEndpointId;

        private String peerAddress;

        private RouteServerBgpOptionsRequest bgpOptions;

        private Boolean dryRun;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteServerPeerRequest model) {
            super(model);
            routeServerEndpointId(model.routeServerEndpointId);
            peerAddress(model.peerAddress);
            bgpOptions(model.bgpOptions);
            dryRun(model.dryRun);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getRouteServerEndpointId() {
            return routeServerEndpointId;
        }

        public final void setRouteServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
        }

        @Override
        public final Builder routeServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final RouteServerBgpOptionsRequest.Builder getBgpOptions() {
            return bgpOptions != null ? bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(RouteServerBgpOptionsRequest.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        public final Builder bgpOptions(RouteServerBgpOptionsRequest bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteServerPeerRequest build() {
            return new CreateRouteServerPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
