/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableRouteServerPropagationResponse extends Ec2Response implements
        ToCopyableBuilder<DisableRouteServerPropagationResponse.Builder, DisableRouteServerPropagationResponse> {
    private static final SdkField<RouteServerPropagation> ROUTE_SERVER_PROPAGATION_FIELD = SdkField
            .<RouteServerPropagation> builder(MarshallingType.SDK_POJO)
            .memberName("RouteServerPropagation")
            .getter(getter(DisableRouteServerPropagationResponse::routeServerPropagation))
            .setter(setter(Builder::routeServerPropagation))
            .constructor(RouteServerPropagation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerPropagation")
                    .unmarshallLocationName("routeServerPropagation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROUTE_SERVER_PROPAGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouteServerPropagation routeServerPropagation;

    private DisableRouteServerPropagationResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerPropagation = builder.routeServerPropagation;
    }

    /**
     * <p>
     * Information about the disabled route server propagation.
     * </p>
     * 
     * @return Information about the disabled route server propagation.
     */
    public final RouteServerPropagation routeServerPropagation() {
        return routeServerPropagation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeServerPropagation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableRouteServerPropagationResponse)) {
            return false;
        }
        DisableRouteServerPropagationResponse other = (DisableRouteServerPropagationResponse) obj;
        return Objects.equals(routeServerPropagation(), other.routeServerPropagation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableRouteServerPropagationResponse").add("RouteServerPropagation", routeServerPropagation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerPropagation":
            return Optional.ofNullable(clazz.cast(routeServerPropagation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerPropagation", ROUTE_SERVER_PROPAGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableRouteServerPropagationResponse, T> g) {
        return obj -> g.apply((DisableRouteServerPropagationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableRouteServerPropagationResponse> {
        /**
         * <p>
         * Information about the disabled route server propagation.
         * </p>
         * 
         * @param routeServerPropagation
         *        Information about the disabled route server propagation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerPropagation(RouteServerPropagation routeServerPropagation);

        /**
         * <p>
         * Information about the disabled route server propagation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteServerPropagation.Builder} avoiding
         * the need to create one manually via {@link RouteServerPropagation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteServerPropagation.Builder#build()} is called immediately and
         * its result is passed to {@link #routeServerPropagation(RouteServerPropagation)}.
         * 
         * @param routeServerPropagation
         *        a consumer that will call methods on {@link RouteServerPropagation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServerPropagation(RouteServerPropagation)
         */
        default Builder routeServerPropagation(Consumer<RouteServerPropagation.Builder> routeServerPropagation) {
            return routeServerPropagation(RouteServerPropagation.builder().applyMutation(routeServerPropagation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private RouteServerPropagation routeServerPropagation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableRouteServerPropagationResponse model) {
            super(model);
            routeServerPropagation(model.routeServerPropagation);
        }

        public final RouteServerPropagation.Builder getRouteServerPropagation() {
            return routeServerPropagation != null ? routeServerPropagation.toBuilder() : null;
        }

        public final void setRouteServerPropagation(RouteServerPropagation.BuilderImpl routeServerPropagation) {
            this.routeServerPropagation = routeServerPropagation != null ? routeServerPropagation.build() : null;
        }

        @Override
        public final Builder routeServerPropagation(RouteServerPropagation routeServerPropagation) {
            this.routeServerPropagation = routeServerPropagation;
            return this;
        }

        @Override
        public DisableRouteServerPropagationResponse build() {
            return new DisableRouteServerPropagationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
