/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyManagedPrefixListRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyManagedPrefixListRequest.Builder, ModifyManagedPrefixListRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyManagedPrefixListRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(ModifyManagedPrefixListRequest::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("PrefixListId").build()).build();

    private static final SdkField<Long> CURRENT_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentVersion")
            .getter(getter(ModifyManagedPrefixListRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion")
                    .unmarshallLocationName("CurrentVersion").build()).build();

    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListName")
            .getter(getter(ModifyManagedPrefixListRequest::prefixListName))
            .setter(setter(Builder::prefixListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName")
                    .unmarshallLocationName("PrefixListName").build()).build();

    private static final SdkField<List<AddPrefixListEntry>> ADD_ENTRIES_FIELD = SdkField
            .<List<AddPrefixListEntry>> builder(MarshallingType.LIST)
            .memberName("AddEntries")
            .getter(getter(ModifyManagedPrefixListRequest::addEntries))
            .setter(setter(Builder::addEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddEntry")
                    .unmarshallLocationName("AddEntry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddPrefixListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddPrefixListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<RemovePrefixListEntry>> REMOVE_ENTRIES_FIELD = SdkField
            .<List<RemovePrefixListEntry>> builder(MarshallingType.LIST)
            .memberName("RemoveEntries")
            .getter(getter(ModifyManagedPrefixListRequest::removeEntries))
            .setter(setter(Builder::removeEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEntry")
                    .unmarshallLocationName("RemoveEntry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemovePrefixListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemovePrefixListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_ENTRIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxEntries")
            .getter(getter(ModifyManagedPrefixListRequest::maxEntries))
            .setter(setter(Builder::maxEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEntries")
                    .unmarshallLocationName("MaxEntries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            PREFIX_LIST_ID_FIELD, CURRENT_VERSION_FIELD, PREFIX_LIST_NAME_FIELD, ADD_ENTRIES_FIELD, REMOVE_ENTRIES_FIELD,
            MAX_ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String prefixListId;

    private final Long currentVersion;

    private final String prefixListName;

    private final List<AddPrefixListEntry> addEntries;

    private final List<RemovePrefixListEntry> removeEntries;

    private final Integer maxEntries;

    private ModifyManagedPrefixListRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.prefixListId = builder.prefixListId;
        this.currentVersion = builder.currentVersion;
        this.prefixListName = builder.prefixListName;
        this.addEntries = builder.addEntries;
        this.removeEntries = builder.removeEntries;
        this.maxEntries = builder.maxEntries;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The current version of the prefix list.
     * </p>
     * 
     * @return The current version of the prefix list.
     */
    public final Long currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * A name for the prefix list.
     * </p>
     * 
     * @return A name for the prefix list.
     */
    public final String prefixListName() {
        return prefixListName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddEntries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddEntries() {
        return addEntries != null && !(addEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more entries to add to the prefix list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddEntries} method.
     * </p>
     * 
     * @return One or more entries to add to the prefix list.
     */
    public final List<AddPrefixListEntry> addEntries() {
        return addEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveEntries() {
        return removeEntries != null && !(removeEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more entries to remove from the prefix list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveEntries} method.
     * </p>
     * 
     * @return One or more entries to remove from the prefix list.
     */
    public final List<RemovePrefixListEntry> removeEntries() {
        return removeEntries;
    }

    /**
     * <p>
     * The maximum number of entries for the prefix list. You cannot modify the entries of a prefix list and modify the
     * size of a prefix list at the same time.
     * </p>
     * <p>
     * If any of the resources that reference the prefix list cannot support the new maximum size, the modify operation
     * fails. Check the state message for the IDs of the first ten resources that do not support the new maximum size.
     * </p>
     * 
     * @return The maximum number of entries for the prefix list. You cannot modify the entries of a prefix list and
     *         modify the size of a prefix list at the same time.</p>
     *         <p>
     *         If any of the resources that reference the prefix list cannot support the new maximum size, the modify
     *         operation fails. Check the state message for the IDs of the first ten resources that do not support the
     *         new maximum size.
     */
    public final Integer maxEntries() {
        return maxEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddEntries() ? addEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveEntries() ? removeEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxEntries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyManagedPrefixListRequest)) {
            return false;
        }
        ModifyManagedPrefixListRequest other = (ModifyManagedPrefixListRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(prefixListName(), other.prefixListName()) && hasAddEntries() == other.hasAddEntries()
                && Objects.equals(addEntries(), other.addEntries()) && hasRemoveEntries() == other.hasRemoveEntries()
                && Objects.equals(removeEntries(), other.removeEntries()) && Objects.equals(maxEntries(), other.maxEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyManagedPrefixListRequest").add("DryRun", dryRun()).add("PrefixListId", prefixListId())
                .add("CurrentVersion", currentVersion()).add("PrefixListName", prefixListName())
                .add("AddEntries", hasAddEntries() ? addEntries() : null)
                .add("RemoveEntries", hasRemoveEntries() ? removeEntries() : null).add("MaxEntries", maxEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "PrefixListName":
            return Optional.ofNullable(clazz.cast(prefixListName()));
        case "AddEntries":
            return Optional.ofNullable(clazz.cast(addEntries()));
        case "RemoveEntries":
            return Optional.ofNullable(clazz.cast(removeEntries()));
        case "MaxEntries":
            return Optional.ofNullable(clazz.cast(maxEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        map.put("PrefixListName", PREFIX_LIST_NAME_FIELD);
        map.put("AddEntry", ADD_ENTRIES_FIELD);
        map.put("RemoveEntry", REMOVE_ENTRIES_FIELD);
        map.put("MaxEntries", MAX_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyManagedPrefixListRequest, T> g) {
        return obj -> g.apply((ModifyManagedPrefixListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyManagedPrefixListRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The current version of the prefix list.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(Long currentVersion);

        /**
         * <p>
         * A name for the prefix list.
         * </p>
         * 
         * @param prefixListName
         *        A name for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListName(String prefixListName);

        /**
         * <p>
         * One or more entries to add to the prefix list.
         * </p>
         * 
         * @param addEntries
         *        One or more entries to add to the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addEntries(Collection<AddPrefixListEntry> addEntries);

        /**
         * <p>
         * One or more entries to add to the prefix list.
         * </p>
         * 
         * @param addEntries
         *        One or more entries to add to the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addEntries(AddPrefixListEntry... addEntries);

        /**
         * <p>
         * One or more entries to add to the prefix list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddPrefixListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AddPrefixListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddPrefixListEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #addEntries(List<AddPrefixListEntry>)}.
         * 
         * @param addEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddPrefixListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addEntries(java.util.Collection<AddPrefixListEntry>)
         */
        Builder addEntries(Consumer<AddPrefixListEntry.Builder>... addEntries);

        /**
         * <p>
         * One or more entries to remove from the prefix list.
         * </p>
         * 
         * @param removeEntries
         *        One or more entries to remove from the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeEntries(Collection<RemovePrefixListEntry> removeEntries);

        /**
         * <p>
         * One or more entries to remove from the prefix list.
         * </p>
         * 
         * @param removeEntries
         *        One or more entries to remove from the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeEntries(RemovePrefixListEntry... removeEntries);

        /**
         * <p>
         * One or more entries to remove from the prefix list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #removeEntries(List<RemovePrefixListEntry>)}.
         * 
         * @param removeEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeEntries(java.util.Collection<RemovePrefixListEntry>)
         */
        Builder removeEntries(Consumer<RemovePrefixListEntry.Builder>... removeEntries);

        /**
         * <p>
         * The maximum number of entries for the prefix list. You cannot modify the entries of a prefix list and modify
         * the size of a prefix list at the same time.
         * </p>
         * <p>
         * If any of the resources that reference the prefix list cannot support the new maximum size, the modify
         * operation fails. Check the state message for the IDs of the first ten resources that do not support the new
         * maximum size.
         * </p>
         * 
         * @param maxEntries
         *        The maximum number of entries for the prefix list. You cannot modify the entries of a prefix list and
         *        modify the size of a prefix list at the same time.</p>
         *        <p>
         *        If any of the resources that reference the prefix list cannot support the new maximum size, the modify
         *        operation fails. Check the state message for the IDs of the first ten resources that do not support
         *        the new maximum size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEntries(Integer maxEntries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String prefixListId;

        private Long currentVersion;

        private String prefixListName;

        private List<AddPrefixListEntry> addEntries = DefaultSdkAutoConstructList.getInstance();

        private List<RemovePrefixListEntry> removeEntries = DefaultSdkAutoConstructList.getInstance();

        private Integer maxEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyManagedPrefixListRequest model) {
            super(model);
            dryRun(model.dryRun);
            prefixListId(model.prefixListId);
            currentVersion(model.currentVersion);
            prefixListName(model.prefixListName);
            addEntries(model.addEntries);
            removeEntries(model.removeEntries);
            maxEntries(model.maxEntries);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final Long getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getPrefixListName() {
            return prefixListName;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final List<AddPrefixListEntry.Builder> getAddEntries() {
            List<AddPrefixListEntry.Builder> result = AddPrefixListEntriesCopier.copyToBuilder(this.addEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddEntries(Collection<AddPrefixListEntry.BuilderImpl> addEntries) {
            this.addEntries = AddPrefixListEntriesCopier.copyFromBuilder(addEntries);
        }

        @Override
        public final Builder addEntries(Collection<AddPrefixListEntry> addEntries) {
            this.addEntries = AddPrefixListEntriesCopier.copy(addEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addEntries(AddPrefixListEntry... addEntries) {
            addEntries(Arrays.asList(addEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addEntries(Consumer<AddPrefixListEntry.Builder>... addEntries) {
            addEntries(Stream.of(addEntries).map(c -> AddPrefixListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RemovePrefixListEntry.Builder> getRemoveEntries() {
            List<RemovePrefixListEntry.Builder> result = RemovePrefixListEntriesCopier.copyToBuilder(this.removeEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveEntries(Collection<RemovePrefixListEntry.BuilderImpl> removeEntries) {
            this.removeEntries = RemovePrefixListEntriesCopier.copyFromBuilder(removeEntries);
        }

        @Override
        public final Builder removeEntries(Collection<RemovePrefixListEntry> removeEntries) {
            this.removeEntries = RemovePrefixListEntriesCopier.copy(removeEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeEntries(RemovePrefixListEntry... removeEntries) {
            removeEntries(Arrays.asList(removeEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeEntries(Consumer<RemovePrefixListEntry.Builder>... removeEntries) {
            removeEntries(Stream.of(removeEntries).map(c -> RemovePrefixListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxEntries() {
            return maxEntries;
        }

        public final void setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
        }

        @Override
        public final Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyManagedPrefixListRequest build() {
            return new ModifyManagedPrefixListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
