/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcBlockPublicAccessExclusionResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteVpcBlockPublicAccessExclusionResponse.Builder, DeleteVpcBlockPublicAccessExclusionResponse> {
    private static final SdkField<VpcBlockPublicAccessExclusion> VPC_BLOCK_PUBLIC_ACCESS_EXCLUSION_FIELD = SdkField
            .<VpcBlockPublicAccessExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("VpcBlockPublicAccessExclusion")
            .getter(getter(DeleteVpcBlockPublicAccessExclusionResponse::vpcBlockPublicAccessExclusion))
            .setter(setter(Builder::vpcBlockPublicAccessExclusion))
            .constructor(VpcBlockPublicAccessExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcBlockPublicAccessExclusion")
                    .unmarshallLocationName("vpcBlockPublicAccessExclusion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_BLOCK_PUBLIC_ACCESS_EXCLUSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcBlockPublicAccessExclusion vpcBlockPublicAccessExclusion;

    private DeleteVpcBlockPublicAccessExclusionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcBlockPublicAccessExclusion = builder.vpcBlockPublicAccessExclusion;
    }

    /**
     * <p>
     * Details about an exclusion.
     * </p>
     * 
     * @return Details about an exclusion.
     */
    public final VpcBlockPublicAccessExclusion vpcBlockPublicAccessExclusion() {
        return vpcBlockPublicAccessExclusion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcBlockPublicAccessExclusion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcBlockPublicAccessExclusionResponse)) {
            return false;
        }
        DeleteVpcBlockPublicAccessExclusionResponse other = (DeleteVpcBlockPublicAccessExclusionResponse) obj;
        return Objects.equals(vpcBlockPublicAccessExclusion(), other.vpcBlockPublicAccessExclusion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcBlockPublicAccessExclusionResponse")
                .add("VpcBlockPublicAccessExclusion", vpcBlockPublicAccessExclusion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcBlockPublicAccessExclusion":
            return Optional.ofNullable(clazz.cast(vpcBlockPublicAccessExclusion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcBlockPublicAccessExclusion", VPC_BLOCK_PUBLIC_ACCESS_EXCLUSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcBlockPublicAccessExclusionResponse, T> g) {
        return obj -> g.apply((DeleteVpcBlockPublicAccessExclusionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcBlockPublicAccessExclusionResponse> {
        /**
         * <p>
         * Details about an exclusion.
         * </p>
         * 
         * @param vpcBlockPublicAccessExclusion
         *        Details about an exclusion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcBlockPublicAccessExclusion(VpcBlockPublicAccessExclusion vpcBlockPublicAccessExclusion);

        /**
         * <p>
         * Details about an exclusion.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcBlockPublicAccessExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcBlockPublicAccessExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcBlockPublicAccessExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcBlockPublicAccessExclusion(VpcBlockPublicAccessExclusion)}.
         * 
         * @param vpcBlockPublicAccessExclusion
         *        a consumer that will call methods on {@link VpcBlockPublicAccessExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcBlockPublicAccessExclusion(VpcBlockPublicAccessExclusion)
         */
        default Builder vpcBlockPublicAccessExclusion(
                Consumer<VpcBlockPublicAccessExclusion.Builder> vpcBlockPublicAccessExclusion) {
            return vpcBlockPublicAccessExclusion(VpcBlockPublicAccessExclusion.builder()
                    .applyMutation(vpcBlockPublicAccessExclusion).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpcBlockPublicAccessExclusion vpcBlockPublicAccessExclusion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcBlockPublicAccessExclusionResponse model) {
            super(model);
            vpcBlockPublicAccessExclusion(model.vpcBlockPublicAccessExclusion);
        }

        public final VpcBlockPublicAccessExclusion.Builder getVpcBlockPublicAccessExclusion() {
            return vpcBlockPublicAccessExclusion != null ? vpcBlockPublicAccessExclusion.toBuilder() : null;
        }

        public final void setVpcBlockPublicAccessExclusion(VpcBlockPublicAccessExclusion.BuilderImpl vpcBlockPublicAccessExclusion) {
            this.vpcBlockPublicAccessExclusion = vpcBlockPublicAccessExclusion != null ? vpcBlockPublicAccessExclusion.build()
                    : null;
        }

        @Override
        public final Builder vpcBlockPublicAccessExclusion(VpcBlockPublicAccessExclusion vpcBlockPublicAccessExclusion) {
            this.vpcBlockPublicAccessExclusion = vpcBlockPublicAccessExclusion;
            return this;
        }

        @Override
        public DeleteVpcBlockPublicAccessExclusionResponse build() {
            return new DeleteVpcBlockPublicAccessExclusionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
