/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamScopeResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyIpamScopeResponse.Builder, ModifyIpamScopeResponse> {
    private static final SdkField<IpamScope> IPAM_SCOPE_FIELD = SdkField
            .<IpamScope> builder(MarshallingType.SDK_POJO)
            .memberName("IpamScope")
            .getter(getter(ModifyIpamScopeResponse::ipamScope))
            .setter(setter(Builder::ipamScope))
            .constructor(IpamScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScope")
                    .unmarshallLocationName("ipamScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamScope ipamScope;

    private ModifyIpamScopeResponse(BuilderImpl builder) {
        super(builder);
        this.ipamScope = builder.ipamScope;
    }

    /**
     * <p>
     * The results of the modification.
     * </p>
     * 
     * @return The results of the modification.
     */
    public final IpamScope ipamScope() {
        return ipamScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamScopeResponse)) {
            return false;
        }
        ModifyIpamScopeResponse other = (ModifyIpamScopeResponse) obj;
        return Objects.equals(ipamScope(), other.ipamScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamScopeResponse").add("IpamScope", ipamScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamScope":
            return Optional.ofNullable(clazz.cast(ipamScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamScope", IPAM_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamScopeResponse, T> g) {
        return obj -> g.apply((ModifyIpamScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamScopeResponse> {
        /**
         * <p>
         * The results of the modification.
         * </p>
         * 
         * @param ipamScope
         *        The results of the modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamScope(IpamScope ipamScope);

        /**
         * <p>
         * The results of the modification.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamScope.Builder} avoiding the need to
         * create one manually via {@link IpamScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamScope.Builder#build()} is called immediately and its result
         * is passed to {@link #ipamScope(IpamScope)}.
         * 
         * @param ipamScope
         *        a consumer that will call methods on {@link IpamScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamScope(IpamScope)
         */
        default Builder ipamScope(Consumer<IpamScope.Builder> ipamScope) {
            return ipamScope(IpamScope.builder().applyMutation(ipamScope).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamScope ipamScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamScopeResponse model) {
            super(model);
            ipamScope(model.ipamScope);
        }

        public final IpamScope.Builder getIpamScope() {
            return ipamScope != null ? ipamScope.toBuilder() : null;
        }

        public final void setIpamScope(IpamScope.BuilderImpl ipamScope) {
            this.ipamScope = ipamScope != null ? ipamScope.build() : null;
        }

        @Override
        public final Builder ipamScope(IpamScope ipamScope) {
            this.ipamScope = ipamScope;
            return this;
        }

        @Override
        public ModifyIpamScopeResponse build() {
            return new ModifyIpamScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
