/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointServicePermissionsResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyVpcEndpointServicePermissionsResponse.Builder, ModifyVpcEndpointServicePermissionsResponse> {
    private static final SdkField<List<AddedPrincipal>> ADDED_PRINCIPALS_FIELD = SdkField
            .<List<AddedPrincipal>> builder(MarshallingType.LIST)
            .memberName("AddedPrincipals")
            .getter(getter(ModifyVpcEndpointServicePermissionsResponse::addedPrincipals))
            .setter(setter(Builder::addedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddedPrincipalSet")
                    .unmarshallLocationName("addedPrincipalSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AddedPrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddedPrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnValue")
            .getter(getter(ModifyVpcEndpointServicePermissionsResponse::returnValue))
            .setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return")
                    .unmarshallLocationName("return").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_PRINCIPALS_FIELD,
            RETURN_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AddedPrincipal> addedPrincipals;

    private final Boolean returnValue;

    private ModifyVpcEndpointServicePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.addedPrincipals = builder.addedPrincipals;
        this.returnValue = builder.returnValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddedPrincipals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddedPrincipals() {
        return addedPrincipals != null && !(addedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the added principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddedPrincipals} method.
     * </p>
     * 
     * @return Information about the added principals.
     */
    public final List<AddedPrincipal> addedPrincipals() {
        return addedPrincipals;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddedPrincipals() ? addedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServicePermissionsResponse)) {
            return false;
        }
        ModifyVpcEndpointServicePermissionsResponse other = (ModifyVpcEndpointServicePermissionsResponse) obj;
        return hasAddedPrincipals() == other.hasAddedPrincipals() && Objects.equals(addedPrincipals(), other.addedPrincipals())
                && Objects.equals(returnValue(), other.returnValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcEndpointServicePermissionsResponse")
                .add("AddedPrincipals", hasAddedPrincipals() ? addedPrincipals() : null).add("ReturnValue", returnValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddedPrincipals":
            return Optional.ofNullable(clazz.cast(addedPrincipals()));
        case "ReturnValue":
            return Optional.ofNullable(clazz.cast(returnValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddedPrincipalSet", ADDED_PRINCIPALS_FIELD);
        map.put("Return", RETURN_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServicePermissionsResponse, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServicePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsResponse> {
        /**
         * <p>
         * Information about the added principals.
         * </p>
         * 
         * @param addedPrincipals
         *        Information about the added principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedPrincipals(Collection<AddedPrincipal> addedPrincipals);

        /**
         * <p>
         * Information about the added principals.
         * </p>
         * 
         * @param addedPrincipals
         *        Information about the added principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedPrincipals(AddedPrincipal... addedPrincipals);

        /**
         * <p>
         * Information about the added principals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddedPrincipal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AddedPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddedPrincipal.Builder#build()} is called immediately and
         * its result is passed to {@link #addedPrincipals(List<AddedPrincipal>)}.
         * 
         * @param addedPrincipals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddedPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addedPrincipals(java.util.Collection<AddedPrincipal>)
         */
        Builder addedPrincipals(Consumer<AddedPrincipal.Builder>... addedPrincipals);

        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * </p>
         * 
         * @param returnValue
         *        Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<AddedPrincipal> addedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServicePermissionsResponse model) {
            super(model);
            addedPrincipals(model.addedPrincipals);
            returnValue(model.returnValue);
        }

        public final List<AddedPrincipal.Builder> getAddedPrincipals() {
            List<AddedPrincipal.Builder> result = AddedPrincipalSetCopier.copyToBuilder(this.addedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddedPrincipals(Collection<AddedPrincipal.BuilderImpl> addedPrincipals) {
            this.addedPrincipals = AddedPrincipalSetCopier.copyFromBuilder(addedPrincipals);
        }

        @Override
        public final Builder addedPrincipals(Collection<AddedPrincipal> addedPrincipals) {
            this.addedPrincipals = AddedPrincipalSetCopier.copy(addedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addedPrincipals(AddedPrincipal... addedPrincipals) {
            addedPrincipals(Arrays.asList(addedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addedPrincipals(Consumer<AddedPrincipal.Builder>... addedPrincipals) {
            addedPrincipals(Stream.of(addedPrincipals).map(c -> AddedPrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        @Override
        public ModifyVpcEndpointServicePermissionsResponse build() {
            return new ModifyVpcEndpointServicePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
