/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the rule options for a stateful rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupRuleOptionsPair implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupRuleOptionsPair.Builder, RuleGroupRuleOptionsPair> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn")
            .getter(getter(RuleGroupRuleOptionsPair::ruleGroupArn))
            .setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn")
                    .unmarshallLocationName("ruleGroupArn").build()).build();

    private static final SdkField<List<RuleOption>> RULE_OPTIONS_FIELD = SdkField
            .<List<RuleOption>> builder(MarshallingType.LIST)
            .memberName("RuleOptions")
            .getter(getter(RuleGroupRuleOptionsPair::ruleOptions))
            .setter(setter(Builder::ruleOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOptionSet")
                    .unmarshallLocationName("ruleOptionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RuleOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD,
            RULE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleGroupArn;

    private final List<RuleOption> ruleOptions;

    private RuleGroupRuleOptionsPair(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleOptions = builder.ruleOptions;
    }

    /**
     * <p>
     * The ARN of the rule group.
     * </p>
     * 
     * @return The ARN of the rule group.
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleOptions() {
        return ruleOptions != null && !(ruleOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleOptions} method.
     * </p>
     * 
     * @return The rule options.
     */
    public final List<RuleOption> ruleOptions() {
        return ruleOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleOptions() ? ruleOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupRuleOptionsPair)) {
            return false;
        }
        RuleGroupRuleOptionsPair other = (RuleGroupRuleOptionsPair) obj;
        return Objects.equals(ruleGroupArn(), other.ruleGroupArn()) && hasRuleOptions() == other.hasRuleOptions()
                && Objects.equals(ruleOptions(), other.ruleOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupRuleOptionsPair").add("RuleGroupArn", ruleGroupArn())
                .add("RuleOptions", hasRuleOptions() ? ruleOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "RuleOptions":
            return Optional.ofNullable(clazz.cast(ruleOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleGroupArn", RULE_GROUP_ARN_FIELD);
        map.put("RuleOptionSet", RULE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupRuleOptionsPair, T> g) {
        return obj -> g.apply((RuleGroupRuleOptionsPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupRuleOptionsPair> {
        /**
         * <p>
         * The ARN of the rule group.
         * </p>
         * 
         * @param ruleGroupArn
         *        The ARN of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The rule options.
         * </p>
         * 
         * @param ruleOptions
         *        The rule options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOptions(Collection<RuleOption> ruleOptions);

        /**
         * <p>
         * The rule options.
         * </p>
         * 
         * @param ruleOptions
         *        The rule options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOptions(RuleOption... ruleOptions);

        /**
         * <p>
         * The rule options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RuleOption.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.RuleOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RuleOption.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleOptions(List<RuleOption>)}.
         * 
         * @param ruleOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RuleOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleOptions(java.util.Collection<RuleOption>)
         */
        Builder ruleOptions(Consumer<RuleOption.Builder>... ruleOptions);
    }

    static final class BuilderImpl implements Builder {
        private String ruleGroupArn;

        private List<RuleOption> ruleOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupRuleOptionsPair model) {
            ruleGroupArn(model.ruleGroupArn);
            ruleOptions(model.ruleOptions);
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final List<RuleOption.Builder> getRuleOptions() {
            List<RuleOption.Builder> result = RuleOptionListCopier.copyToBuilder(this.ruleOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleOptions(Collection<RuleOption.BuilderImpl> ruleOptions) {
            this.ruleOptions = RuleOptionListCopier.copyFromBuilder(ruleOptions);
        }

        @Override
        public final Builder ruleOptions(Collection<RuleOption> ruleOptions) {
            this.ruleOptions = RuleOptionListCopier.copy(ruleOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(RuleOption... ruleOptions) {
            ruleOptions(Arrays.asList(ruleOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(Consumer<RuleOption.Builder>... ruleOptions) {
            ruleOptions(Stream.of(ruleOptions).map(c -> RuleOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RuleGroupRuleOptionsPair build() {
            return new RuleGroupRuleOptionsPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
