/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Capacity Reservation Fleet that could not be cancelled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedCapacityReservationFleetCancellationResult
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<FailedCapacityReservationFleetCancellationResult.Builder, FailedCapacityReservationFleetCancellationResult> {
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationFleetId")
            .getter(getter(FailedCapacityReservationFleetCancellationResult::capacityReservationFleetId))
            .setter(setter(Builder::capacityReservationFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId")
                    .unmarshallLocationName("capacityReservationFleetId").build()).build();

    private static final SdkField<CancelCapacityReservationFleetError> CANCEL_CAPACITY_RESERVATION_FLEET_ERROR_FIELD = SdkField
            .<CancelCapacityReservationFleetError> builder(MarshallingType.SDK_POJO)
            .memberName("CancelCapacityReservationFleetError")
            .getter(getter(FailedCapacityReservationFleetCancellationResult::cancelCapacityReservationFleetError))
            .setter(setter(Builder::cancelCapacityReservationFleetError))
            .constructor(CancelCapacityReservationFleetError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CancelCapacityReservationFleetError")
                    .unmarshallLocationName("cancelCapacityReservationFleetError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_FLEET_ID_FIELD, CANCEL_CAPACITY_RESERVATION_FLEET_ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationFleetId;

    private final CancelCapacityReservationFleetError cancelCapacityReservationFleetError;

    private FailedCapacityReservationFleetCancellationResult(BuilderImpl builder) {
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
        this.cancelCapacityReservationFleetError = builder.cancelCapacityReservationFleetError;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation Fleet that could not be cancelled.
     * </p>
     * 
     * @return The ID of the Capacity Reservation Fleet that could not be cancelled.
     */
    public final String capacityReservationFleetId() {
        return capacityReservationFleetId;
    }

    /**
     * <p>
     * Information about the Capacity Reservation Fleet cancellation error.
     * </p>
     * 
     * @return Information about the Capacity Reservation Fleet cancellation error.
     */
    public final CancelCapacityReservationFleetError cancelCapacityReservationFleetError() {
        return cancelCapacityReservationFleetError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(cancelCapacityReservationFleetError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCapacityReservationFleetCancellationResult)) {
            return false;
        }
        FailedCapacityReservationFleetCancellationResult other = (FailedCapacityReservationFleetCancellationResult) obj;
        return Objects.equals(capacityReservationFleetId(), other.capacityReservationFleetId())
                && Objects.equals(cancelCapacityReservationFleetError(), other.cancelCapacityReservationFleetError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedCapacityReservationFleetCancellationResult")
                .add("CapacityReservationFleetId", capacityReservationFleetId())
                .add("CancelCapacityReservationFleetError", cancelCapacityReservationFleetError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationFleetId":
            return Optional.ofNullable(clazz.cast(capacityReservationFleetId()));
        case "CancelCapacityReservationFleetError":
            return Optional.ofNullable(clazz.cast(cancelCapacityReservationFleetError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationFleetId", CAPACITY_RESERVATION_FLEET_ID_FIELD);
        map.put("CancelCapacityReservationFleetError", CANCEL_CAPACITY_RESERVATION_FLEET_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedCapacityReservationFleetCancellationResult, T> g) {
        return obj -> g.apply((FailedCapacityReservationFleetCancellationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedCapacityReservationFleetCancellationResult> {
        /**
         * <p>
         * The ID of the Capacity Reservation Fleet that could not be cancelled.
         * </p>
         * 
         * @param capacityReservationFleetId
         *        The ID of the Capacity Reservation Fleet that could not be cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationFleetId(String capacityReservationFleetId);

        /**
         * <p>
         * Information about the Capacity Reservation Fleet cancellation error.
         * </p>
         * 
         * @param cancelCapacityReservationFleetError
         *        Information about the Capacity Reservation Fleet cancellation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelCapacityReservationFleetError(CancelCapacityReservationFleetError cancelCapacityReservationFleetError);

        /**
         * <p>
         * Information about the Capacity Reservation Fleet cancellation error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CancelCapacityReservationFleetError.Builder} avoiding the need to create one manually via
         * {@link CancelCapacityReservationFleetError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CancelCapacityReservationFleetError.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cancelCapacityReservationFleetError(CancelCapacityReservationFleetError)}.
         * 
         * @param cancelCapacityReservationFleetError
         *        a consumer that will call methods on {@link CancelCapacityReservationFleetError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancelCapacityReservationFleetError(CancelCapacityReservationFleetError)
         */
        default Builder cancelCapacityReservationFleetError(
                Consumer<CancelCapacityReservationFleetError.Builder> cancelCapacityReservationFleetError) {
            return cancelCapacityReservationFleetError(CancelCapacityReservationFleetError.builder()
                    .applyMutation(cancelCapacityReservationFleetError).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationFleetId;

        private CancelCapacityReservationFleetError cancelCapacityReservationFleetError;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCapacityReservationFleetCancellationResult model) {
            capacityReservationFleetId(model.capacityReservationFleetId);
            cancelCapacityReservationFleetError(model.cancelCapacityReservationFleetError);
        }

        public final String getCapacityReservationFleetId() {
            return capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public final CancelCapacityReservationFleetError.Builder getCancelCapacityReservationFleetError() {
            return cancelCapacityReservationFleetError != null ? cancelCapacityReservationFleetError.toBuilder() : null;
        }

        public final void setCancelCapacityReservationFleetError(
                CancelCapacityReservationFleetError.BuilderImpl cancelCapacityReservationFleetError) {
            this.cancelCapacityReservationFleetError = cancelCapacityReservationFleetError != null ? cancelCapacityReservationFleetError
                    .build() : null;
        }

        @Override
        public final Builder cancelCapacityReservationFleetError(
                CancelCapacityReservationFleetError cancelCapacityReservationFleetError) {
            this.cancelCapacityReservationFleetError = cancelCapacityReservationFleetError;
            return this;
        }

        @Override
        public FailedCapacityReservationFleetCancellationResult build() {
            return new FailedCapacityReservationFleetCancellationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
