/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The start day and time and the end day and time of the time range, in UTC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceEventWindowTimeRangeRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceEventWindowTimeRangeRequest.Builder, InstanceEventWindowTimeRangeRequest> {
    private static final SdkField<String> START_WEEK_DAY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartWeekDay")
            .getter(getter(InstanceEventWindowTimeRangeRequest::startWeekDayAsString))
            .setter(setter(Builder::startWeekDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWeekDay")
                    .unmarshallLocationName("StartWeekDay").build()).build();

    private static final SdkField<Integer> START_HOUR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartHour")
            .getter(getter(InstanceEventWindowTimeRangeRequest::startHour))
            .setter(setter(Builder::startHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartHour")
                    .unmarshallLocationName("StartHour").build()).build();

    private static final SdkField<String> END_WEEK_DAY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EndWeekDay")
            .getter(getter(InstanceEventWindowTimeRangeRequest::endWeekDayAsString))
            .setter(setter(Builder::endWeekDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndWeekDay")
                    .unmarshallLocationName("EndWeekDay").build()).build();

    private static final SdkField<Integer> END_HOUR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndHour")
            .getter(getter(InstanceEventWindowTimeRangeRequest::endHour))
            .setter(setter(Builder::endHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndHour")
                    .unmarshallLocationName("EndHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_WEEK_DAY_FIELD,
            START_HOUR_FIELD, END_WEEK_DAY_FIELD, END_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String startWeekDay;

    private final Integer startHour;

    private final String endWeekDay;

    private final Integer endHour;

    private InstanceEventWindowTimeRangeRequest(BuilderImpl builder) {
        this.startWeekDay = builder.startWeekDay;
        this.startHour = builder.startHour;
        this.endWeekDay = builder.endWeekDay;
        this.endHour = builder.endHour;
    }

    /**
     * <p>
     * The day on which the time range begins.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startWeekDay} will
     * return {@link WeekDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #startWeekDayAsString}.
     * </p>
     * 
     * @return The day on which the time range begins.
     * @see WeekDay
     */
    public final WeekDay startWeekDay() {
        return WeekDay.fromValue(startWeekDay);
    }

    /**
     * <p>
     * The day on which the time range begins.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startWeekDay} will
     * return {@link WeekDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #startWeekDayAsString}.
     * </p>
     * 
     * @return The day on which the time range begins.
     * @see WeekDay
     */
    public final String startWeekDayAsString() {
        return startWeekDay;
    }

    /**
     * <p>
     * The hour when the time range begins.
     * </p>
     * 
     * @return The hour when the time range begins.
     */
    public final Integer startHour() {
        return startHour;
    }

    /**
     * <p>
     * The day on which the time range ends.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endWeekDay} will
     * return {@link WeekDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endWeekDayAsString}.
     * </p>
     * 
     * @return The day on which the time range ends.
     * @see WeekDay
     */
    public final WeekDay endWeekDay() {
        return WeekDay.fromValue(endWeekDay);
    }

    /**
     * <p>
     * The day on which the time range ends.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endWeekDay} will
     * return {@link WeekDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endWeekDayAsString}.
     * </p>
     * 
     * @return The day on which the time range ends.
     * @see WeekDay
     */
    public final String endWeekDayAsString() {
        return endWeekDay;
    }

    /**
     * <p>
     * The hour when the time range ends.
     * </p>
     * 
     * @return The hour when the time range ends.
     */
    public final Integer endHour() {
        return endHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startWeekDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startHour());
        hashCode = 31 * hashCode + Objects.hashCode(endWeekDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindowTimeRangeRequest)) {
            return false;
        }
        InstanceEventWindowTimeRangeRequest other = (InstanceEventWindowTimeRangeRequest) obj;
        return Objects.equals(startWeekDayAsString(), other.startWeekDayAsString())
                && Objects.equals(startHour(), other.startHour())
                && Objects.equals(endWeekDayAsString(), other.endWeekDayAsString()) && Objects.equals(endHour(), other.endHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceEventWindowTimeRangeRequest").add("StartWeekDay", startWeekDayAsString())
                .add("StartHour", startHour()).add("EndWeekDay", endWeekDayAsString()).add("EndHour", endHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartWeekDay":
            return Optional.ofNullable(clazz.cast(startWeekDayAsString()));
        case "StartHour":
            return Optional.ofNullable(clazz.cast(startHour()));
        case "EndWeekDay":
            return Optional.ofNullable(clazz.cast(endWeekDayAsString()));
        case "EndHour":
            return Optional.ofNullable(clazz.cast(endHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartWeekDay", START_WEEK_DAY_FIELD);
        map.put("StartHour", START_HOUR_FIELD);
        map.put("EndWeekDay", END_WEEK_DAY_FIELD);
        map.put("EndHour", END_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindowTimeRangeRequest, T> g) {
        return obj -> g.apply((InstanceEventWindowTimeRangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceEventWindowTimeRangeRequest> {
        /**
         * <p>
         * The day on which the time range begins.
         * </p>
         * 
         * @param startWeekDay
         *        The day on which the time range begins.
         * @see WeekDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WeekDay
         */
        Builder startWeekDay(String startWeekDay);

        /**
         * <p>
         * The day on which the time range begins.
         * </p>
         * 
         * @param startWeekDay
         *        The day on which the time range begins.
         * @see WeekDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WeekDay
         */
        Builder startWeekDay(WeekDay startWeekDay);

        /**
         * <p>
         * The hour when the time range begins.
         * </p>
         * 
         * @param startHour
         *        The hour when the time range begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startHour(Integer startHour);

        /**
         * <p>
         * The day on which the time range ends.
         * </p>
         * 
         * @param endWeekDay
         *        The day on which the time range ends.
         * @see WeekDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WeekDay
         */
        Builder endWeekDay(String endWeekDay);

        /**
         * <p>
         * The day on which the time range ends.
         * </p>
         * 
         * @param endWeekDay
         *        The day on which the time range ends.
         * @see WeekDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WeekDay
         */
        Builder endWeekDay(WeekDay endWeekDay);

        /**
         * <p>
         * The hour when the time range ends.
         * </p>
         * 
         * @param endHour
         *        The hour when the time range ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endHour(Integer endHour);
    }

    static final class BuilderImpl implements Builder {
        private String startWeekDay;

        private Integer startHour;

        private String endWeekDay;

        private Integer endHour;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindowTimeRangeRequest model) {
            startWeekDay(model.startWeekDay);
            startHour(model.startHour);
            endWeekDay(model.endWeekDay);
            endHour(model.endHour);
        }

        public final String getStartWeekDay() {
            return startWeekDay;
        }

        public final void setStartWeekDay(String startWeekDay) {
            this.startWeekDay = startWeekDay;
        }

        @Override
        public final Builder startWeekDay(String startWeekDay) {
            this.startWeekDay = startWeekDay;
            return this;
        }

        @Override
        public final Builder startWeekDay(WeekDay startWeekDay) {
            this.startWeekDay(startWeekDay == null ? null : startWeekDay.toString());
            return this;
        }

        public final Integer getStartHour() {
            return startHour;
        }

        public final void setStartHour(Integer startHour) {
            this.startHour = startHour;
        }

        @Override
        public final Builder startHour(Integer startHour) {
            this.startHour = startHour;
            return this;
        }

        public final String getEndWeekDay() {
            return endWeekDay;
        }

        public final void setEndWeekDay(String endWeekDay) {
            this.endWeekDay = endWeekDay;
        }

        @Override
        public final Builder endWeekDay(String endWeekDay) {
            this.endWeekDay = endWeekDay;
            return this;
        }

        @Override
        public final Builder endWeekDay(WeekDay endWeekDay) {
            this.endWeekDay(endWeekDay == null ? null : endWeekDay.toString());
            return this;
        }

        public final Integer getEndHour() {
            return endHour;
        }

        public final void setEndHour(Integer endHour) {
            this.endHour = endHour;
        }

        @Override
        public final Builder endHour(Integer endHour) {
            this.endHour = endHour;
            return this;
        }

        @Override
        public InstanceEventWindowTimeRangeRequest build() {
            return new InstanceEventWindowTimeRangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
