/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the private IPv4 address of a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterfacePrivateIpAddress implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterfacePrivateIpAddress.Builder, NetworkInterfacePrivateIpAddress> {
    private static final SdkField<NetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField
            .<NetworkInterfaceAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("Association")
            .getter(getter(NetworkInterfacePrivateIpAddress::association))
            .setter(setter(Builder::association))
            .constructor(NetworkInterfaceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association")
                    .unmarshallLocationName("association").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary")
            .getter(getter(NetworkInterfacePrivateIpAddress::primary))
            .setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary")
                    .unmarshallLocationName("primary").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(NetworkInterfacePrivateIpAddress::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(NetworkInterfacePrivateIpAddress::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD,
            PRIMARY_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NetworkInterfaceAssociation association;

    private final Boolean primary;

    private final String privateDnsName;

    private final String privateIpAddress;

    private NetworkInterfacePrivateIpAddress(BuilderImpl builder) {
        this.association = builder.association;
        this.primary = builder.primary;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public final NetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     * </p>
     * 
     * @return Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     */
    public final Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IPv4 address.
     * </p>
     * 
     * @return The private IPv4 address.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePrivateIpAddress)) {
            return false;
        }
        NetworkInterfacePrivateIpAddress other = (NetworkInterfacePrivateIpAddress) obj;
        return Objects.equals(association(), other.association()) && Objects.equals(primary(), other.primary())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterfacePrivateIpAddress").add("Association", association()).add("Primary", primary())
                .add("PrivateDnsName", privateDnsName()).add("PrivateIpAddress", privateIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Association", ASSOCIATION_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        map.put("PrivateDnsName", PRIVATE_DNS_NAME_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfacePrivateIpAddress, T> g) {
        return obj -> g.apply((NetworkInterfacePrivateIpAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IP address (IPv4) associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(NetworkInterfaceAssociation association);

        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkInterfaceAssociation.Builder}
         * avoiding the need to create one manually via {@link NetworkInterfaceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkInterfaceAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(NetworkInterfaceAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link NetworkInterfaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(NetworkInterfaceAssociation)
         */
        default Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return association(NetworkInterfaceAssociation.builder().applyMutation(association).build());
        }

        /**
         * <p>
         * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         * </p>
         * 
         * @param primary
         *        Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IPv4 address.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private NetworkInterfaceAssociation association;

        private Boolean primary;

        private String privateDnsName;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePrivateIpAddress model) {
            association(model.association);
            primary(model.primary);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        @Override
        public NetworkInterfacePrivateIpAddress build() {
            return new NetworkInterfacePrivateIpAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
