/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathStatement implements SdkPojo, Serializable, ToCopyableBuilder<PathStatement.Builder, PathStatement> {
    private static final SdkField<PacketHeaderStatement> PACKET_HEADER_STATEMENT_FIELD = SdkField
            .<PacketHeaderStatement> builder(MarshallingType.SDK_POJO)
            .memberName("PacketHeaderStatement")
            .getter(getter(PathStatement::packetHeaderStatement))
            .setter(setter(Builder::packetHeaderStatement))
            .constructor(PacketHeaderStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketHeaderStatement")
                    .unmarshallLocationName("packetHeaderStatement").build()).build();

    private static final SdkField<ResourceStatement> RESOURCE_STATEMENT_FIELD = SdkField
            .<ResourceStatement> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceStatement")
            .getter(getter(PathStatement::resourceStatement))
            .setter(setter(Builder::resourceStatement))
            .constructor(ResourceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatement")
                    .unmarshallLocationName("resourceStatement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKET_HEADER_STATEMENT_FIELD,
            RESOURCE_STATEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PacketHeaderStatement packetHeaderStatement;

    private final ResourceStatement resourceStatement;

    private PathStatement(BuilderImpl builder) {
        this.packetHeaderStatement = builder.packetHeaderStatement;
        this.resourceStatement = builder.resourceStatement;
    }

    /**
     * <p>
     * The packet header statement.
     * </p>
     * 
     * @return The packet header statement.
     */
    public final PacketHeaderStatement packetHeaderStatement() {
        return packetHeaderStatement;
    }

    /**
     * <p>
     * The resource statement.
     * </p>
     * 
     * @return The resource statement.
     */
    public final ResourceStatement resourceStatement() {
        return resourceStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packetHeaderStatement());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathStatement)) {
            return false;
        }
        PathStatement other = (PathStatement) obj;
        return Objects.equals(packetHeaderStatement(), other.packetHeaderStatement())
                && Objects.equals(resourceStatement(), other.resourceStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathStatement").add("PacketHeaderStatement", packetHeaderStatement())
                .add("ResourceStatement", resourceStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PacketHeaderStatement":
            return Optional.ofNullable(clazz.cast(packetHeaderStatement()));
        case "ResourceStatement":
            return Optional.ofNullable(clazz.cast(resourceStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PacketHeaderStatement", PACKET_HEADER_STATEMENT_FIELD);
        map.put("ResourceStatement", RESOURCE_STATEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathStatement, T> g) {
        return obj -> g.apply((PathStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathStatement> {
        /**
         * <p>
         * The packet header statement.
         * </p>
         * 
         * @param packetHeaderStatement
         *        The packet header statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetHeaderStatement(PacketHeaderStatement packetHeaderStatement);

        /**
         * <p>
         * The packet header statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link PacketHeaderStatement.Builder} avoiding
         * the need to create one manually via {@link PacketHeaderStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PacketHeaderStatement.Builder#build()} is called immediately and
         * its result is passed to {@link #packetHeaderStatement(PacketHeaderStatement)}.
         * 
         * @param packetHeaderStatement
         *        a consumer that will call methods on {@link PacketHeaderStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packetHeaderStatement(PacketHeaderStatement)
         */
        default Builder packetHeaderStatement(Consumer<PacketHeaderStatement.Builder> packetHeaderStatement) {
            return packetHeaderStatement(PacketHeaderStatement.builder().applyMutation(packetHeaderStatement).build());
        }

        /**
         * <p>
         * The resource statement.
         * </p>
         * 
         * @param resourceStatement
         *        The resource statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatement(ResourceStatement resourceStatement);

        /**
         * <p>
         * The resource statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceStatement.Builder} avoiding the
         * need to create one manually via {@link ResourceStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceStatement.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceStatement(ResourceStatement)}.
         * 
         * @param resourceStatement
         *        a consumer that will call methods on {@link ResourceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceStatement(ResourceStatement)
         */
        default Builder resourceStatement(Consumer<ResourceStatement.Builder> resourceStatement) {
            return resourceStatement(ResourceStatement.builder().applyMutation(resourceStatement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PacketHeaderStatement packetHeaderStatement;

        private ResourceStatement resourceStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(PathStatement model) {
            packetHeaderStatement(model.packetHeaderStatement);
            resourceStatement(model.resourceStatement);
        }

        public final PacketHeaderStatement.Builder getPacketHeaderStatement() {
            return packetHeaderStatement != null ? packetHeaderStatement.toBuilder() : null;
        }

        public final void setPacketHeaderStatement(PacketHeaderStatement.BuilderImpl packetHeaderStatement) {
            this.packetHeaderStatement = packetHeaderStatement != null ? packetHeaderStatement.build() : null;
        }

        @Override
        public final Builder packetHeaderStatement(PacketHeaderStatement packetHeaderStatement) {
            this.packetHeaderStatement = packetHeaderStatement;
            return this;
        }

        public final ResourceStatement.Builder getResourceStatement() {
            return resourceStatement != null ? resourceStatement.toBuilder() : null;
        }

        public final void setResourceStatement(ResourceStatement.BuilderImpl resourceStatement) {
            this.resourceStatement = resourceStatement != null ? resourceStatement.build() : null;
        }

        @Override
        public final Builder resourceStatement(ResourceStatement resourceStatement) {
            this.resourceStatement = resourceStatement;
            return this;
        }

        @Override
        public PathStatement build() {
            return new PathStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
