/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcPeeringConnectionResponse extends Ec2Response implements
        ToCopyableBuilder<CreateVpcPeeringConnectionResponse.Builder, CreateVpcPeeringConnectionResponse> {
    private static final SdkField<VpcPeeringConnection> VPC_PEERING_CONNECTION_FIELD = SdkField
            .<VpcPeeringConnection> builder(MarshallingType.SDK_POJO)
            .memberName("VpcPeeringConnection")
            .getter(getter(CreateVpcPeeringConnectionResponse::vpcPeeringConnection))
            .setter(setter(Builder::vpcPeeringConnection))
            .constructor(VpcPeeringConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnection")
                    .unmarshallLocationName("vpcPeeringConnection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_PEERING_CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcPeeringConnection vpcPeeringConnection;

    private CreateVpcPeeringConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnection = builder.vpcPeeringConnection;
    }

    /**
     * <p>
     * Information about the VPC peering connection.
     * </p>
     * 
     * @return Information about the VPC peering connection.
     */
    public final VpcPeeringConnection vpcPeeringConnection() {
        return vpcPeeringConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionResponse)) {
            return false;
        }
        CreateVpcPeeringConnectionResponse other = (CreateVpcPeeringConnectionResponse) obj;
        return Objects.equals(vpcPeeringConnection(), other.vpcPeeringConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcPeeringConnectionResponse").add("VpcPeeringConnection", vpcPeeringConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringConnection":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcPeeringConnection", VPC_PEERING_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcPeeringConnectionResponse, T> g) {
        return obj -> g.apply((CreateVpcPeeringConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcPeeringConnectionResponse> {
        /**
         * <p>
         * Information about the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnection
         *        Information about the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection);

        /**
         * <p>
         * Information about the VPC peering connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcPeeringConnection.Builder} avoiding
         * the need to create one manually via {@link VpcPeeringConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcPeeringConnection.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcPeeringConnection(VpcPeeringConnection)}.
         * 
         * @param vpcPeeringConnection
         *        a consumer that will call methods on {@link VpcPeeringConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringConnection(VpcPeeringConnection)
         */
        default Builder vpcPeeringConnection(Consumer<VpcPeeringConnection.Builder> vpcPeeringConnection) {
            return vpcPeeringConnection(VpcPeeringConnection.builder().applyMutation(vpcPeeringConnection).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpcPeeringConnection vpcPeeringConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionResponse model) {
            super(model);
            vpcPeeringConnection(model.vpcPeeringConnection);
        }

        public final VpcPeeringConnection.Builder getVpcPeeringConnection() {
            return vpcPeeringConnection != null ? vpcPeeringConnection.toBuilder() : null;
        }

        public final void setVpcPeeringConnection(VpcPeeringConnection.BuilderImpl vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection != null ? vpcPeeringConnection.build() : null;
        }

        @Override
        public final Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionResponse build() {
            return new CreateVpcPeeringConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
