/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.IpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.IpamState;
import software.amazon.awssdk.services.ec2.model.IpamTier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ipam
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ipam> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Ipam.getter(Ipam::ownerId)).setter(Ipam.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(Ipam.getter(Ipam::ipamId)).setter(Ipam.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("ipamId").build()}).build();
    private static final SdkField<String> IPAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamArn").getter(Ipam.getter(Ipam::ipamArn)).setter(Ipam.setter(Builder::ipamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn").unmarshallLocationName("ipamArn").build()}).build();
    private static final SdkField<String> IPAM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamRegion").getter(Ipam.getter(Ipam::ipamRegion)).setter(Ipam.setter(Builder::ipamRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion").unmarshallLocationName("ipamRegion").build()}).build();
    private static final SdkField<String> PUBLIC_DEFAULT_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicDefaultScopeId").getter(Ipam.getter(Ipam::publicDefaultScopeId)).setter(Ipam.setter(Builder::publicDefaultScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDefaultScopeId").unmarshallLocationName("publicDefaultScopeId").build()}).build();
    private static final SdkField<String> PRIVATE_DEFAULT_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDefaultScopeId").getter(Ipam.getter(Ipam::privateDefaultScopeId)).setter(Ipam.setter(Builder::privateDefaultScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDefaultScopeId").unmarshallLocationName("privateDefaultScopeId").build()}).build();
    private static final SdkField<Integer> SCOPE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScopeCount").getter(Ipam.getter(Ipam::scopeCount)).setter(Ipam.setter(Builder::scopeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeCount").unmarshallLocationName("scopeCount").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Ipam.getter(Ipam::description)).setter(Ipam.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<IpamOperatingRegion>> OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingRegions").getter(Ipam.getter(Ipam::operatingRegions)).setter(Ipam.setter(Builder::operatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingRegionSet").unmarshallLocationName("operatingRegionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Ipam.getter(Ipam::stateAsString)).setter(Ipam.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Ipam.getter(Ipam::tags)).setter(Ipam.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultResourceDiscoveryId").getter(Ipam.getter(Ipam::defaultResourceDiscoveryId)).setter(Ipam.setter(Builder::defaultResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceDiscoveryId").unmarshallLocationName("defaultResourceDiscoveryId").build()}).build();
    private static final SdkField<String> DEFAULT_RESOURCE_DISCOVERY_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultResourceDiscoveryAssociationId").getter(Ipam.getter(Ipam::defaultResourceDiscoveryAssociationId)).setter(Ipam.setter(Builder::defaultResourceDiscoveryAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceDiscoveryAssociationId").unmarshallLocationName("defaultResourceDiscoveryAssociationId").build()}).build();
    private static final SdkField<Integer> RESOURCE_DISCOVERY_ASSOCIATION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourceDiscoveryAssociationCount").getter(Ipam.getter(Ipam::resourceDiscoveryAssociationCount)).setter(Ipam.setter(Builder::resourceDiscoveryAssociationCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDiscoveryAssociationCount").unmarshallLocationName("resourceDiscoveryAssociationCount").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(Ipam.getter(Ipam::stateMessage)).setter(Ipam.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(Ipam.getter(Ipam::tierAsString)).setter(Ipam.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").unmarshallLocationName("tier").build()}).build();
    private static final SdkField<Boolean> ENABLE_PRIVATE_GUA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrivateGua").getter(Ipam.getter(Ipam::enablePrivateGua)).setter(Ipam.setter(Builder::enablePrivateGua)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrivateGua").unmarshallLocationName("enablePrivateGua").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_ID_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, PUBLIC_DEFAULT_SCOPE_ID_FIELD, PRIVATE_DEFAULT_SCOPE_ID_FIELD, SCOPE_COUNT_FIELD, DESCRIPTION_FIELD, OPERATING_REGIONS_FIELD, STATE_FIELD, TAGS_FIELD, DEFAULT_RESOURCE_DISCOVERY_ID_FIELD, DEFAULT_RESOURCE_DISCOVERY_ASSOCIATION_ID_FIELD, RESOURCE_DISCOVERY_ASSOCIATION_COUNT_FIELD, STATE_MESSAGE_FIELD, TIER_FIELD, ENABLE_PRIVATE_GUA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ipam.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamId;
    private final String ipamArn;
    private final String ipamRegion;
    private final String publicDefaultScopeId;
    private final String privateDefaultScopeId;
    private final Integer scopeCount;
    private final String description;
    private final List<IpamOperatingRegion> operatingRegions;
    private final String state;
    private final List<Tag> tags;
    private final String defaultResourceDiscoveryId;
    private final String defaultResourceDiscoveryAssociationId;
    private final Integer resourceDiscoveryAssociationCount;
    private final String stateMessage;
    private final String tier;
    private final Boolean enablePrivateGua;

    private Ipam(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamId = builder.ipamId;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.publicDefaultScopeId = builder.publicDefaultScopeId;
        this.privateDefaultScopeId = builder.privateDefaultScopeId;
        this.scopeCount = builder.scopeCount;
        this.description = builder.description;
        this.operatingRegions = builder.operatingRegions;
        this.state = builder.state;
        this.tags = builder.tags;
        this.defaultResourceDiscoveryId = builder.defaultResourceDiscoveryId;
        this.defaultResourceDiscoveryAssociationId = builder.defaultResourceDiscoveryAssociationId;
        this.resourceDiscoveryAssociationCount = builder.resourceDiscoveryAssociationCount;
        this.stateMessage = builder.stateMessage;
        this.tier = builder.tier;
        this.enablePrivateGua = builder.enablePrivateGua;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String ipamArn() {
        return this.ipamArn;
    }

    public final String ipamRegion() {
        return this.ipamRegion;
    }

    public final String publicDefaultScopeId() {
        return this.publicDefaultScopeId;
    }

    public final String privateDefaultScopeId() {
        return this.privateDefaultScopeId;
    }

    public final Integer scopeCount() {
        return this.scopeCount;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOperatingRegions() {
        return this.operatingRegions != null && !(this.operatingRegions instanceof SdkAutoConstructList);
    }

    public final List<IpamOperatingRegion> operatingRegions() {
        return this.operatingRegions;
    }

    public final IpamState state() {
        return IpamState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String defaultResourceDiscoveryId() {
        return this.defaultResourceDiscoveryId;
    }

    public final String defaultResourceDiscoveryAssociationId() {
        return this.defaultResourceDiscoveryAssociationId;
    }

    public final Integer resourceDiscoveryAssociationCount() {
        return this.resourceDiscoveryAssociationCount;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final IpamTier tier() {
        return IpamTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Boolean enablePrivateGua() {
        return this.enablePrivateGua;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDefaultScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDefaultScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingRegions() ? this.operatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceDiscoveryAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDiscoveryAssociationCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrivateGua());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipam)) {
            return false;
        }
        Ipam other = (Ipam)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.ipamArn(), other.ipamArn()) && Objects.equals(this.ipamRegion(), other.ipamRegion()) && Objects.equals(this.publicDefaultScopeId(), other.publicDefaultScopeId()) && Objects.equals(this.privateDefaultScopeId(), other.privateDefaultScopeId()) && Objects.equals(this.scopeCount(), other.scopeCount()) && Objects.equals(this.description(), other.description()) && this.hasOperatingRegions() == other.hasOperatingRegions() && Objects.equals(this.operatingRegions(), other.operatingRegions()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.defaultResourceDiscoveryId(), other.defaultResourceDiscoveryId()) && Objects.equals(this.defaultResourceDiscoveryAssociationId(), other.defaultResourceDiscoveryAssociationId()) && Objects.equals(this.resourceDiscoveryAssociationCount(), other.resourceDiscoveryAssociationCount()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.enablePrivateGua(), other.enablePrivateGua());
    }

    public final String toString() {
        return ToString.builder((String)"Ipam").add("OwnerId", (Object)this.ownerId()).add("IpamId", (Object)this.ipamId()).add("IpamArn", (Object)this.ipamArn()).add("IpamRegion", (Object)this.ipamRegion()).add("PublicDefaultScopeId", (Object)this.publicDefaultScopeId()).add("PrivateDefaultScopeId", (Object)this.privateDefaultScopeId()).add("ScopeCount", (Object)this.scopeCount()).add("Description", (Object)this.description()).add("OperatingRegions", this.hasOperatingRegions() ? this.operatingRegions() : null).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("DefaultResourceDiscoveryId", (Object)this.defaultResourceDiscoveryId()).add("DefaultResourceDiscoveryAssociationId", (Object)this.defaultResourceDiscoveryAssociationId()).add("ResourceDiscoveryAssociationCount", (Object)this.resourceDiscoveryAssociationCount()).add("StateMessage", (Object)this.stateMessage()).add("Tier", (Object)this.tierAsString()).add("EnablePrivateGua", (Object)this.enablePrivateGua()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "IpamArn": {
                return Optional.ofNullable(clazz.cast(this.ipamArn()));
            }
            case "IpamRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamRegion()));
            }
            case "PublicDefaultScopeId": {
                return Optional.ofNullable(clazz.cast(this.publicDefaultScopeId()));
            }
            case "PrivateDefaultScopeId": {
                return Optional.ofNullable(clazz.cast(this.privateDefaultScopeId()));
            }
            case "ScopeCount": {
                return Optional.ofNullable(clazz.cast(this.scopeCount()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.operatingRegions()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DefaultResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceDiscoveryId()));
            }
            case "DefaultResourceDiscoveryAssociationId": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceDiscoveryAssociationId()));
            }
            case "ResourceDiscoveryAssociationCount": {
                return Optional.ofNullable(clazz.cast(this.resourceDiscoveryAssociationCount()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "EnablePrivateGua": {
                return Optional.ofNullable(clazz.cast(this.enablePrivateGua()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("IpamArn", IPAM_ARN_FIELD);
        map.put("IpamRegion", IPAM_REGION_FIELD);
        map.put("PublicDefaultScopeId", PUBLIC_DEFAULT_SCOPE_ID_FIELD);
        map.put("PrivateDefaultScopeId", PRIVATE_DEFAULT_SCOPE_ID_FIELD);
        map.put("ScopeCount", SCOPE_COUNT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OperatingRegionSet", OPERATING_REGIONS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("DefaultResourceDiscoveryId", DEFAULT_RESOURCE_DISCOVERY_ID_FIELD);
        map.put("DefaultResourceDiscoveryAssociationId", DEFAULT_RESOURCE_DISCOVERY_ASSOCIATION_ID_FIELD);
        map.put("ResourceDiscoveryAssociationCount", RESOURCE_DISCOVERY_ASSOCIATION_COUNT_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("EnablePrivateGua", ENABLE_PRIVATE_GUA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ipam, T> g) {
        return obj -> g.apply((Ipam)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamId;
        private String ipamArn;
        private String ipamRegion;
        private String publicDefaultScopeId;
        private String privateDefaultScopeId;
        private Integer scopeCount;
        private String description;
        private List<IpamOperatingRegion> operatingRegions = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String defaultResourceDiscoveryId;
        private String defaultResourceDiscoveryAssociationId;
        private Integer resourceDiscoveryAssociationCount;
        private String stateMessage;
        private String tier;
        private Boolean enablePrivateGua;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipam model) {
            this.ownerId(model.ownerId);
            this.ipamId(model.ipamId);
            this.ipamArn(model.ipamArn);
            this.ipamRegion(model.ipamRegion);
            this.publicDefaultScopeId(model.publicDefaultScopeId);
            this.privateDefaultScopeId(model.privateDefaultScopeId);
            this.scopeCount(model.scopeCount);
            this.description(model.description);
            this.operatingRegions(model.operatingRegions);
            this.state(model.state);
            this.tags(model.tags);
            this.defaultResourceDiscoveryId(model.defaultResourceDiscoveryId);
            this.defaultResourceDiscoveryAssociationId(model.defaultResourceDiscoveryAssociationId);
            this.resourceDiscoveryAssociationCount(model.resourceDiscoveryAssociationCount);
            this.stateMessage(model.stateMessage);
            this.tier(model.tier);
            this.enablePrivateGua(model.enablePrivateGua);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getIpamArn() {
            return this.ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return this.ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final String getPublicDefaultScopeId() {
            return this.publicDefaultScopeId;
        }

        public final void setPublicDefaultScopeId(String publicDefaultScopeId) {
            this.publicDefaultScopeId = publicDefaultScopeId;
        }

        @Override
        public final Builder publicDefaultScopeId(String publicDefaultScopeId) {
            this.publicDefaultScopeId = publicDefaultScopeId;
            return this;
        }

        public final String getPrivateDefaultScopeId() {
            return this.privateDefaultScopeId;
        }

        public final void setPrivateDefaultScopeId(String privateDefaultScopeId) {
            this.privateDefaultScopeId = privateDefaultScopeId;
        }

        @Override
        public final Builder privateDefaultScopeId(String privateDefaultScopeId) {
            this.privateDefaultScopeId = privateDefaultScopeId;
            return this;
        }

        public final Integer getScopeCount() {
            return this.scopeCount;
        }

        public final void setScopeCount(Integer scopeCount) {
            this.scopeCount = scopeCount;
        }

        @Override
        public final Builder scopeCount(Integer scopeCount) {
            this.scopeCount = scopeCount;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IpamOperatingRegion.Builder> getOperatingRegions() {
            List<IpamOperatingRegion.Builder> result = IpamOperatingRegionSetCopier.copyToBuilder(this.operatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingRegions(Collection<IpamOperatingRegion.BuilderImpl> operatingRegions) {
            this.operatingRegions = IpamOperatingRegionSetCopier.copyFromBuilder(operatingRegions);
        }

        @Override
        public final Builder operatingRegions(Collection<IpamOperatingRegion> operatingRegions) {
            this.operatingRegions = IpamOperatingRegionSetCopier.copy(operatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(IpamOperatingRegion ... operatingRegions) {
            this.operatingRegions(Arrays.asList(operatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(Consumer<IpamOperatingRegion.Builder> ... operatingRegions) {
            this.operatingRegions(Stream.of(operatingRegions).map(c -> (IpamOperatingRegion)((IpamOperatingRegion.Builder)IpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultResourceDiscoveryId() {
            return this.defaultResourceDiscoveryId;
        }

        public final void setDefaultResourceDiscoveryId(String defaultResourceDiscoveryId) {
            this.defaultResourceDiscoveryId = defaultResourceDiscoveryId;
        }

        @Override
        public final Builder defaultResourceDiscoveryId(String defaultResourceDiscoveryId) {
            this.defaultResourceDiscoveryId = defaultResourceDiscoveryId;
            return this;
        }

        public final String getDefaultResourceDiscoveryAssociationId() {
            return this.defaultResourceDiscoveryAssociationId;
        }

        public final void setDefaultResourceDiscoveryAssociationId(String defaultResourceDiscoveryAssociationId) {
            this.defaultResourceDiscoveryAssociationId = defaultResourceDiscoveryAssociationId;
        }

        @Override
        public final Builder defaultResourceDiscoveryAssociationId(String defaultResourceDiscoveryAssociationId) {
            this.defaultResourceDiscoveryAssociationId = defaultResourceDiscoveryAssociationId;
            return this;
        }

        public final Integer getResourceDiscoveryAssociationCount() {
            return this.resourceDiscoveryAssociationCount;
        }

        public final void setResourceDiscoveryAssociationCount(Integer resourceDiscoveryAssociationCount) {
            this.resourceDiscoveryAssociationCount = resourceDiscoveryAssociationCount;
        }

        @Override
        public final Builder resourceDiscoveryAssociationCount(Integer resourceDiscoveryAssociationCount) {
            this.resourceDiscoveryAssociationCount = resourceDiscoveryAssociationCount;
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(IpamTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Boolean getEnablePrivateGua() {
            return this.enablePrivateGua;
        }

        public final void setEnablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
        }

        @Override
        public final Builder enablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
            return this;
        }

        public Ipam build() {
            return new Ipam(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ipam> {
        public Builder ownerId(String var1);

        public Builder ipamId(String var1);

        public Builder ipamArn(String var1);

        public Builder ipamRegion(String var1);

        public Builder publicDefaultScopeId(String var1);

        public Builder privateDefaultScopeId(String var1);

        public Builder scopeCount(Integer var1);

        public Builder description(String var1);

        public Builder operatingRegions(Collection<IpamOperatingRegion> var1);

        public Builder operatingRegions(IpamOperatingRegion ... var1);

        public Builder operatingRegions(Consumer<IpamOperatingRegion.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(IpamState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder defaultResourceDiscoveryId(String var1);

        public Builder defaultResourceDiscoveryAssociationId(String var1);

        public Builder resourceDiscoveryAssociationCount(Integer var1);

        public Builder stateMessage(String var1);

        public Builder tier(String var1);

        public Builder tier(IpamTier var1);

        public Builder enablePrivateGua(Boolean var1);
    }
}

