/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableAwsNetworkPerformanceMetricSubscriptionRequest extends Ec2Request
        implements
        ToCopyableBuilder<EnableAwsNetworkPerformanceMetricSubscriptionRequest.Builder, EnableAwsNetworkPerformanceMetricSubscriptionRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Source")
            .getter(getter(EnableAwsNetworkPerformanceMetricSubscriptionRequest::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("Source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Destination")
            .getter(getter(EnableAwsNetworkPerformanceMetricSubscriptionRequest::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("Destination").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Metric")
            .getter(getter(EnableAwsNetworkPerformanceMetricSubscriptionRequest::metricAsString))
            .setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric")
                    .unmarshallLocationName("Metric").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Statistic")
            .getter(getter(EnableAwsNetworkPerformanceMetricSubscriptionRequest::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic")
                    .unmarshallLocationName("Statistic").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableAwsNetworkPerformanceMetricSubscriptionRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String source;

    private final String destination;

    private final String metric;

    private final String statistic;

    private final Boolean dryRun;

    private EnableAwsNetworkPerformanceMetricSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The source Region (like <code>us-east-1</code>) or Availability Zone ID (like <code>use1-az1</code>) that the
     * metric subscription is enabled for. If you use Availability Zone IDs, the Source and Destination Availability
     * Zones must be in the same Region.
     * </p>
     * 
     * @return The source Region (like <code>us-east-1</code>) or Availability Zone ID (like <code>use1-az1</code>) that
     *         the metric subscription is enabled for. If you use Availability Zone IDs, the Source and Destination
     *         Availability Zones must be in the same Region.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The target Region (like <code>us-east-2</code>) or Availability Zone ID (like <code>use2-az2</code>) that the
     * metric subscription is enabled for. If you use Availability Zone IDs, the Source and Destination Availability
     * Zones must be in the same Region.
     * </p>
     * 
     * @return The target Region (like <code>us-east-2</code>) or Availability Zone ID (like <code>use2-az2</code>) that
     *         the metric subscription is enabled for. If you use Availability Zone IDs, the Source and Destination
     *         Availability Zones must be in the same Region.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The metric used for the enabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the enabled subscription.
     * @see MetricType
     */
    public final MetricType metric() {
        return MetricType.fromValue(metric);
    }

    /**
     * <p>
     * The metric used for the enabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the enabled subscription.
     * @see MetricType
     */
    public final String metricAsString() {
        return metric;
    }

    /**
     * <p>
     * The statistic used for the enabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic used for the enabled subscription.
     * @see StatisticType
     */
    public final StatisticType statistic() {
        return StatisticType.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic used for the enabled subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic used for the enabled subscription.
     * @see StatisticType
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAwsNetworkPerformanceMetricSubscriptionRequest)) {
            return false;
        }
        EnableAwsNetworkPerformanceMetricSubscriptionRequest other = (EnableAwsNetworkPerformanceMetricSubscriptionRequest) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(metricAsString(), other.metricAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableAwsNetworkPerformanceMetricSubscriptionRequest").add("Source", source())
                .add("Destination", destination()).add("Metric", metricAsString()).add("Statistic", statisticAsString())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metricAsString()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableAwsNetworkPerformanceMetricSubscriptionRequest, T> g) {
        return obj -> g.apply((EnableAwsNetworkPerformanceMetricSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableAwsNetworkPerformanceMetricSubscriptionRequest> {
        /**
         * <p>
         * The source Region (like <code>us-east-1</code>) or Availability Zone ID (like <code>use1-az1</code>) that the
         * metric subscription is enabled for. If you use Availability Zone IDs, the Source and Destination Availability
         * Zones must be in the same Region.
         * </p>
         * 
         * @param source
         *        The source Region (like <code>us-east-1</code>) or Availability Zone ID (like <code>use1-az1</code>)
         *        that the metric subscription is enabled for. If you use Availability Zone IDs, the Source and
         *        Destination Availability Zones must be in the same Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The target Region (like <code>us-east-2</code>) or Availability Zone ID (like <code>use2-az2</code>) that the
         * metric subscription is enabled for. If you use Availability Zone IDs, the Source and Destination Availability
         * Zones must be in the same Region.
         * </p>
         * 
         * @param destination
         *        The target Region (like <code>us-east-2</code>) or Availability Zone ID (like <code>use2-az2</code>)
         *        that the metric subscription is enabled for. If you use Availability Zone IDs, the Source and
         *        Destination Availability Zones must be in the same Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The metric used for the enabled subscription.
         * </p>
         * 
         * @param metric
         *        The metric used for the enabled subscription.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(String metric);

        /**
         * <p>
         * The metric used for the enabled subscription.
         * </p>
         * 
         * @param metric
         *        The metric used for the enabled subscription.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(MetricType metric);

        /**
         * <p>
         * The statistic used for the enabled subscription.
         * </p>
         * 
         * @param statistic
         *        The statistic used for the enabled subscription.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic used for the enabled subscription.
         * </p>
         * 
         * @param statistic
         *        The statistic used for the enabled subscription.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(StatisticType statistic);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String source;

        private String destination;

        private String metric;

        private String statistic;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAwsNetworkPerformanceMetricSubscriptionRequest model) {
            super(model);
            source(model.source);
            destination(model.destination);
            metric(model.metric);
            statistic(model.statistic);
            dryRun(model.dryRun);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableAwsNetworkPerformanceMetricSubscriptionRequest build() {
            return new EnableAwsNetworkPerformanceMetricSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
