/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamRequest.Builder, ModifyIpamRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyIpamRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamId")
            .getter(getter(ModifyIpamRequest::ipamId))
            .setter(setter(Builder::ipamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId")
                    .unmarshallLocationName("IpamId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyIpamRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<AddIpamOperatingRegion>> ADD_OPERATING_REGIONS_FIELD = SdkField
            .<List<AddIpamOperatingRegion>> builder(MarshallingType.LIST)
            .memberName("AddOperatingRegions")
            .getter(getter(ModifyIpamRequest::addOperatingRegions))
            .setter(setter(Builder::addOperatingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOperatingRegion")
                    .unmarshallLocationName("AddOperatingRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddIpamOperatingRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddIpamOperatingRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<RemoveIpamOperatingRegion>> REMOVE_OPERATING_REGIONS_FIELD = SdkField
            .<List<RemoveIpamOperatingRegion>> builder(MarshallingType.LIST)
            .memberName("RemoveOperatingRegions")
            .getter(getter(ModifyIpamRequest::removeOperatingRegions))
            .setter(setter(Builder::removeOperatingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOperatingRegion")
                    .unmarshallLocationName("RemoveOperatingRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoveIpamOperatingRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoveIpamOperatingRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tier")
            .getter(getter(ModifyIpamRequest::tierAsString))
            .setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier")
                    .unmarshallLocationName("Tier").build()).build();

    private static final SdkField<Boolean> ENABLE_PRIVATE_GUA_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnablePrivateGua")
            .getter(getter(ModifyIpamRequest::enablePrivateGua))
            .setter(setter(Builder::enablePrivateGua))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrivateGua")
                    .unmarshallLocationName("EnablePrivateGua").build()).build();

    private static final SdkField<String> METERED_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MeteredAccount")
            .getter(getter(ModifyIpamRequest::meteredAccountAsString))
            .setter(setter(Builder::meteredAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredAccount")
                    .unmarshallLocationName("MeteredAccount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_ID_FIELD,
            DESCRIPTION_FIELD, ADD_OPERATING_REGIONS_FIELD, REMOVE_OPERATING_REGIONS_FIELD, TIER_FIELD, ENABLE_PRIVATE_GUA_FIELD,
            METERED_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamId;

    private final String description;

    private final List<AddIpamOperatingRegion> addOperatingRegions;

    private final List<RemoveIpamOperatingRegion> removeOperatingRegions;

    private final String tier;

    private final Boolean enablePrivateGua;

    private final String meteredAccount;

    private ModifyIpamRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamId = builder.ipamId;
        this.description = builder.description;
        this.addOperatingRegions = builder.addOperatingRegions;
        this.removeOperatingRegions = builder.removeOperatingRegions;
        this.tier = builder.tier;
        this.enablePrivateGua = builder.enablePrivateGua;
        this.meteredAccount = builder.meteredAccount;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM you want to modify.
     * </p>
     * 
     * @return The ID of the IPAM you want to modify.
     */
    public final String ipamId() {
        return ipamId;
    }

    /**
     * <p>
     * The description of the IPAM you want to modify.
     * </p>
     * 
     * @return The description of the IPAM you want to modify.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOperatingRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddOperatingRegions() {
        return addOperatingRegions != null && !(addOperatingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is
     * allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions
     * you select as operating Regions.
     * </p>
     * <p>
     * For more information about operating Regions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOperatingRegions} method.
     * </p>
     * 
     * @return Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the
     *         IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
     *         Services Regions you select as operating Regions.</p>
     *         <p>
     *         For more information about operating Regions, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon
     *         VPC IPAM User Guide</i>.
     */
    public final List<AddIpamOperatingRegion> addOperatingRegions() {
        return addOperatingRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveOperatingRegions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveOperatingRegions() {
        return removeOperatingRegions != null && !(removeOperatingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating Regions to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveOperatingRegions} method.
     * </p>
     * 
     * @return The operating Regions to remove.
     */
    public final List<RemoveIpamOperatingRegion> removeOperatingRegions() {
        return removeOperatingRegions;
    }

    /**
     * <p>
     * IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available in each
     * tier and the costs associated with the tiers, see <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing
     * &gt; IPAM tab</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link IpamTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available in
     *         each tier and the costs associated with the tiers, see <a
     *         href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing &gt; IPAM tab</a>.
     * @see IpamTier
     */
    public final IpamTier tier() {
        return IpamTier.fromValue(tier);
    }

    /**
     * <p>
     * IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available in each
     * tier and the costs associated with the tiers, see <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing
     * &gt; IPAM tab</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link IpamTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available in
     *         each tier and the costs associated with the tiers, see <a
     *         href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing &gt; IPAM tab</a>.
     * @see IpamTier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by default.
     * </p>
     * 
     * @return Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by
     *         default.
     */
    public final Boolean enablePrivateGua() {
        return enablePrivateGua;
    }

    /**
     * <p>
     * A metered account is an Amazon Web Services account that is charged for active IP addresses managed in IPAM. For
     * more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable
     * cost distribution</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for all active
     * IP addresses managed in IPAM.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for the active
     * IP address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteredAccount}
     * will return {@link IpamMeteredAccount#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #meteredAccountAsString}.
     * </p>
     * 
     * @return A metered account is an Amazon Web Services account that is charged for active IP addresses managed in
     *         IPAM. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable cost
     *         distribution</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     *         <p>
     *         Possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for all
     *         active IP addresses managed in IPAM.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for the
     *         active IP address.
     *         </p>
     *         </li>
     * @see IpamMeteredAccount
     */
    public final IpamMeteredAccount meteredAccount() {
        return IpamMeteredAccount.fromValue(meteredAccount);
    }

    /**
     * <p>
     * A metered account is an Amazon Web Services account that is charged for active IP addresses managed in IPAM. For
     * more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable
     * cost distribution</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for all active
     * IP addresses managed in IPAM.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for the active
     * IP address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteredAccount}
     * will return {@link IpamMeteredAccount#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #meteredAccountAsString}.
     * </p>
     * 
     * @return A metered account is an Amazon Web Services account that is charged for active IP addresses managed in
     *         IPAM. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable cost
     *         distribution</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     *         <p>
     *         Possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for all
     *         active IP addresses managed in IPAM.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for the
     *         active IP address.
     *         </p>
     *         </li>
     * @see IpamMeteredAccount
     */
    public final String meteredAccountAsString() {
        return meteredAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOperatingRegions() ? addOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveOperatingRegions() ? removeOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePrivateGua());
        hashCode = 31 * hashCode + Objects.hashCode(meteredAccountAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamRequest)) {
            return false;
        }
        ModifyIpamRequest other = (ModifyIpamRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamId(), other.ipamId())
                && Objects.equals(description(), other.description())
                && hasAddOperatingRegions() == other.hasAddOperatingRegions()
                && Objects.equals(addOperatingRegions(), other.addOperatingRegions())
                && hasRemoveOperatingRegions() == other.hasRemoveOperatingRegions()
                && Objects.equals(removeOperatingRegions(), other.removeOperatingRegions())
                && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(enablePrivateGua(), other.enablePrivateGua())
                && Objects.equals(meteredAccountAsString(), other.meteredAccountAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamRequest").add("DryRun", dryRun()).add("IpamId", ipamId())
                .add("Description", description())
                .add("AddOperatingRegions", hasAddOperatingRegions() ? addOperatingRegions() : null)
                .add("RemoveOperatingRegions", hasRemoveOperatingRegions() ? removeOperatingRegions() : null)
                .add("Tier", tierAsString()).add("EnablePrivateGua", enablePrivateGua())
                .add("MeteredAccount", meteredAccountAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamId":
            return Optional.ofNullable(clazz.cast(ipamId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AddOperatingRegions":
            return Optional.ofNullable(clazz.cast(addOperatingRegions()));
        case "RemoveOperatingRegions":
            return Optional.ofNullable(clazz.cast(removeOperatingRegions()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "EnablePrivateGua":
            return Optional.ofNullable(clazz.cast(enablePrivateGua()));
        case "MeteredAccount":
            return Optional.ofNullable(clazz.cast(meteredAccountAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AddOperatingRegion", ADD_OPERATING_REGIONS_FIELD);
        map.put("RemoveOperatingRegion", REMOVE_OPERATING_REGIONS_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("EnablePrivateGua", ENABLE_PRIVATE_GUA_FIELD);
        map.put("MeteredAccount", METERED_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamRequest, T> g) {
        return obj -> g.apply((ModifyIpamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM you want to modify.
         * </p>
         * 
         * @param ipamId
         *        The ID of the IPAM you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamId(String ipamId);

        /**
         * <p>
         * The description of the IPAM you want to modify.
         * </p>
         * 
         * @param description
         *        The description of the IPAM you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM
         * is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
         * Regions you select as operating Regions.
         * </p>
         * <p>
         * For more information about operating Regions, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC
         * IPAM User Guide</i>.
         * </p>
         * 
         * @param addOperatingRegions
         *        Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the
         *        IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon
         *        Web Services Regions you select as operating Regions.</p>
         *        <p>
         *        For more information about operating Regions, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions);

        /**
         * <p>
         * Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM
         * is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
         * Regions you select as operating Regions.
         * </p>
         * <p>
         * For more information about operating Regions, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC
         * IPAM User Guide</i>.
         * </p>
         * 
         * @param addOperatingRegions
         *        Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the
         *        IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon
         *        Web Services Regions you select as operating Regions.</p>
         *        <p>
         *        For more information about operating Regions, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOperatingRegions(AddIpamOperatingRegion... addOperatingRegions);

        /**
         * <p>
         * Choose the operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM
         * is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
         * Regions you select as operating Regions.
         * </p>
         * <p>
         * For more information about operating Regions, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC
         * IPAM User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #addOperatingRegions(List<AddIpamOperatingRegion>)}.
         * 
         * @param addOperatingRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOperatingRegions(java.util.Collection<AddIpamOperatingRegion>)
         */
        Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder>... addOperatingRegions);

        /**
         * <p>
         * The operating Regions to remove.
         * </p>
         * 
         * @param removeOperatingRegions
         *        The operating Regions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions);

        /**
         * <p>
         * The operating Regions to remove.
         * </p>
         * 
         * @param removeOperatingRegions
         *        The operating Regions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOperatingRegions(RemoveIpamOperatingRegion... removeOperatingRegions);

        /**
         * <p>
         * The operating Regions to remove.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #removeOperatingRegions(List<RemoveIpamOperatingRegion>)}.
         * 
         * @param removeOperatingRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeOperatingRegions(java.util.Collection<RemoveIpamOperatingRegion>)
         */
        Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder>... removeOperatingRegions);

        /**
         * <p>
         * IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available in
         * each tier and the costs associated with the tiers, see <a href="http://aws.amazon.com/vpc/pricing/">Amazon
         * VPC pricing &gt; IPAM tab</a>.
         * </p>
         * 
         * @param tier
         *        IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available
         *        in each tier and the costs associated with the tiers, see <a
         *        href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing &gt; IPAM tab</a>.
         * @see IpamTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamTier
         */
        Builder tier(String tier);

        /**
         * <p>
         * IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available in
         * each tier and the costs associated with the tiers, see <a href="http://aws.amazon.com/vpc/pricing/">Amazon
         * VPC pricing &gt; IPAM tab</a>.
         * </p>
         * 
         * @param tier
         *        IPAM is offered in a Free Tier and an Advanced Tier. For more information about the features available
         *        in each tier and the costs associated with the tiers, see <a
         *        href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing &gt; IPAM tab</a>.
         * @see IpamTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamTier
         */
        Builder tier(IpamTier tier);

        /**
         * <p>
         * Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by default.
         * </p>
         * 
         * @param enablePrivateGua
         *        Enable this option to use your own GUA ranges as private IPv6 addresses. This option is disabled by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePrivateGua(Boolean enablePrivateGua);

        /**
         * <p>
         * A metered account is an Amazon Web Services account that is charged for active IP addresses managed in IPAM.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable cost distribution</a>
         * in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <p>
         * Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for all
         * active IP addresses managed in IPAM.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for the
         * active IP address.
         * </p>
         * </li>
         * </ul>
         * 
         * @param meteredAccount
         *        A metered account is an Amazon Web Services account that is charged for active IP addresses managed in
         *        IPAM. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable cost
         *        distribution</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
         *        <p>
         *        Possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for
         *        all active IP addresses managed in IPAM.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for
         *        the active IP address.
         *        </p>
         *        </li>
         * @see IpamMeteredAccount
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamMeteredAccount
         */
        Builder meteredAccount(String meteredAccount);

        /**
         * <p>
         * A metered account is an Amazon Web Services account that is charged for active IP addresses managed in IPAM.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable cost distribution</a>
         * in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <p>
         * Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for all
         * active IP addresses managed in IPAM.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for the
         * active IP address.
         * </p>
         * </li>
         * </ul>
         * 
         * @param meteredAccount
         *        A metered account is an Amazon Web Services account that is charged for active IP addresses managed in
         *        IPAM. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html">Enable cost
         *        distribution</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
         *        <p>
         *        Possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ipam-owner</code> (default): The Amazon Web Services account which owns the IPAM is charged for
         *        all active IP addresses managed in IPAM.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-owner</code>: The Amazon Web Services account that owns the IP address is charged for
         *        the active IP address.
         *        </p>
         *        </li>
         * @see IpamMeteredAccount
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamMeteredAccount
         */
        Builder meteredAccount(IpamMeteredAccount meteredAccount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamId;

        private String description;

        private List<AddIpamOperatingRegion> addOperatingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<RemoveIpamOperatingRegion> removeOperatingRegions = DefaultSdkAutoConstructList.getInstance();

        private String tier;

        private Boolean enablePrivateGua;

        private String meteredAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamId(model.ipamId);
            description(model.description);
            addOperatingRegions(model.addOperatingRegions);
            removeOperatingRegions(model.removeOperatingRegions);
            tier(model.tier);
            enablePrivateGua(model.enablePrivateGua);
            meteredAccount(model.meteredAccount);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamId() {
            return ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getAddOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.addOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(addOperatingRegions);
        }

        @Override
        public final Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copy(addOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(AddIpamOperatingRegion... addOperatingRegions) {
            addOperatingRegions(Arrays.asList(addOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder>... addOperatingRegions) {
            addOperatingRegions(Stream.of(addOperatingRegions)
                    .map(c -> AddIpamOperatingRegion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOperatingRegion.Builder> getRemoveOperatingRegions() {
            List<RemoveIpamOperatingRegion.Builder> result = RemoveIpamOperatingRegionSetCopier
                    .copyToBuilder(this.removeOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion.BuilderImpl> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copyFromBuilder(removeOperatingRegions);
        }

        @Override
        public final Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copy(removeOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(RemoveIpamOperatingRegion... removeOperatingRegions) {
            removeOperatingRegions(Arrays.asList(removeOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder>... removeOperatingRegions) {
            removeOperatingRegions(Stream.of(removeOperatingRegions)
                    .map(c -> RemoveIpamOperatingRegion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(IpamTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Boolean getEnablePrivateGua() {
            return enablePrivateGua;
        }

        public final void setEnablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
        }

        @Override
        public final Builder enablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
            return this;
        }

        public final String getMeteredAccount() {
            return meteredAccount;
        }

        public final void setMeteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
        }

        @Override
        public final Builder meteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
            return this;
        }

        @Override
        public final Builder meteredAccount(IpamMeteredAccount meteredAccount) {
            this.meteredAccount(meteredAccount == null ? null : meteredAccount.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamRequest build() {
            return new ModifyIpamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
