/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the RDS options for a Verified Access endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessEndpointRdsOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessEndpointRdsOptions.Builder, VerifiedAccessEndpointRdsOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(VerifiedAccessEndpointRdsOptions::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Port")
            .getter(getter(VerifiedAccessEndpointRdsOptions::port))
            .setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port")
                    .unmarshallLocationName("port").build()).build();

    private static final SdkField<String> RDS_DB_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RdsDbInstanceArn")
            .getter(getter(VerifiedAccessEndpointRdsOptions::rdsDbInstanceArn))
            .setter(setter(Builder::rdsDbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArn")
                    .unmarshallLocationName("rdsDbInstanceArn").build()).build();

    private static final SdkField<String> RDS_DB_CLUSTER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RdsDbClusterArn")
            .getter(getter(VerifiedAccessEndpointRdsOptions::rdsDbClusterArn))
            .setter(setter(Builder::rdsDbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbClusterArn")
                    .unmarshallLocationName("rdsDbClusterArn").build()).build();

    private static final SdkField<String> RDS_DB_PROXY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RdsDbProxyArn")
            .getter(getter(VerifiedAccessEndpointRdsOptions::rdsDbProxyArn))
            .setter(setter(Builder::rdsDbProxyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbProxyArn")
                    .unmarshallLocationName("rdsDbProxyArn").build()).build();

    private static final SdkField<String> RDS_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RdsEndpoint")
            .getter(getter(VerifiedAccessEndpointRdsOptions::rdsEndpoint))
            .setter(setter(Builder::rdsEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsEndpoint")
                    .unmarshallLocationName("rdsEndpoint").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(VerifiedAccessEndpointRdsOptions::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdSet")
                    .unmarshallLocationName("subnetIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PORT_FIELD,
            RDS_DB_INSTANCE_ARN_FIELD, RDS_DB_CLUSTER_ARN_FIELD, RDS_DB_PROXY_ARN_FIELD, RDS_ENDPOINT_FIELD, SUBNET_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final Integer port;

    private final String rdsDbInstanceArn;

    private final String rdsDbClusterArn;

    private final String rdsDbProxyArn;

    private final String rdsEndpoint;

    private final List<String> subnetIds;

    private VerifiedAccessEndpointRdsOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.rdsDbClusterArn = builder.rdsDbClusterArn;
        this.rdsDbProxyArn = builder.rdsDbProxyArn;
        this.rdsEndpoint = builder.rdsEndpoint;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VerifiedAccessEndpointProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol.
     * @see VerifiedAccessEndpointProtocol
     */
    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VerifiedAccessEndpointProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol.
     * @see VerifiedAccessEndpointProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The port.
     * </p>
     * 
     * @return The port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The ARN of the RDS instance.
     * </p>
     * 
     * @return The ARN of the RDS instance.
     */
    public final String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The ARN of the DB cluster.
     * </p>
     * 
     * @return The ARN of the DB cluster.
     */
    public final String rdsDbClusterArn() {
        return rdsDbClusterArn;
    }

    /**
     * <p>
     * The ARN of the RDS proxy.
     * </p>
     * 
     * @return The ARN of the RDS proxy.
     */
    public final String rdsDbProxyArn() {
        return rdsDbProxyArn;
    }

    /**
     * <p>
     * The RDS endpoint.
     * </p>
     * 
     * @return The RDS endpoint.
     */
    public final String rdsEndpoint() {
        return rdsEndpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The IDs of the subnets.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbProxyArn());
        hashCode = 31 * hashCode + Objects.hashCode(rdsEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessEndpointRdsOptions)) {
            return false;
        }
        VerifiedAccessEndpointRdsOptions other = (VerifiedAccessEndpointRdsOptions) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(port(), other.port())
                && Objects.equals(rdsDbInstanceArn(), other.rdsDbInstanceArn())
                && Objects.equals(rdsDbClusterArn(), other.rdsDbClusterArn())
                && Objects.equals(rdsDbProxyArn(), other.rdsDbProxyArn()) && Objects.equals(rdsEndpoint(), other.rdsEndpoint())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessEndpointRdsOptions").add("Protocol", protocolAsString()).add("Port", port())
                .add("RdsDbInstanceArn", rdsDbInstanceArn()).add("RdsDbClusterArn", rdsDbClusterArn())
                .add("RdsDbProxyArn", rdsDbProxyArn()).add("RdsEndpoint", rdsEndpoint())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "RdsDbInstanceArn":
            return Optional.ofNullable(clazz.cast(rdsDbInstanceArn()));
        case "RdsDbClusterArn":
            return Optional.ofNullable(clazz.cast(rdsDbClusterArn()));
        case "RdsDbProxyArn":
            return Optional.ofNullable(clazz.cast(rdsDbProxyArn()));
        case "RdsEndpoint":
            return Optional.ofNullable(clazz.cast(rdsEndpoint()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("RdsDbInstanceArn", RDS_DB_INSTANCE_ARN_FIELD);
        map.put("RdsDbClusterArn", RDS_DB_CLUSTER_ARN_FIELD);
        map.put("RdsDbProxyArn", RDS_DB_PROXY_ARN_FIELD);
        map.put("RdsEndpoint", RDS_ENDPOINT_FIELD);
        map.put("SubnetIdSet", SUBNET_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessEndpointRdsOptions, T> g) {
        return obj -> g.apply((VerifiedAccessEndpointRdsOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessEndpointRdsOptions> {
        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @see VerifiedAccessEndpointProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifiedAccessEndpointProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @see VerifiedAccessEndpointProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifiedAccessEndpointProtocol
         */
        Builder protocol(VerifiedAccessEndpointProtocol protocol);

        /**
         * <p>
         * The port.
         * </p>
         * 
         * @param port
         *        The port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The ARN of the RDS instance.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The ARN of the RDS instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The ARN of the DB cluster.
         * </p>
         * 
         * @param rdsDbClusterArn
         *        The ARN of the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbClusterArn(String rdsDbClusterArn);

        /**
         * <p>
         * The ARN of the RDS proxy.
         * </p>
         * 
         * @param rdsDbProxyArn
         *        The ARN of the RDS proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbProxyArn(String rdsDbProxyArn);

        /**
         * <p>
         * The RDS endpoint.
         * </p>
         * 
         * @param rdsEndpoint
         *        The RDS endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsEndpoint(String rdsEndpoint);

        /**
         * <p>
         * The IDs of the subnets.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The IDs of the subnets.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private Integer port;

        private String rdsDbInstanceArn;

        private String rdsDbClusterArn;

        private String rdsDbProxyArn;

        private String rdsEndpoint;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessEndpointRdsOptions model) {
            protocol(model.protocol);
            port(model.port);
            rdsDbInstanceArn(model.rdsDbInstanceArn);
            rdsDbClusterArn(model.rdsDbClusterArn);
            rdsDbProxyArn(model.rdsDbProxyArn);
            rdsEndpoint(model.rdsEndpoint);
            subnetIds(model.subnetIds);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final String getRdsDbClusterArn() {
            return rdsDbClusterArn;
        }

        public final void setRdsDbClusterArn(String rdsDbClusterArn) {
            this.rdsDbClusterArn = rdsDbClusterArn;
        }

        @Override
        public final Builder rdsDbClusterArn(String rdsDbClusterArn) {
            this.rdsDbClusterArn = rdsDbClusterArn;
            return this;
        }

        public final String getRdsDbProxyArn() {
            return rdsDbProxyArn;
        }

        public final void setRdsDbProxyArn(String rdsDbProxyArn) {
            this.rdsDbProxyArn = rdsDbProxyArn;
        }

        @Override
        public final Builder rdsDbProxyArn(String rdsDbProxyArn) {
            this.rdsDbProxyArn = rdsDbProxyArn;
            return this;
        }

        public final String getRdsEndpoint() {
            return rdsEndpoint;
        }

        public final void setRdsEndpoint(String rdsEndpoint) {
            this.rdsEndpoint = rdsEndpoint;
        }

        @Override
        public final Builder rdsEndpoint(String rdsEndpoint) {
            this.rdsEndpoint = rdsEndpoint;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = VerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = VerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        @Override
        public VerifiedAccessEndpointRdsOptions build() {
            return new VerifiedAccessEndpointRdsOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
