/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDefaultSubnetResponse extends Ec2Response implements
        ToCopyableBuilder<CreateDefaultSubnetResponse.Builder, CreateDefaultSubnetResponse> {
    private static final SdkField<Subnet> SUBNET_FIELD = SdkField
            .<Subnet> builder(MarshallingType.SDK_POJO)
            .memberName("Subnet")
            .getter(getter(CreateDefaultSubnetResponse::subnet))
            .setter(setter(Builder::subnet))
            .constructor(Subnet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet")
                    .unmarshallLocationName("subnet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Subnet subnet;

    private CreateDefaultSubnetResponse(BuilderImpl builder) {
        super(builder);
        this.subnet = builder.subnet;
    }

    /**
     * <p>
     * Information about the subnet.
     * </p>
     * 
     * @return Information about the subnet.
     */
    public final Subnet subnet() {
        return subnet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDefaultSubnetResponse)) {
            return false;
        }
        CreateDefaultSubnetResponse other = (CreateDefaultSubnetResponse) obj;
        return Objects.equals(subnet(), other.subnet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDefaultSubnetResponse").add("Subnet", subnet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Subnet", SUBNET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDefaultSubnetResponse, T> g) {
        return obj -> g.apply((CreateDefaultSubnetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateDefaultSubnetResponse> {
        /**
         * <p>
         * Information about the subnet.
         * </p>
         * 
         * @param subnet
         *        Information about the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(Subnet subnet);

        /**
         * <p>
         * Information about the subnet.
         * </p>
         * This is a convenience method that creates an instance of the {@link Subnet.Builder} avoiding the need to
         * create one manually via {@link Subnet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Subnet.Builder#build()} is called immediately and its result is
         * passed to {@link #subnet(Subnet)}.
         * 
         * @param subnet
         *        a consumer that will call methods on {@link Subnet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnet(Subnet)
         */
        default Builder subnet(Consumer<Subnet.Builder> subnet) {
            return subnet(Subnet.builder().applyMutation(subnet).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Subnet subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDefaultSubnetResponse model) {
            super(model);
            subnet(model.subnet);
        }

        public final Subnet.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        public final void setSubnet(Subnet.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public final Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        @Override
        public CreateDefaultSubnetResponse build() {
            return new CreateDefaultSubnetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
