/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpcEndpointRequest.Builder, CreateVpcEndpointRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateVpcEndpointRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointType")
            .getter(getter(CreateVpcEndpointRequest::vpcEndpointTypeAsString))
            .setter(setter(Builder::vpcEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointType")
                    .unmarshallLocationName("VpcEndpointType").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(CreateVpcEndpointRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceName")
            .getter(getter(CreateVpcEndpointRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName")
                    .unmarshallLocationName("ServiceName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(CreateVpcEndpointRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument")
                    .unmarshallLocationName("PolicyDocument").build()).build();

    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RouteTableIds")
            .getter(getter(CreateVpcEndpointRequest::routeTableIds))
            .setter(setter(Builder::routeTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("RouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateVpcEndpointRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateVpcEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType")
            .getter(getter(CreateVpcEndpointRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType")
                    .unmarshallLocationName("IpAddressType").build()).build();

    private static final SdkField<DnsOptionsSpecification> DNS_OPTIONS_FIELD = SdkField
            .<DnsOptionsSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("DnsOptions")
            .getter(getter(CreateVpcEndpointRequest::dnsOptions))
            .setter(setter(Builder::dnsOptions))
            .constructor(DnsOptionsSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsOptions")
                    .unmarshallLocationName("DnsOptions").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateVpcEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivateDnsEnabled")
            .getter(getter(CreateVpcEndpointRequest::privateDnsEnabled))
            .setter(setter(Builder::privateDnsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled")
                    .unmarshallLocationName("PrivateDnsEnabled").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVpcEndpointRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<SubnetConfiguration>> SUBNET_CONFIGURATIONS_FIELD = SdkField
            .<List<SubnetConfiguration>> builder(MarshallingType.LIST)
            .memberName("SubnetConfigurations")
            .getter(getter(CreateVpcEndpointRequest::subnetConfigurations))
            .setter(setter(Builder::subnetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetConfiguration")
                    .unmarshallLocationName("SubnetConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SubnetConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceNetworkArn")
            .getter(getter(CreateVpcEndpointRequest::serviceNetworkArn))
            .setter(setter(Builder::serviceNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNetworkArn")
                    .unmarshallLocationName("ServiceNetworkArn").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceConfigurationArn")
            .getter(getter(CreateVpcEndpointRequest::resourceConfigurationArn))
            .setter(setter(Builder::resourceConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationArn")
                    .unmarshallLocationName("ResourceConfigurationArn").build()).build();

    private static final SdkField<String> SERVICE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceRegion")
            .getter(getter(CreateVpcEndpointRequest::serviceRegion))
            .setter(setter(Builder::serviceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRegion")
                    .unmarshallLocationName("ServiceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            VPC_ENDPOINT_TYPE_FIELD, VPC_ID_FIELD, SERVICE_NAME_FIELD, POLICY_DOCUMENT_FIELD, ROUTE_TABLE_IDS_FIELD,
            SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, IP_ADDRESS_TYPE_FIELD, DNS_OPTIONS_FIELD, CLIENT_TOKEN_FIELD,
            PRIVATE_DNS_ENABLED_FIELD, TAG_SPECIFICATIONS_FIELD, SUBNET_CONFIGURATIONS_FIELD, SERVICE_NETWORK_ARN_FIELD,
            RESOURCE_CONFIGURATION_ARN_FIELD, SERVICE_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String vpcEndpointType;

    private final String vpcId;

    private final String serviceName;

    private final String policyDocument;

    private final List<String> routeTableIds;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String ipAddressType;

    private final DnsOptionsSpecification dnsOptions;

    private final String clientToken;

    private final Boolean privateDnsEnabled;

    private final List<TagSpecification> tagSpecifications;

    private final List<SubnetConfiguration> subnetConfigurations;

    private final String serviceNetworkArn;

    private final String resourceConfigurationArn;

    private final String serviceRegion;

    private CreateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.ipAddressType = builder.ipAddressType;
        this.dnsOptions = builder.dnsOptions;
        this.clientToken = builder.clientToken;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.tagSpecifications = builder.tagSpecifications;
        this.subnetConfigurations = builder.subnetConfigurations;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.serviceRegion = builder.serviceRegion;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The type of endpoint.
     * </p>
     * <p>
     * Default: Gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcEndpointType}
     * will return {@link VpcEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcEndpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint.</p>
     *         <p>
     *         Default: Gateway
     * @see VpcEndpointType
     */
    public final VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(vpcEndpointType);
    }

    /**
     * <p>
     * The type of endpoint.
     * </p>
     * <p>
     * Default: Gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcEndpointType}
     * will return {@link VpcEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcEndpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint.</p>
     *         <p>
     *         Default: Gateway
     * @see VpcEndpointType
     */
    public final String vpcEndpointTypeAsString() {
        return vpcEndpointType;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the endpoint service.
     * </p>
     * 
     * @return The name of the endpoint service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The
     * policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows
     * full access to the service.
     * </p>
     * 
     * @return (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service.
     *         The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy
     *         that allows full access to the service.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteTableIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteTableIds() {
        return routeTableIds != null && !(routeTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Gateway endpoint) The route table IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteTableIds} method.
     * </p>
     * 
     * @return (Gateway endpoint) The route table IDs.
     */
    public final List<String> routeTableIds() {
        return routeTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to create endpoint network
     * interfaces. For a Gateway Load Balancer endpoint, you can specify only one subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to create endpoint
     *         network interfaces. For a Gateway Load Balancer endpoint, you can specify only one subnet.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces. If this
     * parameter is not specified, we use the default security group for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces. If
     *         this parameter is not specified, we use the default security group for the VPC.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The IP address type for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the endpoint.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the endpoint.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The DNS options for the endpoint.
     * </p>
     * 
     * @return The DNS options for the endpoint.
     */
    public final DnsOptionsSpecification dnsOptions() {
        return dnsOptions;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How
     *         to ensure idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private
     * hosted zone contains a record set for the default public DNS name for the service for the Region (for example,
     * <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the endpoint network
     * interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead
     * of the public DNS names that are automatically generated by the VPC endpoint service.
     * </p>
     * <p>
     * To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
     * <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the VPC
     * attributes.
     * </p>
     * 
     * @return (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The
     *         private hosted zone contains a record set for the default public DNS name for the service for the Region
     *         (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses
     *         of the endpoint network interfaces in the VPC. This enables you to make requests to the default public
     *         DNS name for the service instead of the public DNS names that are automatically generated by the VPC
     *         endpoint service.</p>
     *         <p>
     *         To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
     *         <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set
     *         the VPC attributes.
     */
    public final Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to associate with the endpoint.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetConfigurations() {
        return subnetConfigurations != null && !(subnetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet configurations for the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetConfigurations} method.
     * </p>
     * 
     * @return The subnet configurations for the endpoint.
     */
    public final List<SubnetConfiguration> subnetConfigurations() {
        return subnetConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a service network that will be associated with the VPC endpoint of type
     * service-network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a service network that will be associated with the VPC endpoint of type
     *         service-network.
     */
    public final String serviceNetworkArn() {
        return serviceNetworkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource configuration that will be associated with the VPC endpoint of type
     * resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a resource configuration that will be associated with the VPC endpoint
     *         of type resource.
     */
    public final String resourceConfigurationArn() {
        return resourceConfigurationArn;
    }

    /**
     * <p>
     * The Region where the service is hosted. The default is the current Region.
     * </p>
     * 
     * @return The Region where the service is hosted. The default is the current Region.
     */
    public final String serviceRegion() {
        return serviceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteTableIds() ? routeTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetConfigurations() ? subnetConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointRequest)) {
            return false;
        }
        CreateVpcEndpointRequest other = (CreateVpcEndpointRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(vpcEndpointTypeAsString(), other.vpcEndpointTypeAsString())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(policyDocument(), other.policyDocument()) && hasRouteTableIds() == other.hasRouteTableIds()
                && Objects.equals(routeTableIds(), other.routeTableIds()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(dnsOptions(), other.dnsOptions()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && hasSubnetConfigurations() == other.hasSubnetConfigurations()
                && Objects.equals(subnetConfigurations(), other.subnetConfigurations())
                && Objects.equals(serviceNetworkArn(), other.serviceNetworkArn())
                && Objects.equals(resourceConfigurationArn(), other.resourceConfigurationArn())
                && Objects.equals(serviceRegion(), other.serviceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcEndpointRequest").add("DryRun", dryRun())
                .add("VpcEndpointType", vpcEndpointTypeAsString()).add("VpcId", vpcId()).add("ServiceName", serviceName())
                .add("PolicyDocument", policyDocument()).add("RouteTableIds", hasRouteTableIds() ? routeTableIds() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("IpAddressType", ipAddressTypeAsString()).add("DnsOptions", dnsOptions()).add("ClientToken", clientToken())
                .add("PrivateDnsEnabled", privateDnsEnabled())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("SubnetConfigurations", hasSubnetConfigurations() ? subnetConfigurations() : null)
                .add("ServiceNetworkArn", serviceNetworkArn()).add("ResourceConfigurationArn", resourceConfigurationArn())
                .add("ServiceRegion", serviceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "VpcEndpointType":
            return Optional.ofNullable(clazz.cast(vpcEndpointTypeAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "RouteTableIds":
            return Optional.ofNullable(clazz.cast(routeTableIds()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "DnsOptions":
            return Optional.ofNullable(clazz.cast(dnsOptions()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "PrivateDnsEnabled":
            return Optional.ofNullable(clazz.cast(privateDnsEnabled()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "SubnetConfigurations":
            return Optional.ofNullable(clazz.cast(subnetConfigurations()));
        case "ServiceNetworkArn":
            return Optional.ofNullable(clazz.cast(serviceNetworkArn()));
        case "ResourceConfigurationArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArn()));
        case "ServiceRegion":
            return Optional.ofNullable(clazz.cast(serviceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("VpcEndpointType", VPC_ENDPOINT_TYPE_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_IDS_FIELD);
        map.put("SubnetId", SUBNET_IDS_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("DnsOptions", DNS_OPTIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("PrivateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("SubnetConfiguration", SUBNET_CONFIGURATIONS_FIELD);
        map.put("ServiceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("ResourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("ServiceRegion", SERVICE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcEndpointRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The type of endpoint.
         * </p>
         * <p>
         * Default: Gateway
         * </p>
         * 
         * @param vpcEndpointType
         *        The type of endpoint.</p>
         *        <p>
         *        Default: Gateway
         * @see VpcEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointType
         */
        Builder vpcEndpointType(String vpcEndpointType);

        /**
         * <p>
         * The type of endpoint.
         * </p>
         * <p>
         * Default: Gateway
         * </p>
         * 
         * @param vpcEndpointType
         *        The type of endpoint.</p>
         *        <p>
         *        Default: Gateway
         * @see VpcEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointType
         */
        Builder vpcEndpointType(VpcEndpointType vpcEndpointType);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the endpoint service.
         * </p>
         * 
         * @param serviceName
         *        The name of the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The
         * policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that
         * allows full access to the service.
         * </p>
         * 
         * @param policyDocument
         *        (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
         *        service. The policy must be in valid JSON format. If this parameter is not specified, we attach a
         *        default policy that allows full access to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * (Gateway endpoint) The route table IDs.
         * </p>
         * 
         * @param routeTableIds
         *        (Gateway endpoint) The route table IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * (Gateway endpoint) The route table IDs.
         * </p>
         * 
         * @param routeTableIds
         *        (Gateway endpoint) The route table IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);

        /**
         * <p>
         * (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to create endpoint network
         * interfaces. For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * </p>
         * 
         * @param subnetIds
         *        (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to create endpoint
         *        network interfaces. For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to create endpoint network
         * interfaces. For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * </p>
         * 
         * @param subnetIds
         *        (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to create endpoint
         *        network interfaces. For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces. If
         * this parameter is not specified, we use the default security group for the VPC.
         * </p>
         * 
         * @param securityGroupIds
         *        (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
         *        If this parameter is not specified, we use the default security group for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces. If
         * this parameter is not specified, we use the default security group for the VPC.
         * </p>
         * 
         * @param securityGroupIds
         *        (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
         *        If this parameter is not specified, we use the default security group for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The IP address type for the endpoint.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the endpoint.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the endpoint.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the endpoint.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The DNS options for the endpoint.
         * </p>
         * 
         * @param dnsOptions
         *        The DNS options for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsOptions(DnsOptionsSpecification dnsOptions);

        /**
         * <p>
         * The DNS options for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsOptionsSpecification.Builder} avoiding
         * the need to create one manually via {@link DnsOptionsSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsOptionsSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #dnsOptions(DnsOptionsSpecification)}.
         * 
         * @param dnsOptions
         *        a consumer that will call methods on {@link DnsOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsOptions(DnsOptionsSpecification)
         */
        default Builder dnsOptions(Consumer<DnsOptionsSpecification.Builder> dnsOptions) {
            return dnsOptions(DnsOptionsSpecification.builder().applyMutation(dnsOptions).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to
         * ensure idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private
         * hosted zone contains a record set for the default public DNS name for the service for the Region (for
         * example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the
         * endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for
         * the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         * </p>
         * <p>
         * To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
         * <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the
         * VPC attributes.
         * </p>
         * 
         * @param privateDnsEnabled
         *        (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The
         *        private hosted zone contains a record set for the default public DNS name for the service for the
         *        Region (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP
         *        addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the
         *        default public DNS name for the service instead of the public DNS names that are automatically
         *        generated by the VPC endpoint service.</p>
         *        <p>
         *        To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
         *        <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to
         *        set the VPC attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        /**
         * <p>
         * The tags to associate with the endpoint.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to associate with the endpoint.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to associate with the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The subnet configurations for the endpoint.
         * </p>
         * 
         * @param subnetConfigurations
         *        The subnet configurations for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetConfigurations(Collection<SubnetConfiguration> subnetConfigurations);

        /**
         * <p>
         * The subnet configurations for the endpoint.
         * </p>
         * 
         * @param subnetConfigurations
         *        The subnet configurations for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetConfigurations(SubnetConfiguration... subnetConfigurations);

        /**
         * <p>
         * The subnet configurations for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #subnetConfigurations(List<SubnetConfiguration>)}.
         * 
         * @param subnetConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetConfigurations(java.util.Collection<SubnetConfiguration>)
         */
        Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder>... subnetConfigurations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a service network that will be associated with the VPC endpoint of type
         * service-network.
         * </p>
         * 
         * @param serviceNetworkArn
         *        The Amazon Resource Name (ARN) of a service network that will be associated with the VPC endpoint of
         *        type service-network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkArn(String serviceNetworkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a resource configuration that will be associated with the VPC endpoint of
         * type resource.
         * </p>
         * 
         * @param resourceConfigurationArn
         *        The Amazon Resource Name (ARN) of a resource configuration that will be associated with the VPC
         *        endpoint of type resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArn(String resourceConfigurationArn);

        /**
         * <p>
         * The Region where the service is hosted. The default is the current Region.
         * </p>
         * 
         * @param serviceRegion
         *        The Region where the service is hosted. The default is the current Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegion(String serviceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String vpcEndpointType;

        private String vpcId;

        private String serviceName;

        private String policyDocument;

        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private DnsOptionsSpecification dnsOptions;

        private String clientToken;

        private Boolean privateDnsEnabled;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<SubnetConfiguration> subnetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String serviceNetworkArn;

        private String resourceConfigurationArn;

        private String serviceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointRequest model) {
            super(model);
            dryRun(model.dryRun);
            vpcEndpointType(model.vpcEndpointType);
            vpcId(model.vpcId);
            serviceName(model.serviceName);
            policyDocument(model.policyDocument);
            routeTableIds(model.routeTableIds);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            ipAddressType(model.ipAddressType);
            dnsOptions(model.dnsOptions);
            clientToken(model.clientToken);
            privateDnsEnabled(model.privateDnsEnabled);
            tagSpecifications(model.tagSpecifications);
            subnetConfigurations(model.subnetConfigurations);
            serviceNetworkArn(model.serviceNetworkArn);
            resourceConfigurationArn(model.resourceConfigurationArn);
            serviceRegion(model.serviceRegion);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getVpcEndpointType() {
            return vpcEndpointType;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType == null ? null : vpcEndpointType.toString());
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Collection<String> getRouteTableIds() {
            if (routeTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return routeTableIds;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = VpcEndpointRouteTableIdListCopier.copy(routeTableIds);
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = VpcEndpointRouteTableIdListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = VpcEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = VpcEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final DnsOptionsSpecification.Builder getDnsOptions() {
            return dnsOptions != null ? dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptionsSpecification.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptionsSpecification dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SubnetConfiguration.Builder> getSubnetConfigurations() {
            List<SubnetConfiguration.Builder> result = SubnetConfigurationsListCopier.copyToBuilder(this.subnetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetConfigurations(Collection<SubnetConfiguration.BuilderImpl> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copyFromBuilder(subnetConfigurations);
        }

        @Override
        public final Builder subnetConfigurations(Collection<SubnetConfiguration> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copy(subnetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(SubnetConfiguration... subnetConfigurations) {
            subnetConfigurations(Arrays.asList(subnetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder>... subnetConfigurations) {
            subnetConfigurations(Stream.of(subnetConfigurations).map(c -> SubnetConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceNetworkArn() {
            return serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getResourceConfigurationArn() {
            return resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getServiceRegion() {
            return serviceRegion;
        }

        public final void setServiceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
        }

        @Override
        public final Builder serviceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointRequest build() {
            return new CreateVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
