/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityBlockExtensionOfferingsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeCapacityBlockExtensionOfferingsRequest.Builder, DescribeCapacityBlockExtensionOfferingsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Integer> CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CapacityBlockExtensionDurationHours")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsRequest::capacityBlockExtensionDurationHours))
            .setter(setter(Builder::capacityBlockExtensionDurationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CapacityBlockExtensionDurationHours")
                    .unmarshallLocationName("CapacityBlockExtensionDurationHours").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsRequest::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("CapacityReservationId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD, CAPACITY_RESERVATION_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final Integer capacityBlockExtensionDurationHours;

    private final String capacityReservationId;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeCapacityBlockExtensionOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.capacityBlockExtensionDurationHours = builder.capacityBlockExtensionDurationHours;
        this.capacityReservationId = builder.capacityReservationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The duration of the Capacity Block extension offering in hours.
     * </p>
     * 
     * @return The duration of the Capacity Block extension offering in hours.
     */
    public final Integer capacityBlockExtensionDurationHours() {
        return capacityBlockExtensionDurationHours;
    }

    /**
     * <p>
     * The ID of the Capacity reservation to be extended.
     * </p>
     * 
     * @return The ID of the Capacity reservation to be extended.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockExtensionOfferingsRequest)) {
            return false;
        }
        DescribeCapacityBlockExtensionOfferingsRequest other = (DescribeCapacityBlockExtensionOfferingsRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(capacityBlockExtensionDurationHours(), other.capacityBlockExtensionDurationHours())
                && Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityBlockExtensionOfferingsRequest").add("DryRun", dryRun())
                .add("CapacityBlockExtensionDurationHours", capacityBlockExtensionDurationHours())
                .add("CapacityReservationId", capacityReservationId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "CapacityBlockExtensionDurationHours":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionDurationHours()));
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("CapacityBlockExtensionDurationHours", CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD);
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockExtensionOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeCapacityBlockExtensionOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCapacityBlockExtensionOfferingsRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The duration of the Capacity Block extension offering in hours.
         * </p>
         * 
         * @param capacityBlockExtensionDurationHours
         *        The duration of the Capacity Block extension offering in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours);

        /**
         * <p>
         * The ID of the Capacity reservation to be extended.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity reservation to be extended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private Integer capacityBlockExtensionDurationHours;

        private String capacityReservationId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockExtensionOfferingsRequest model) {
            super(model);
            dryRun(model.dryRun);
            capacityBlockExtensionDurationHours(model.capacityBlockExtensionDurationHours);
            capacityReservationId(model.capacityReservationId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Integer getCapacityBlockExtensionDurationHours() {
            return capacityBlockExtensionDurationHours;
        }

        public final void setCapacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
        }

        @Override
        public final Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
            return this;
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityBlockExtensionOfferingsRequest build() {
            return new DescribeCapacityBlockExtensionOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
