/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOutpostLagsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeOutpostLagsResponse.Builder, DescribeOutpostLagsResponse> {
    private static final SdkField<List<OutpostLag>> OUTPOST_LAGS_FIELD = SdkField
            .<List<OutpostLag>> builder(MarshallingType.LIST)
            .memberName("OutpostLags")
            .getter(getter(DescribeOutpostLagsResponse::outpostLags))
            .setter(setter(Builder::outpostLags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagSet")
                    .unmarshallLocationName("outpostLagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<OutpostLag> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutpostLag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeOutpostLagsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_LAGS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<OutpostLag> outpostLags;

    private final String nextToken;

    private DescribeOutpostLagsResponse(BuilderImpl builder) {
        super(builder);
        this.outpostLags = builder.outpostLags;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutpostLags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutpostLags() {
        return outpostLags != null && !(outpostLags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Outpost LAGs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutpostLags} method.
     * </p>
     * 
     * @return The Outpost LAGs.
     */
    public final List<OutpostLag> outpostLags() {
        return outpostLags;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOutpostLags() ? outpostLags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOutpostLagsResponse)) {
            return false;
        }
        DescribeOutpostLagsResponse other = (DescribeOutpostLagsResponse) obj;
        return hasOutpostLags() == other.hasOutpostLags() && Objects.equals(outpostLags(), other.outpostLags())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOutpostLagsResponse").add("OutpostLags", hasOutpostLags() ? outpostLags() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostLags":
            return Optional.ofNullable(clazz.cast(outpostLags()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostLagSet", OUTPOST_LAGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOutpostLagsResponse, T> g) {
        return obj -> g.apply((DescribeOutpostLagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOutpostLagsResponse> {
        /**
         * <p>
         * The Outpost LAGs.
         * </p>
         * 
         * @param outpostLags
         *        The Outpost LAGs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostLags(Collection<OutpostLag> outpostLags);

        /**
         * <p>
         * The Outpost LAGs.
         * </p>
         * 
         * @param outpostLags
         *        The Outpost LAGs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostLags(OutpostLag... outpostLags);

        /**
         * <p>
         * The Outpost LAGs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.OutpostLag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.OutpostLag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.OutpostLag.Builder#build()} is called immediately and its
         * result is passed to {@link #outpostLags(List<OutpostLag>)}.
         * 
         * @param outpostLags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.OutpostLag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outpostLags(java.util.Collection<OutpostLag>)
         */
        Builder outpostLags(Consumer<OutpostLag.Builder>... outpostLags);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<OutpostLag> outpostLags = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOutpostLagsResponse model) {
            super(model);
            outpostLags(model.outpostLags);
            nextToken(model.nextToken);
        }

        public final List<OutpostLag.Builder> getOutpostLags() {
            List<OutpostLag.Builder> result = OutpostLagSetCopier.copyToBuilder(this.outpostLags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutpostLags(Collection<OutpostLag.BuilderImpl> outpostLags) {
            this.outpostLags = OutpostLagSetCopier.copyFromBuilder(outpostLags);
        }

        @Override
        public final Builder outpostLags(Collection<OutpostLag> outpostLags) {
            this.outpostLags = OutpostLagSetCopier.copy(outpostLags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostLags(OutpostLag... outpostLags) {
            outpostLags(Arrays.asList(outpostLags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostLags(Consumer<OutpostLag.Builder>... outpostLags) {
            outpostLags(Stream.of(outpostLags).map(c -> OutpostLag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOutpostLagsResponse build() {
            return new DescribeOutpostLagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
