/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a local gateway virtual interface group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayVirtualInterfaceGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalGatewayVirtualInterfaceGroup.Builder, LocalGatewayVirtualInterfaceGroup> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupId")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<List<String>> LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LocalGatewayVirtualInterfaceIds")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceIds))
            .setter(setter(Builder::localGatewayVirtualInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceIdSet")
                    .unmarshallLocationName("localGatewayVirtualInterfaceIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<Integer> LOCAL_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LocalBgpAsn")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localBgpAsn))
            .setter(setter(Builder::localBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsn")
                    .unmarshallLocationName("localBgpAsn").build()).build();

    private static final SdkField<Long> LOCAL_BGP_ASN_EXTENDED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("LocalBgpAsnExtended")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localBgpAsnExtended))
            .setter(setter(Builder::localBgpAsnExtended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsnExtended")
                    .unmarshallLocationName("localBgpAsnExtended").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupArn")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceGroupArn))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupArn")
                    .unmarshallLocationName("localGatewayVirtualInterfaceGroupArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationState")
            .getter(getter(LocalGatewayVirtualInterfaceGroup::configurationStateAsString))
            .setter(setter(Builder::configurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState")
                    .unmarshallLocationName("configurationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD, LOCAL_GATEWAY_ID_FIELD,
            OWNER_ID_FIELD, LOCAL_BGP_ASN_FIELD, LOCAL_BGP_ASN_EXTENDED_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ARN_FIELD,
            TAGS_FIELD, CONFIGURATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String localGatewayVirtualInterfaceGroupId;

    private final List<String> localGatewayVirtualInterfaceIds;

    private final String localGatewayId;

    private final String ownerId;

    private final Integer localBgpAsn;

    private final Long localBgpAsnExtended;

    private final String localGatewayVirtualInterfaceGroupArn;

    private final List<Tag> tags;

    private final String configurationState;

    private LocalGatewayVirtualInterfaceGroup(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayVirtualInterfaceIds = builder.localGatewayVirtualInterfaceIds;
        this.localGatewayId = builder.localGatewayId;
        this.ownerId = builder.ownerId;
        this.localBgpAsn = builder.localBgpAsn;
        this.localBgpAsnExtended = builder.localBgpAsnExtended;
        this.localGatewayVirtualInterfaceGroupArn = builder.localGatewayVirtualInterfaceGroupArn;
        this.tags = builder.tags;
        this.configurationState = builder.configurationState;
    }

    /**
     * <p>
     * The ID of the virtual interface group.
     * </p>
     * 
     * @return The ID of the virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalGatewayVirtualInterfaceIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasLocalGatewayVirtualInterfaceIds() {
        return localGatewayVirtualInterfaceIds != null && !(localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the virtual interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalGatewayVirtualInterfaceIds}
     * method.
     * </p>
     * 
     * @return The IDs of the virtual interfaces.
     */
    public final List<String> localGatewayVirtualInterfaceIds() {
        return localGatewayVirtualInterfaceIds;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the local gateway virtual interface group.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the local gateway virtual interface group.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The Autonomous System Number(ASN) for the local Border Gateway Protocol (BGP).
     * </p>
     * 
     * @return The Autonomous System Number(ASN) for the local Border Gateway Protocol (BGP).
     */
    public final Integer localBgpAsn() {
        return localBgpAsn;
    }

    /**
     * <p>
     * The extended 32-bit ASN for the local BGP configuration.
     * </p>
     * 
     * @return The extended 32-bit ASN for the local BGP configuration.
     */
    public final Long localBgpAsnExtended() {
        return localBgpAsnExtended;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the local gateway virtual interface group.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the local gateway virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupArn() {
        return localGatewayVirtualInterfaceGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the virtual interface group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the virtual interface group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The current state of the local gateway virtual interface group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return
     * {@link LocalGatewayVirtualInterfaceGroupConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The current state of the local gateway virtual interface group.
     * @see LocalGatewayVirtualInterfaceGroupConfigurationState
     */
    public final LocalGatewayVirtualInterfaceGroupConfigurationState configurationState() {
        return LocalGatewayVirtualInterfaceGroupConfigurationState.fromValue(configurationState);
    }

    /**
     * <p>
     * The current state of the local gateway virtual interface group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return
     * {@link LocalGatewayVirtualInterfaceGroupConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The current state of the local gateway virtual interface group.
     * @see LocalGatewayVirtualInterfaceGroupConfigurationState
     */
    public final String configurationStateAsString() {
        return configurationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLocalGatewayVirtualInterfaceIds() ? localGatewayVirtualInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(localBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(localBgpAsnExtended());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterfaceGroup)) {
            return false;
        }
        LocalGatewayVirtualInterfaceGroup other = (LocalGatewayVirtualInterfaceGroup) obj;
        return Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && hasLocalGatewayVirtualInterfaceIds() == other.hasLocalGatewayVirtualInterfaceIds()
                && Objects.equals(localGatewayVirtualInterfaceIds(), other.localGatewayVirtualInterfaceIds())
                && Objects.equals(localGatewayId(), other.localGatewayId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(localBgpAsn(), other.localBgpAsn())
                && Objects.equals(localBgpAsnExtended(), other.localBgpAsnExtended())
                && Objects.equals(localGatewayVirtualInterfaceGroupArn(), other.localGatewayVirtualInterfaceGroupArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(configurationStateAsString(), other.configurationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("LocalGatewayVirtualInterfaceGroup")
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("LocalGatewayVirtualInterfaceIds",
                        hasLocalGatewayVirtualInterfaceIds() ? localGatewayVirtualInterfaceIds() : null)
                .add("LocalGatewayId", localGatewayId()).add("OwnerId", ownerId()).add("LocalBgpAsn", localBgpAsn())
                .add("LocalBgpAsnExtended", localBgpAsnExtended())
                .add("LocalGatewayVirtualInterfaceGroupArn", localGatewayVirtualInterfaceGroupArn())
                .add("Tags", hasTags() ? tags() : null).add("ConfigurationState", configurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "LocalGatewayVirtualInterfaceIds":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceIds()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "LocalBgpAsn":
            return Optional.ofNullable(clazz.cast(localBgpAsn()));
        case "LocalBgpAsnExtended":
            return Optional.ofNullable(clazz.cast(localBgpAsnExtended()));
        case "LocalGatewayVirtualInterfaceGroupArn":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ConfigurationState":
            return Optional.ofNullable(clazz.cast(configurationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceIdSet", LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD);
        map.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("LocalBgpAsn", LOCAL_BGP_ASN_FIELD);
        map.put("LocalBgpAsnExtended", LOCAL_BGP_ASN_EXTENDED_FIELD);
        map.put("LocalGatewayVirtualInterfaceGroupArn", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ARN_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterfaceGroup, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterfaceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayVirtualInterfaceGroup> {
        /**
         * <p>
         * The ID of the virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * The IDs of the virtual interfaces.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceIds
         *        The IDs of the virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds);

        /**
         * <p>
         * The IDs of the virtual interfaces.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceIds
         *        The IDs of the virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceIds(String... localGatewayVirtualInterfaceIds);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface group.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the local gateway virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The Autonomous System Number(ASN) for the local Border Gateway Protocol (BGP).
         * </p>
         * 
         * @param localBgpAsn
         *        The Autonomous System Number(ASN) for the local Border Gateway Protocol (BGP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localBgpAsn(Integer localBgpAsn);

        /**
         * <p>
         * The extended 32-bit ASN for the local BGP configuration.
         * </p>
         * 
         * @param localBgpAsnExtended
         *        The extended 32-bit ASN for the local BGP configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localBgpAsnExtended(Long localBgpAsnExtended);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the local gateway virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupArn
         *        The Amazon Resource Number (ARN) of the local gateway virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupArn(String localGatewayVirtualInterfaceGroupArn);

        /**
         * <p>
         * The tags assigned to the virtual interface group.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the virtual interface group.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the virtual interface group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The current state of the local gateway virtual interface group.
         * </p>
         * 
         * @param configurationState
         *        The current state of the local gateway virtual interface group.
         * @see LocalGatewayVirtualInterfaceGroupConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocalGatewayVirtualInterfaceGroupConfigurationState
         */
        Builder configurationState(String configurationState);

        /**
         * <p>
         * The current state of the local gateway virtual interface group.
         * </p>
         * 
         * @param configurationState
         *        The current state of the local gateway virtual interface group.
         * @see LocalGatewayVirtualInterfaceGroupConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocalGatewayVirtualInterfaceGroupConfigurationState
         */
        Builder configurationState(LocalGatewayVirtualInterfaceGroupConfigurationState configurationState);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayVirtualInterfaceGroupId;

        private List<String> localGatewayVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private String localGatewayId;

        private String ownerId;

        private Integer localBgpAsn;

        private Long localBgpAsnExtended;

        private String localGatewayVirtualInterfaceGroupArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String configurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterfaceGroup model) {
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            localGatewayVirtualInterfaceIds(model.localGatewayVirtualInterfaceIds);
            localGatewayId(model.localGatewayId);
            ownerId(model.ownerId);
            localBgpAsn(model.localBgpAsn);
            localBgpAsnExtended(model.localBgpAsnExtended);
            localGatewayVirtualInterfaceGroupArn(model.localGatewayVirtualInterfaceGroupArn);
            tags(model.tags);
            configurationState(model.configurationState);
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final Collection<String> getLocalGatewayVirtualInterfaceIds() {
            if (localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return localGatewayVirtualInterfaceIds;
        }

        public final void setLocalGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
        }

        @Override
        public final Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceIds(String... localGatewayVirtualInterfaceIds) {
            localGatewayVirtualInterfaceIds(Arrays.asList(localGatewayVirtualInterfaceIds));
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Integer getLocalBgpAsn() {
            return localBgpAsn;
        }

        public final void setLocalBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
        }

        @Override
        public final Builder localBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
            return this;
        }

        public final Long getLocalBgpAsnExtended() {
            return localBgpAsnExtended;
        }

        public final void setLocalBgpAsnExtended(Long localBgpAsnExtended) {
            this.localBgpAsnExtended = localBgpAsnExtended;
        }

        @Override
        public final Builder localBgpAsnExtended(Long localBgpAsnExtended) {
            this.localBgpAsnExtended = localBgpAsnExtended;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupArn() {
            return localGatewayVirtualInterfaceGroupArn;
        }

        public final void setLocalGatewayVirtualInterfaceGroupArn(String localGatewayVirtualInterfaceGroupArn) {
            this.localGatewayVirtualInterfaceGroupArn = localGatewayVirtualInterfaceGroupArn;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupArn(String localGatewayVirtualInterfaceGroupArn) {
            this.localGatewayVirtualInterfaceGroupArn = localGatewayVirtualInterfaceGroupArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationState() {
            return configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(LocalGatewayVirtualInterfaceGroupConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        @Override
        public LocalGatewayVirtualInterfaceGroup build() {
            return new LocalGatewayVirtualInterfaceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
