/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AlternatePathHintListCopier {
    static List<AlternatePathHint> copy(Collection<? extends AlternatePathHint> alternatePathHintListParam) {
        List<AlternatePathHint> list;
        if (alternatePathHintListParam == null || alternatePathHintListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AlternatePathHint> modifiableList = new ArrayList<>(alternatePathHintListParam.size());
            alternatePathHintListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AlternatePathHint> copyFromBuilder(Collection<? extends AlternatePathHint.Builder> alternatePathHintListParam) {
        List<AlternatePathHint> list;
        if (alternatePathHintListParam == null || alternatePathHintListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AlternatePathHint> modifiableList = new ArrayList<>(alternatePathHintListParam.size());
            alternatePathHintListParam.forEach(entry -> {
                AlternatePathHint member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AlternatePathHint.Builder> copyToBuilder(Collection<? extends AlternatePathHint> alternatePathHintListParam) {
        List<AlternatePathHint.Builder> list;
        if (alternatePathHintListParam == null || alternatePathHintListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AlternatePathHint.Builder> modifiableList = new ArrayList<>(alternatePathHintListParam.size());
            alternatePathHintListParam.forEach(entry -> {
                AlternatePathHint.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
