/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImageAttributeResponse.Builder, DescribeImageAttributeResponse> {
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Description")
            .getter(getter(DescribeImageAttributeResponse::description))
            .setter(setter(Builder::description))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<AttributeValue> KERNEL_ID_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("KernelId")
            .getter(getter(DescribeImageAttributeResponse::kernelId))
            .setter(setter(Builder::kernelId))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel")
                    .unmarshallLocationName("kernel").build()).build();

    private static final SdkField<AttributeValue> RAMDISK_ID_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("RamdiskId")
            .getter(getter(DescribeImageAttributeResponse::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk")
                    .unmarshallLocationName("ramdisk").build()).build();

    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("SriovNetSupport")
            .getter(getter(DescribeImageAttributeResponse::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<AttributeValue> BOOT_MODE_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("BootMode")
            .getter(getter(DescribeImageAttributeResponse::bootMode))
            .setter(setter(Builder::bootMode))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode")
                    .unmarshallLocationName("bootMode").build()).build();

    private static final SdkField<AttributeValue> TPM_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("TpmSupport")
            .getter(getter(DescribeImageAttributeResponse::tpmSupport))
            .setter(setter(Builder::tpmSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport")
                    .unmarshallLocationName("tpmSupport").build()).build();

    private static final SdkField<AttributeValue> UEFI_DATA_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("UefiData")
            .getter(getter(DescribeImageAttributeResponse::uefiData))
            .setter(setter(Builder::uefiData))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UefiData")
                    .unmarshallLocationName("uefiData").build()).build();

    private static final SdkField<AttributeValue> LAST_LAUNCHED_TIME_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("LastLaunchedTime")
            .getter(getter(DescribeImageAttributeResponse::lastLaunchedTime))
            .setter(setter(Builder::lastLaunchedTime))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastLaunchedTime")
                    .unmarshallLocationName("lastLaunchedTime").build()).build();

    private static final SdkField<AttributeValue> IMDS_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("ImdsSupport")
            .getter(getter(DescribeImageAttributeResponse::imdsSupport))
            .setter(setter(Builder::imdsSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport")
                    .unmarshallLocationName("imdsSupport").build()).build();

    private static final SdkField<AttributeValue> DEREGISTRATION_PROTECTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("DeregistrationProtection")
            .getter(getter(DescribeImageAttributeResponse::deregistrationProtection))
            .setter(setter(Builder::deregistrationProtection))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregistrationProtection")
                    .unmarshallLocationName("deregistrationProtection").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(DescribeImageAttributeResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<List<LaunchPermission>> LAUNCH_PERMISSIONS_FIELD = SdkField
            .<List<LaunchPermission>> builder(MarshallingType.LIST)
            .memberName("LaunchPermissions")
            .getter(getter(DescribeImageAttributeResponse::launchPermissions))
            .setter(setter(Builder::launchPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission")
                    .unmarshallLocationName("launchPermission").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(DescribeImageAttributeResponse::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(DescribeImageAttributeResponse::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            KERNEL_ID_FIELD, RAMDISK_ID_FIELD, SRIOV_NET_SUPPORT_FIELD, BOOT_MODE_FIELD, TPM_SUPPORT_FIELD, UEFI_DATA_FIELD,
            LAST_LAUNCHED_TIME_FIELD, IMDS_SUPPORT_FIELD, DEREGISTRATION_PROTECTION_FIELD, IMAGE_ID_FIELD,
            LAUNCH_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AttributeValue description;

    private final AttributeValue kernelId;

    private final AttributeValue ramdiskId;

    private final AttributeValue sriovNetSupport;

    private final AttributeValue bootMode;

    private final AttributeValue tpmSupport;

    private final AttributeValue uefiData;

    private final AttributeValue lastLaunchedTime;

    private final AttributeValue imdsSupport;

    private final AttributeValue deregistrationProtection;

    private final String imageId;

    private final List<LaunchPermission> launchPermissions;

    private final List<ProductCode> productCodes;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private DescribeImageAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.bootMode = builder.bootMode;
        this.tpmSupport = builder.tpmSupport;
        this.uefiData = builder.uefiData;
        this.lastLaunchedTime = builder.lastLaunchedTime;
        this.imdsSupport = builder.imdsSupport;
        this.deregistrationProtection = builder.deregistrationProtection;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.blockDeviceMappings = builder.blockDeviceMappings;
    }

    /**
     * <p>
     * A description for the AMI.
     * </p>
     * 
     * @return A description for the AMI.
     */
    public final AttributeValue description() {
        return description;
    }

    /**
     * <p>
     * The kernel ID.
     * </p>
     * 
     * @return The kernel ID.
     */
    public final AttributeValue kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The RAM disk ID.
     * </p>
     * 
     * @return The RAM disk ID.
     */
    public final AttributeValue ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public final AttributeValue sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The boot mode.
     * </p>
     * 
     * @return The boot mode.
     */
    public final AttributeValue bootMode() {
        return bootMode;
    }

    /**
     * <p>
     * If the image is configured for NitroTPM support, the value is <code>v2.0</code>.
     * </p>
     * 
     * @return If the image is configured for NitroTPM support, the value is <code>v2.0</code>.
     */
    public final AttributeValue tpmSupport() {
        return tpmSupport;
    }

    /**
     * <p>
     * Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
     * command. You can inspect and modify the UEFI data by using the <a
     * href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
     *         href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
     *         command. You can inspect and modify the UEFI data by using the <a
     *         href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more
     *         information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI
     *         Secure Boot</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final AttributeValue uefiData() {
        return uefiData;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the AMI was
     * last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before
     * that usage is reported.
     * </p>
     * <note>
     * <p>
     * <code>lastLaunchedTime</code> data is available starting April 2017.
     * </p>
     * </note>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a
     *         24-hour delay before that usage is reported.</p> <note>
     *         <p>
     *         <code>lastLaunchedTime</code> data is available starting April 2017.
     *         </p>
     */
    public final AttributeValue lastLaunchedTime() {
        return lastLaunchedTime;
    }

    /**
     * <p>
     * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
     * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
     * requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code>
     * is set to <code>2</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI
     *         will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
     *         instance requires that IMDSv2 is used when requesting instance metadata. In addition,
     *         <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     *         >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final AttributeValue imdsSupport() {
        return imdsSupport;
    }

    /**
     * <p>
     * Indicates whether deregistration protection is enabled for the AMI.
     * </p>
     * 
     * @return Indicates whether deregistration protection is enabled for the AMI.
     */
    public final AttributeValue deregistrationProtection() {
        return deregistrationProtection;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchPermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLaunchPermissions() {
        return launchPermissions != null && !(launchPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchPermissions} method.
     * </p>
     * 
     * @return The launch permissions.
     */
    public final List<LaunchPermission> launchPermissions() {
        return launchPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return The product codes.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mapping entries.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(bootMode());
        hashCode = 31 * hashCode + Objects.hashCode(tpmSupport());
        hashCode = 31 * hashCode + Objects.hashCode(uefiData());
        hashCode = 31 * hashCode + Objects.hashCode(lastLaunchedTime());
        hashCode = 31 * hashCode + Objects.hashCode(imdsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(deregistrationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchPermissions() ? launchPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeResponse)) {
            return false;
        }
        DescribeImageAttributeResponse other = (DescribeImageAttributeResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(ramdiskId(), other.ramdiskId()) && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(bootMode(), other.bootMode()) && Objects.equals(tpmSupport(), other.tpmSupport())
                && Objects.equals(uefiData(), other.uefiData()) && Objects.equals(lastLaunchedTime(), other.lastLaunchedTime())
                && Objects.equals(imdsSupport(), other.imdsSupport())
                && Objects.equals(deregistrationProtection(), other.deregistrationProtection())
                && Objects.equals(imageId(), other.imageId()) && hasLaunchPermissions() == other.hasLaunchPermissions()
                && Objects.equals(launchPermissions(), other.launchPermissions()) && hasProductCodes() == other.hasProductCodes()
                && Objects.equals(productCodes(), other.productCodes())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageAttributeResponse").add("Description", description()).add("KernelId", kernelId())
                .add("RamdiskId", ramdiskId()).add("SriovNetSupport", sriovNetSupport()).add("BootMode", bootMode())
                .add("TpmSupport", tpmSupport()).add("UefiData", uefiData()).add("LastLaunchedTime", lastLaunchedTime())
                .add("ImdsSupport", imdsSupport()).add("DeregistrationProtection", deregistrationProtection())
                .add("ImageId", imageId()).add("LaunchPermissions", hasLaunchPermissions() ? launchPermissions() : null)
                .add("ProductCodes", hasProductCodes() ? productCodes() : null)
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "BootMode":
            return Optional.ofNullable(clazz.cast(bootMode()));
        case "TpmSupport":
            return Optional.ofNullable(clazz.cast(tpmSupport()));
        case "UefiData":
            return Optional.ofNullable(clazz.cast(uefiData()));
        case "LastLaunchedTime":
            return Optional.ofNullable(clazz.cast(lastLaunchedTime()));
        case "ImdsSupport":
            return Optional.ofNullable(clazz.cast(imdsSupport()));
        case "DeregistrationProtection":
            return Optional.ofNullable(clazz.cast(deregistrationProtection()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "LaunchPermissions":
            return Optional.ofNullable(clazz.cast(launchPermissions()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Kernel", KERNEL_ID_FIELD);
        map.put("Ramdisk", RAMDISK_ID_FIELD);
        map.put("SriovNetSupport", SRIOV_NET_SUPPORT_FIELD);
        map.put("BootMode", BOOT_MODE_FIELD);
        map.put("TpmSupport", TPM_SUPPORT_FIELD);
        map.put("UefiData", UEFI_DATA_FIELD);
        map.put("LastLaunchedTime", LAST_LAUNCHED_TIME_FIELD);
        map.put("ImdsSupport", IMDS_SUPPORT_FIELD);
        map.put("DeregistrationProtection", DEREGISTRATION_PROTECTION_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("LaunchPermission", LAUNCH_PERMISSIONS_FIELD);
        map.put("ProductCodes", PRODUCT_CODES_FIELD);
        map.put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageAttributeResponse, T> g) {
        return obj -> g.apply((DescribeImageAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageAttributeResponse> {
        /**
         * <p>
         * A description for the AMI.
         * </p>
         * 
         * @param description
         *        A description for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(AttributeValue description);

        /**
         * <p>
         * A description for the AMI.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #description(AttributeValue)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(AttributeValue)
         */
        default Builder description(Consumer<AttributeValue.Builder> description) {
            return description(AttributeValue.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * The kernel ID.
         * </p>
         * 
         * @param kernelId
         *        The kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(AttributeValue kernelId);

        /**
         * <p>
         * The kernel ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #kernelId(AttributeValue)}.
         * 
         * @param kernelId
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelId(AttributeValue)
         */
        default Builder kernelId(Consumer<AttributeValue.Builder> kernelId) {
            return kernelId(AttributeValue.builder().applyMutation(kernelId).build());
        }

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(AttributeValue ramdiskId);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #ramdiskId(AttributeValue)}.
         * 
         * @param ramdiskId
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ramdiskId(AttributeValue)
         */
        default Builder ramdiskId(Consumer<AttributeValue.Builder> ramdiskId) {
            return ramdiskId(AttributeValue.builder().applyMutation(ramdiskId).build());
        }

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(AttributeValue sriovNetSupport);

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #sriovNetSupport(AttributeValue)}.
         * 
         * @param sriovNetSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sriovNetSupport(AttributeValue)
         */
        default Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return sriovNetSupport(AttributeValue.builder().applyMutation(sriovNetSupport).build());
        }

        /**
         * <p>
         * The boot mode.
         * </p>
         * 
         * @param bootMode
         *        The boot mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootMode(AttributeValue bootMode);

        /**
         * <p>
         * The boot mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #bootMode(AttributeValue)}.
         * 
         * @param bootMode
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bootMode(AttributeValue)
         */
        default Builder bootMode(Consumer<AttributeValue.Builder> bootMode) {
            return bootMode(AttributeValue.builder().applyMutation(bootMode).build());
        }

        /**
         * <p>
         * If the image is configured for NitroTPM support, the value is <code>v2.0</code>.
         * </p>
         * 
         * @param tpmSupport
         *        If the image is configured for NitroTPM support, the value is <code>v2.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tpmSupport(AttributeValue tpmSupport);

        /**
         * <p>
         * If the image is configured for NitroTPM support, the value is <code>v2.0</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #tpmSupport(AttributeValue)}.
         * 
         * @param tpmSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tpmSupport(AttributeValue)
         */
        default Builder tpmSupport(Consumer<AttributeValue.Builder> tpmSupport) {
            return tpmSupport(AttributeValue.builder().applyMutation(tpmSupport).build());
        }

        /**
         * <p>
         * Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
         * command. You can inspect and modify the UEFI data by using the <a
         * href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param uefiData
         *        Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
         *        href
         *        ="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData
         *        </a> command. You can inspect and modify the UEFI data by using the <a
         *        href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a>
         *        in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uefiData(AttributeValue uefiData);

        /**
         * <p>
         * Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data, use the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a>
         * command. You can inspect and modify the UEFI data by using the <a
         * href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on GitHub. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #uefiData(AttributeValue)}.
         * 
         * @param uefiData
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uefiData(AttributeValue)
         */
        default Builder uefiData(Consumer<AttributeValue.Builder> uefiData) {
            return uefiData(AttributeValue.builder().applyMutation(uefiData).build());
        }

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the AMI
         * was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay
         * before that usage is reported.
         * </p>
         * <note>
         * <p>
         * <code>lastLaunchedTime</code> data is available starting April 2017.
         * </p>
         * </note>
         * 
         * @param lastLaunchedTime
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a
         *        24-hour delay before that usage is reported.</p> <note>
         *        <p>
         *        <code>lastLaunchedTime</code> data is available starting April 2017.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastLaunchedTime(AttributeValue lastLaunchedTime);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the AMI
         * was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay
         * before that usage is reported.
         * </p>
         * <note>
         * <p>
         * <code>lastLaunchedTime</code> data is available starting April 2017.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding
         * the need to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #lastLaunchedTime(AttributeValue)}.
         * 
         * @param lastLaunchedTime
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastLaunchedTime(AttributeValue)
         */
        default Builder lastLaunchedTime(Consumer<AttributeValue.Builder> lastLaunchedTime) {
            return lastLaunchedTime(AttributeValue.builder().applyMutation(lastLaunchedTime).build());
        }

        /**
         * <p>
         * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
         * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
         * requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param imdsSupport
         *        If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this
         *        AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default,
         *        the instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         *        <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         *        >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imdsSupport(AttributeValue imdsSupport);

        /**
         * <p>
         * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
         * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
         * requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #imdsSupport(AttributeValue)}.
         * 
         * @param imdsSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imdsSupport(AttributeValue)
         */
        default Builder imdsSupport(Consumer<AttributeValue.Builder> imdsSupport) {
            return imdsSupport(AttributeValue.builder().applyMutation(imdsSupport).build());
        }

        /**
         * <p>
         * Indicates whether deregistration protection is enabled for the AMI.
         * </p>
         * 
         * @param deregistrationProtection
         *        Indicates whether deregistration protection is enabled for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregistrationProtection(AttributeValue deregistrationProtection);

        /**
         * <p>
         * Indicates whether deregistration protection is enabled for the AMI.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #deregistrationProtection(AttributeValue)}.
         * 
         * @param deregistrationProtection
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deregistrationProtection(AttributeValue)
         */
        default Builder deregistrationProtection(Consumer<AttributeValue.Builder> deregistrationProtection) {
            return deregistrationProtection(AttributeValue.builder().applyMutation(deregistrationProtection).build());
        }

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The launch permissions.
         * </p>
         * 
         * @param launchPermissions
         *        The launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermissions(Collection<LaunchPermission> launchPermissions);

        /**
         * <p>
         * The launch permissions.
         * </p>
         * 
         * @param launchPermissions
         *        The launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermissions(LaunchPermission... launchPermissions);

        /**
         * <p>
         * The launch permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.LaunchPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #launchPermissions(List<LaunchPermission>)}.
         * 
         * @param launchPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchPermissions(java.util.Collection<LaunchPermission>)
         */
        Builder launchPermissions(Consumer<LaunchPermission.Builder>... launchPermissions);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private AttributeValue description;

        private AttributeValue kernelId;

        private AttributeValue ramdiskId;

        private AttributeValue sriovNetSupport;

        private AttributeValue bootMode;

        private AttributeValue tpmSupport;

        private AttributeValue uefiData;

        private AttributeValue lastLaunchedTime;

        private AttributeValue imdsSupport;

        private AttributeValue deregistrationProtection;

        private String imageId;

        private List<LaunchPermission> launchPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeResponse model) {
            super(model);
            description(model.description);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            sriovNetSupport(model.sriovNetSupport);
            bootMode(model.bootMode);
            tpmSupport(model.tpmSupport);
            uefiData(model.uefiData);
            lastLaunchedTime(model.lastLaunchedTime);
            imdsSupport(model.imdsSupport);
            deregistrationProtection(model.deregistrationProtection);
            imageId(model.imageId);
            launchPermissions(model.launchPermissions);
            productCodes(model.productCodes);
            blockDeviceMappings(model.blockDeviceMappings);
        }

        public final AttributeValue.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final AttributeValue.Builder getKernelId() {
            return kernelId != null ? kernelId.toBuilder() : null;
        }

        public final void setKernelId(AttributeValue.BuilderImpl kernelId) {
            this.kernelId = kernelId != null ? kernelId.build() : null;
        }

        @Override
        public final Builder kernelId(AttributeValue kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final AttributeValue.Builder getRamdiskId() {
            return ramdiskId != null ? ramdiskId.toBuilder() : null;
        }

        public final void setRamdiskId(AttributeValue.BuilderImpl ramdiskId) {
            this.ramdiskId = ramdiskId != null ? ramdiskId.build() : null;
        }

        @Override
        public final Builder ramdiskId(AttributeValue ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return sriovNetSupport != null ? sriovNetSupport.toBuilder() : null;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final AttributeValue.Builder getBootMode() {
            return bootMode != null ? bootMode.toBuilder() : null;
        }

        public final void setBootMode(AttributeValue.BuilderImpl bootMode) {
            this.bootMode = bootMode != null ? bootMode.build() : null;
        }

        @Override
        public final Builder bootMode(AttributeValue bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        public final AttributeValue.Builder getTpmSupport() {
            return tpmSupport != null ? tpmSupport.toBuilder() : null;
        }

        public final void setTpmSupport(AttributeValue.BuilderImpl tpmSupport) {
            this.tpmSupport = tpmSupport != null ? tpmSupport.build() : null;
        }

        @Override
        public final Builder tpmSupport(AttributeValue tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        public final AttributeValue.Builder getUefiData() {
            return uefiData != null ? uefiData.toBuilder() : null;
        }

        public final void setUefiData(AttributeValue.BuilderImpl uefiData) {
            this.uefiData = uefiData != null ? uefiData.build() : null;
        }

        @Override
        public final Builder uefiData(AttributeValue uefiData) {
            this.uefiData = uefiData;
            return this;
        }

        public final AttributeValue.Builder getLastLaunchedTime() {
            return lastLaunchedTime != null ? lastLaunchedTime.toBuilder() : null;
        }

        public final void setLastLaunchedTime(AttributeValue.BuilderImpl lastLaunchedTime) {
            this.lastLaunchedTime = lastLaunchedTime != null ? lastLaunchedTime.build() : null;
        }

        @Override
        public final Builder lastLaunchedTime(AttributeValue lastLaunchedTime) {
            this.lastLaunchedTime = lastLaunchedTime;
            return this;
        }

        public final AttributeValue.Builder getImdsSupport() {
            return imdsSupport != null ? imdsSupport.toBuilder() : null;
        }

        public final void setImdsSupport(AttributeValue.BuilderImpl imdsSupport) {
            this.imdsSupport = imdsSupport != null ? imdsSupport.build() : null;
        }

        @Override
        public final Builder imdsSupport(AttributeValue imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        public final AttributeValue.Builder getDeregistrationProtection() {
            return deregistrationProtection != null ? deregistrationProtection.toBuilder() : null;
        }

        public final void setDeregistrationProtection(AttributeValue.BuilderImpl deregistrationProtection) {
            this.deregistrationProtection = deregistrationProtection != null ? deregistrationProtection.build() : null;
        }

        @Override
        public final Builder deregistrationProtection(AttributeValue deregistrationProtection) {
            this.deregistrationProtection = deregistrationProtection;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final List<LaunchPermission.Builder> getLaunchPermissions() {
            List<LaunchPermission.Builder> result = LaunchPermissionListCopier.copyToBuilder(this.launchPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission.BuilderImpl> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copyFromBuilder(launchPermissions);
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission... launchPermissions) {
            launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(Consumer<LaunchPermission.Builder>... launchPermissions) {
            launchPermissions(Stream.of(launchPermissions).map(c -> LaunchPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageAttributeResponse build() {
            return new DescribeImageAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
