/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeNetworkInterfaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkInterfacesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeNetworkInterfacesRequest.Builder, DescribeNetworkInterfacesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeNetworkInterfacesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeNetworkInterfacesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeNetworkInterfacesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaceIds")
            .getter(getter(DescribeNetworkInterfacesRequest::networkInterfaceIds))
            .setter(setter(Builder::networkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeNetworkInterfacesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, DRY_RUN_FIELD, NETWORK_INTERFACE_IDS_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean dryRun;

    private final List<String> networkInterfaceIds;

    private final List<Filter> filters;

    private DescribeNetworkInterfacesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.dryRun = builder.dryRun;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. You cannot specify this parameter and the network interface IDs parameter in
     * the same request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. You cannot specify this parameter and the network
     *         interface IDs parameter in the same request. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaceIds() {
        return networkInterfaceIds != null && !(networkInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interface IDs.
     * </p>
     * <p>
     * Default: Describes all your network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaceIds} method.
     * </p>
     * 
     * @return The network interface IDs.</p>
     *         <p>
     *         Default: Describes all your network interfaces.
     */
    public final List<String> networkInterfaceIds() {
        return networkInterfaceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
     * (IPv4) for your network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.association-id</code> - The association ID returned when the network interface was associated
     * with an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
     * associated with the Elastic IP address (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.attachment-id</code> - The ID of the interface attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is
     * terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.device-index</code> - The device index to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> |
     * <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>description</code> - The description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
     * <code>aws_codestar_connections_managed</code> | <code>branch</code> | <code>ec2_instance_connect_endpoint</code>
     * | <code>efa</code> | <code>efa-only</code> | <code>efs</code> | <code>gateway_load_balancer</code> |
     * <code>gateway_load_balancer_endpoint</code> | <code>global_accelerator_managed</code> | <code>interface</code> |
     * <code>iot_rules_managed</code> | <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
     * <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> | <code>trunk</code>
     * | <code>vpc_endpoint</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mac-address</code> - The MAC address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>operator.principal</code> - The principal that manages the network interface. Only valid for managed
     * network interfaces, where <code>managed</code> is <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that created
     * the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon Web
     * Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-dest-check</code> - Indicates whether the network interface performs source/destination checking. A
     * value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The
     * value must be <code>false</code> for the network interface to perform network address translation (NAT) in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the network interface. If the network interface is not attached to an
     * instance, the status is <code>available</code>; if a network interface is attached to an instance the status is
     * <code>in-use</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the network interface.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
     *         address (IPv4) for your network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.association-id</code> - The association ID returned when the network interface was
     *         associated with an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
     *         associated with the Elastic IP address (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
     *         with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.attachment-id</code> - The ID of the interface attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
     *         instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.device-index</code> - The device index to which the network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface
     *         is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of a security group associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
     *         <code>aws_codestar_connections_managed</code> | <code>branch</code> |
     *         <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efa-only</code> | <code>efs</code>
     *         | <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> |
     *         <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> |
     *         <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
     *         <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> |
     *         <code>trunk</code> | <code>vpc_endpoint</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mac-address</code> - The MAC address of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>operator.principal</code> - The principal that manages the network interface. Only valid for
     *         managed network interfaces, where <code>managed</code> is <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that
     *         created the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon
     *         Web Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-dest-check</code> - Indicates whether the network interface performs source/destination
     *         checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking
     *         is disabled. The value must be <code>false</code> for the network interface to perform network address
     *         translation (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the network interface. If the network interface is not attached to an
     *         instance, the status is <code>available</code>; if a network interface is attached to an instance the
     *         status is <code>in-use</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the network interface.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaceIds() ? networkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesRequest)) {
            return false;
        }
        DescribeNetworkInterfacesRequest other = (DescribeNetworkInterfacesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(dryRun(), other.dryRun()) && hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds()
                && Objects.equals(networkInterfaceIds(), other.networkInterfaceIds()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNetworkInterfacesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("DryRun", dryRun()).add("NetworkInterfaceIds", hasNetworkInterfaceIds() ? networkInterfaceIds() : null)
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(networkInterfaceIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_IDS_FIELD);
        map.put("Filter", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfacesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInterfacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNetworkInterfacesRequest> {
        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. You cannot specify this parameter and the network interface IDs
         * parameter in the same request. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. You cannot specify this parameter and the network
         *        interface IDs parameter in the same request. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The network interface IDs.
         * </p>
         * <p>
         * Default: Describes all your network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        The network interface IDs.</p>
         *        <p>
         *        Default: Describes all your network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(Collection<String> networkInterfaceIds);

        /**
         * <p>
         * The network interface IDs.
         * </p>
         * <p>
         * Default: Describes all your network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        The network interface IDs.</p>
         *        <p>
         *        Default: Describes all your network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(String... networkInterfaceIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
         * <code>aws_codestar_connections_managed</code> | <code>branch</code> |
         * <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efa-only</code> | <code>efs</code> |
         * <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> |
         * <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> |
         * <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
         * <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> |
         * <code>trunk</code> | <code>vpc_endpoint</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.principal</code> - The principal that manages the network interface. Only valid for managed
         * network interfaces, where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that
         * created the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon Web
         * Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
         *        address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The association ID returned when the network interface was
         *        associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.public-ip</code> - The association ID returned when the network interface
         *        was associated with the Elastic IP address (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
         *        with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
         *        instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device-index</code> - The device index to which the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
         *        <code>aws_codestar_connections_managed</code> | <code>branch</code> |
         *        <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efa-only</code> |
         *        <code>efs</code> | <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> |
         *        <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> |
         *        <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
         *        <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> |
         *        <code>trunk</code> | <code>vpc_endpoint</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.principal</code> - The principal that manages the network interface. Only valid for
         *        managed network interfaces, where <code>managed</code> is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service
         *        that created the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon
         *        Web Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the network interface performs source/destination
         *        checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means
         *        checking is disabled. The value must be <code>false</code> for the network interface to perform
         *        network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the network interface. If the network interface is not attached to
         *        an instance, the status is <code>available</code>; if a network interface is attached to an instance
         *        the status is <code>in-use</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
         * <code>aws_codestar_connections_managed</code> | <code>branch</code> |
         * <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efa-only</code> | <code>efs</code> |
         * <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> |
         * <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> |
         * <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
         * <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> |
         * <code>trunk</code> | <code>vpc_endpoint</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.principal</code> - The principal that manages the network interface. Only valid for managed
         * network interfaces, where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that
         * created the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon Web
         * Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
         *        address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The association ID returned when the network interface was
         *        associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.public-ip</code> - The association ID returned when the network interface
         *        was associated with the Elastic IP address (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
         *        with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
         *        instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device-index</code> - The device index to which the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
         *        <code>aws_codestar_connections_managed</code> | <code>branch</code> |
         *        <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efa-only</code> |
         *        <code>efs</code> | <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> |
         *        <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> |
         *        <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
         *        <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> |
         *        <code>trunk</code> | <code>vpc_endpoint</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.principal</code> - The principal that manages the network interface. Only valid for
         *        managed network interfaces, where <code>managed</code> is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service
         *        that created the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon
         *        Web Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the network interface performs source/destination
         *        checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means
         *        checking is disabled. The value must be <code>false</code> for the network interface to perform
         *        network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the network interface. If the network interface is not attached to
         *        an instance, the status is <code>available</code>; if a network interface is attached to an instance
         *        the status is <code>in-use</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>interface-type</code> - The type of network interface (<code>api_gateway_managed</code> |
         * <code>aws_codestar_connections_managed</code> | <code>branch</code> |
         * <code>ec2_instance_connect_endpoint</code> | <code>efa</code> | <code>efa-only</code> | <code>efs</code> |
         * <code>gateway_load_balancer</code> | <code>gateway_load_balancer_endpoint</code> |
         * <code>global_accelerator_managed</code> | <code>interface</code> | <code>iot_rules_managed</code> |
         * <code>lambda</code> | <code>load_balancer</code> | <code>nat_gateway</code> |
         * <code>network_load_balancer</code> | <code>quicksight</code> | <code>transit_gateway</code> |
         * <code>trunk</code> | <code>vpc_endpoint</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.managed</code> - A Boolean that indicates whether this is a managed network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.principal</code> - The principal that manages the network interface. Only valid for managed
         * network interfaces, where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that
         * created the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon Web
         * Services service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Boolean dryRun;

        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            dryRun(model.dryRun);
            networkInterfaceIds(model.networkInterfaceIds);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String... networkInterfaceIds) {
            networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInterfacesRequest build() {
            return new DescribeNetworkInterfacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
