/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddressesAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeAddressesAttributeRequest.Builder, DescribeAddressesAttributeRequest> {
    private static final SdkField<List<String>> ALLOCATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllocationIds")
            .getter(getter(DescribeAddressesAttributeRequest::allocationIds))
            .setter(setter(Builder::allocationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(DescribeAddressesAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeAddressesAttributeRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeAddressesAttributeRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeAddressesAttributeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_IDS_FIELD,
            ATTRIBUTE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> allocationIds;

    private final String attribute;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean dryRun;

    private DescribeAddressesAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.allocationIds = builder.allocationIds;
        this.attribute = builder.attribute;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllocationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllocationIds() {
        return allocationIds != null && !(allocationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [EC2-VPC] The allocation IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllocationIds} method.
     * </p>
     * 
     * @return [EC2-VPC] The allocation IDs.
     */
    public final List<String> allocationIds() {
        return allocationIds;
    }

    /**
     * <p>
     * The attribute of the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link AddressAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute of the IP address.
     * @see AddressAttributeName
     */
    public final AddressAttributeName attribute() {
        return AddressAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute of the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link AddressAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute of the IP address.
     * @see AddressAttributeName
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAllocationIds() ? allocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesAttributeRequest)) {
            return false;
        }
        DescribeAddressesAttributeRequest other = (DescribeAddressesAttributeRequest) obj;
        return hasAllocationIds() == other.hasAllocationIds() && Objects.equals(allocationIds(), other.allocationIds())
                && Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAddressesAttributeRequest")
                .add("AllocationIds", hasAllocationIds() ? allocationIds() : null).add("Attribute", attributeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationIds":
            return Optional.ofNullable(clazz.cast(allocationIds()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocationId", ALLOCATION_IDS_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressesAttributeRequest, T> g) {
        return obj -> g.apply((DescribeAddressesAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddressesAttributeRequest> {
        /**
         * <p>
         * [EC2-VPC] The allocation IDs.
         * </p>
         * 
         * @param allocationIds
         *        [EC2-VPC] The allocation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationIds(Collection<String> allocationIds);

        /**
         * <p>
         * [EC2-VPC] The allocation IDs.
         * </p>
         * 
         * @param allocationIds
         *        [EC2-VPC] The allocation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationIds(String... allocationIds);

        /**
         * <p>
         * The attribute of the IP address.
         * </p>
         * 
         * @param attribute
         *        The attribute of the IP address.
         * @see AddressAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute of the IP address.
         * </p>
         * 
         * @param attribute
         *        The attribute of the IP address.
         * @see AddressAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressAttributeName
         */
        Builder attribute(AddressAttributeName attribute);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> allocationIds = DefaultSdkAutoConstructList.getInstance();

        private String attribute;

        private String nextToken;

        private Integer maxResults;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesAttributeRequest model) {
            super(model);
            allocationIds(model.allocationIds);
            attribute(model.attribute);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            dryRun(model.dryRun);
        }

        public final Collection<String> getAllocationIds() {
            if (allocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return allocationIds;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdsCopier.copy(allocationIds);
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdsCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String... allocationIds) {
            allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(AddressAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAddressesAttributeRequest build() {
            return new DescribeAddressesAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
