/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLaunchTemplatesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeLaunchTemplatesResponse.Builder, DescribeLaunchTemplatesResponse> {
    private static final SdkField<List<LaunchTemplate>> LAUNCH_TEMPLATES_FIELD = SdkField
            .<List<LaunchTemplate>> builder(MarshallingType.LIST)
            .memberName("LaunchTemplates")
            .getter(getter(DescribeLaunchTemplatesResponse::launchTemplates))
            .setter(setter(Builder::launchTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplates")
                    .unmarshallLocationName("launchTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeLaunchTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LaunchTemplate> launchTemplates;

    private final String nextToken;

    private DescribeLaunchTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplates = builder.launchTemplates;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchTemplates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLaunchTemplates() {
        return launchTemplates != null && !(launchTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the launch templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchTemplates} method.
     * </p>
     * 
     * @return Information about the launch templates.
     */
    public final List<LaunchTemplate> launchTemplates() {
        return launchTemplates;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplates() ? launchTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplatesResponse)) {
            return false;
        }
        DescribeLaunchTemplatesResponse other = (DescribeLaunchTemplatesResponse) obj;
        return hasLaunchTemplates() == other.hasLaunchTemplates() && Objects.equals(launchTemplates(), other.launchTemplates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLaunchTemplatesResponse")
                .add("LaunchTemplates", hasLaunchTemplates() ? launchTemplates() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplates":
            return Optional.ofNullable(clazz.cast(launchTemplates()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LaunchTemplates", LAUNCH_TEMPLATES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeLaunchTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLaunchTemplatesResponse> {
        /**
         * <p>
         * Information about the launch templates.
         * </p>
         * 
         * @param launchTemplates
         *        Information about the launch templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplates(Collection<LaunchTemplate> launchTemplates);

        /**
         * <p>
         * Information about the launch templates.
         * </p>
         * 
         * @param launchTemplates
         *        Information about the launch templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplates(LaunchTemplate... launchTemplates);

        /**
         * <p>
         * Information about the launch templates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.LaunchTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #launchTemplates(List<LaunchTemplate>)}.
         * 
         * @param launchTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplates(java.util.Collection<LaunchTemplate>)
         */
        Builder launchTemplates(Consumer<LaunchTemplate.Builder>... launchTemplates);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<LaunchTemplate> launchTemplates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplatesResponse model) {
            super(model);
            launchTemplates(model.launchTemplates);
            nextToken(model.nextToken);
        }

        public final List<LaunchTemplate.Builder> getLaunchTemplates() {
            List<LaunchTemplate.Builder> result = LaunchTemplateSetCopier.copyToBuilder(this.launchTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplates(Collection<LaunchTemplate.BuilderImpl> launchTemplates) {
            this.launchTemplates = LaunchTemplateSetCopier.copyFromBuilder(launchTemplates);
        }

        @Override
        public final Builder launchTemplates(Collection<LaunchTemplate> launchTemplates) {
            this.launchTemplates = LaunchTemplateSetCopier.copy(launchTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(LaunchTemplate... launchTemplates) {
            launchTemplates(Arrays.asList(launchTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(Consumer<LaunchTemplate.Builder>... launchTemplates) {
            launchTemplates(Stream.of(launchTemplates).map(c -> LaunchTemplate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLaunchTemplatesResponse build() {
            return new DescribeLaunchTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
